/*
 * Decompiled with CFR 0.152.
 */
package ECDH;

import ECDH.ECCAlgorithm;
import ECDH.ECCUtils;
import ECDH._ExternBase___default;
import StandardLibraryInternal.InternalResult;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.KeyAgreement;
import software.amazon.cryptography.primitives.ToDafny;
import software.amazon.cryptography.primitives.internaldafny.types.ECCPrivateKey;
import software.amazon.cryptography.primitives.internaldafny.types.ECCPublicKey;
import software.amazon.cryptography.primitives.internaldafny.types.ECDHCurveSpec;
import software.amazon.cryptography.primitives.internaldafny.types.Error;
import software.amazon.cryptography.primitives.model.AwsCryptographicPrimitivesError;

public class DeriveSharedSecret
extends _ExternBase___default {
    public static Result<DafnySequence<? extends Byte>, Error> CalculateSharedSecret(ECDHCurveSpec dtor_eccAlgorithm, ECCPrivateKey dtor_privateKey, ECCPublicKey dtro_publicKey) {
        ECCUtils.checkBCProvider();
        byte[] privateKeyBytes = ECCUtils.dafnyArrayUnWrapper(dtor_privateKey._pem);
        byte[] publicKeyBytes = ECCUtils.dafnyArrayUnWrapper(dtro_publicKey._der);
        InternalResult<ECCAlgorithm, Error> maybeEccAlgorithm = ECCAlgorithm.eccAlgorithm(dtor_eccAlgorithm);
        if (maybeEccAlgorithm.isFailure()) {
            return DeriveSharedSecret.CreateExternDerivesharedSecretError(maybeEccAlgorithm.error());
        }
        if (!maybeEccAlgorithm.value().curve.equals("SM2")) {
            try {
                KeyAgreement keyAgreement = KeyAgreement.getInstance("ECDH", "BC");
                keyAgreement.init((Key)ECCUtils.parsePrivateKeyEccPemBytesToPrivateKey(privateKeyBytes), new SecureRandom());
                keyAgreement.doPhase(DeriveSharedSecret.fromBytesPublicKey(publicKeyBytes), true);
                byte[] sharedSecret = keyAgreement.generateSecret();
                return DeriveSharedSecret.CreateExternDerivesharedSecretSuccess((DafnySequence<? extends Byte>)DafnySequence.fromBytes((byte[])sharedSecret));
            }
            catch (Exception e) {
                return DeriveSharedSecret.CreateExternDerivesharedSecretError(ToDafny.Error(AwsCryptographicPrimitivesError.builder().cause(e).message(e.getMessage()).build()));
            }
        }
        return DeriveSharedSecret.CreateExternDerivesharedSecretError(ToDafny.Error(new RuntimeException("SM2 Not yet Supported.")));
    }

    private static PublicKey fromBytesPublicKey(byte[] publicKeyBytes) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance("EC", "BC");
        return keyFactory.generatePublic(new X509EncodedKeySpec(publicKeyBytes));
    }
}

