/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class SparkStringUtils$
implements Logging {
    public static final SparkStringUtils$ MODULE$ = new SparkStringUtils$();
    private static final AtomicBoolean truncationWarningPrinted;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        truncationWarningPrinted = new AtomicBoolean(false);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private AtomicBoolean truncationWarningPrinted() {
        return truncationWarningPrinted;
    }

    public <T> String truncatedString(Seq<T> seq, String start, String sep, String end, int maxFields) {
        String string;
        if (seq.length() > maxFields) {
            if (this.truncationWarningPrinted().compareAndSet(false, true)) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(75).append("Truncated the string representation of a plan since it was too large. This ").append("behavior can be adjusted by setting 'spark.sql.debug.maxToStringFields'.").toString());
            }
            int numFields = package$.MODULE$.max(0, maxFields - 1);
            string = ((IterableOnceOps)seq.take(numFields)).mkString(start, sep, new StringBuilder(16).append(sep).append("... ").append(seq.length() - numFields).append(" more fields").append(end).toString());
        } else {
            string = seq.mkString(start, sep, end);
        }
        return string;
    }

    public <T> String truncatedString(Seq<T> seq, String sep, int maxFields) {
        return this.truncatedString(seq, "", sep, "", maxFields);
    }

    public String getHexString(byte[] bytes) {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.byteArrayOps(bytes), (Function1 & Serializable)x$1 -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%02X"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)x$1))})), ClassTag$.MODULE$.apply(String.class))).mkString("[", " ", "]");
    }

    public Seq<String> sideBySide(String left, String right) {
        return this.sideBySide((Seq<String>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)left.split("\n")), (Seq<String>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)right.split("\n")));
    }

    public Seq<String> sideBySide(Seq<String> left, Seq<String> right) {
        int maxLeftSize = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)left.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.length()))).max((Ordering)Ordering.Int$.MODULE$));
        Seq leftPadded = (Seq)left.$plus$plus((IterableOnce)scala.package$.MODULE$.Seq().fill(package$.MODULE$.max(right.size() - left.size(), 0), (Function0 & Serializable)() -> ""));
        Seq rightPadded = (Seq)right.$plus$plus((IterableOnce)scala.package$.MODULE$.Seq().fill(package$.MODULE$.max(left.size() - right.size(), 0), (Function0 & Serializable)() -> ""));
        return (Seq)((IterableOps)leftPadded.zip((IterableOnce)rightPadded)).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String l = (String)tuple2._1();
            String r = (String)tuple2._2();
            String string = l;
            String string2 = r;
            String string3 = new StringBuilder(0).append(!(string != null ? !string.equals(string2) : string2 != null) ? " " : "!").append(l).append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), maxLeftSize - l.length() + 3)).append(r).toString();
            return string3;
        });
    }

    private SparkStringUtils$() {
    }
}

