/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class Version
implements Comparable<Version> {
    private String version;
    private boolean snapshot;
    private List<Object> comparable;

    public Version(String version) {
        this.version = version;
        this.comparable = new ArrayList<Object>();
        String[] parts = version.split("\\.", 5);
        int length = parts.length;
        this.snapshot = parts[length - 1].endsWith("-SNAPSHOT");
        if (this.snapshot) {
            parts[length - 1] = parts[length - 1].replaceAll("-SNAPSHOT", "");
        }
        for (String part : parts) {
            Integer value = Version.tryParseInt(part);
            if (value != null) {
                this.comparable.add(value);
                continue;
            }
            this.comparable.add(part);
        }
    }

    @Override
    public int compareTo(Version otherVersion) {
        Comp comp = new Comp();
        List<Object> other = otherVersion.comparable;
        int currentSize = this.comparable.size();
        int otherSize = other.size();
        int size = Math.min(currentSize, otherSize);
        for (int i = 0; i < size; ++i) {
            int ret = comp.compare(this.comparable.get(i), other.get(i));
            if (ret == 0) continue;
            return ret;
        }
        return Integer.compare(currentSize, otherSize);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.compareTo((Version)o) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.comparable);
    }

    public int getMajorVersion() {
        return this.get(0);
    }

    public int getMinorVersion() {
        return this.get(1);
    }

    public int getIncrementalVersion() {
        return this.get(2);
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    private int get(int index) {
        Object c;
        if (this.comparable.size() > index && (c = this.comparable.get(index)) instanceof Integer) {
            return (Integer)c;
        }
        return 0;
    }

    private static Integer tryParseInt(String s) {
        try {
            long longValue = Long.parseLong(s);
            if (longValue > Integer.MAX_VALUE) {
                return null;
            }
            return (int)longValue;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public String toString() {
        return this.version;
    }

    private static final class Comp
    implements Comparator<Object>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private Comp() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof Integer) {
                if (o2 instanceof Integer) {
                    return ((Integer)o1).compareTo((Integer)o2);
                }
                return -1;
            }
            if (o2 instanceof Integer) {
                return 1;
            }
            return ((String)o1).compareTo((String)o2);
        }
    }
}

