/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.ranker.normalizer;

import com.o19s.es.ltr.ranker.LtrRanker;
import com.o19s.es.ltr.ranker.normalizer.Normalizer;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;

public class FeatureNormalizingRanker
implements LtrRanker,
Accountable {
    private final LtrRanker wrapped;
    private final Map<Integer, Normalizer> ftrNorms;
    private static final long BASE_RAM_USED = RamUsageEstimator.shallowSizeOfInstance(FeatureNormalizingRanker.class);
    private static final long PER_FTR_NORM_RAM_USED = 8L;

    public FeatureNormalizingRanker(LtrRanker wrapped, Map<Integer, Normalizer> ftrNorms) {
        this.wrapped = Objects.requireNonNull(wrapped);
        this.ftrNorms = Objects.requireNonNull(ftrNorms);
    }

    public Map<Integer, Normalizer> getFtrNorms() {
        return this.ftrNorms;
    }

    @Override
    public String name() {
        return this.wrapped.name();
    }

    @Override
    public LtrRanker.FeatureVector newFeatureVector(LtrRanker.FeatureVector reuse) {
        return this.wrapped.newFeatureVector(reuse);
    }

    @Override
    public float score(LtrRanker.FeatureVector point) {
        for (Map.Entry<Integer, Normalizer> ordToNorm : this.ftrNorms.entrySet()) {
            int ord = ordToNorm.getKey();
            float origFtrScore = point.getFeatureScore(ord);
            float normed = ordToNorm.getValue().normalize(origFtrScore);
            point.setFeatureScore(ord, normed);
        }
        return this.wrapped.score(point);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof FeatureNormalizingRanker)) {
            return false;
        }
        FeatureNormalizingRanker that = (FeatureNormalizingRanker)other;
        if (that == null) {
            return false;
        }
        if (!that.ftrNorms.equals(this.ftrNorms)) {
            return false;
        }
        return that.wrapped.equals(this.wrapped);
    }

    public int hashCode() {
        return this.wrapped.hashCode() + 31 * this.ftrNorms.hashCode();
    }

    public long ramBytesUsed() {
        long ftrNormSize = (long)this.ftrNorms.size() * 8L;
        if (this.wrapped instanceof Accountable) {
            Accountable accountable = (Accountable)this.wrapped;
            return BASE_RAM_USED + accountable.ramBytesUsed() + ftrNormSize;
        }
        return BASE_RAM_USED + ftrNormSize;
    }
}

