/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.jsonUDF;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.runtime.JsonFunctions;
import org.apache.calcite.schema.impl.ScalarFunctionImpl;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.opensearch.sql.calcite.utils.PPLReturnTypes;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;
import org.opensearch.sql.expression.function.jsonUDF.JsonUtils;

public class JsonDeleteFunctionImpl
extends ImplementorUDF {
    public JsonDeleteFunctionImpl() {
        super(new JsonDeleteImplementor(), NullPolicy.ANY);
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return PPLReturnTypes.STRING_FORCE_NULLABLE;
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return null;
    }

    public static Object eval(Object ... args) throws JsonProcessingException {
        List<Object> jsonPaths = Arrays.asList(args).subList(1, args.length);
        String[] pathSpecs = (String[])jsonPaths.stream().map(Object::toString).map(JsonUtils::convertToJsonPath).toArray(String[]::new);
        return JsonFunctions.jsonRemove((String)args[0].toString(), (String[])pathSpecs);
    }

    public static class JsonDeleteImplementor
    implements NotNullImplementor {
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            ScalarFunctionImpl function = (ScalarFunctionImpl)ScalarFunctionImpl.create((Method)Types.lookupMethod(JsonDeleteFunctionImpl.class, (String)"eval", (Class[])new Class[]{Object[].class}));
            return function.getImplementor().implement(translator, call, RexImpTable.NullAs.NULL);
        }
    }
}

