/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.graphic.configuration;

import com.projectlibre1.configuration.Configuration;
import com.projectlibre1.configuration.Dictionary;
import com.projectlibre1.configuration.NamedItem;
import com.projectlibre1.field.Field;
import com.projectlibre1.graphic.configuration.ActionList;
import com.projectlibre1.graphic.configuration.ActionLists;
import com.projectlibre1.graphic.configuration.CellStyle;
import com.projectlibre1.graphic.configuration.CellStyles;
import com.projectlibre1.pm.assignment.TimeDistributedHelper;
import com.projectlibre1.strings.Messages;
import com.projectlibre1.workspace.WorkspaceSetting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.digester.Digester;

public class SpreadSheetFieldArray
extends ArrayList
implements NamedItem,
Cloneable,
WorkspaceSetting {
    private static final long serialVersionUID = 6310711336308730391L;
    transient Map map = new LinkedHashMap();
    transient boolean userCreated = false;
    ArrayList<Integer> widths = null;
    private String name = null;
    private String category;
    private String cellStyleId;
    private String actionListId;
    private String id = null;
    public String mapFieldTo;

    @Override
    public Object clone() {
        return super.clone();
    }

    public SpreadSheetFieldArray makeUserDefinedCopy() {
        SpreadSheetFieldArray spreadSheetFieldArray = (SpreadSheetFieldArray)this.clone();
        spreadSheetFieldArray.setId(null);
        spreadSheetFieldArray.setName(Dictionary.generateUniqueName(this));
        spreadSheetFieldArray.userCreated = true;
        return spreadSheetFieldArray;
    }

    public SpreadSheetFieldArray makeEditableVersion() {
        SpreadSheetFieldArray spreadSheetFieldArray = this;
        if (!spreadSheetFieldArray.isUserDefined()) {
            spreadSheetFieldArray = spreadSheetFieldArray.makeUserDefinedCopy();
            Dictionary.add(spreadSheetFieldArray);
        }
        return spreadSheetFieldArray;
    }

    public SpreadSheetFieldArray insertField(int n, Field field) {
        SpreadSheetFieldArray spreadSheetFieldArray = this.makeEditableVersion();
        spreadSheetFieldArray.add(n, field);
        return spreadSheetFieldArray;
    }

    public SpreadSheetFieldArray removeField(int n) {
        SpreadSheetFieldArray spreadSheetFieldArray = this.makeEditableVersion();
        spreadSheetFieldArray.remove(n);
        return spreadSheetFieldArray;
    }

    public SpreadSheetFieldArray move(int n, int n2) {
        SpreadSheetFieldArray spreadSheetFieldArray = this.makeEditableVersion();
        Field field = (Field)spreadSheetFieldArray.remove(n);
        SpreadSheetFieldArray spreadSheetFieldArray2 = spreadSheetFieldArray.insertField(n2, field);
        return spreadSheetFieldArray2;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof SpreadSheetFieldArray)) {
            return false;
        }
        return this.name == ((SpreadSheetFieldArray)object).getName();
    }

    public String getCellStyleId() {
        return this.cellStyleId;
    }

    public void setCellStyleId(String string) {
        this.cellStyleId = string;
    }

    public CellStyle getCellStyle() {
        CellStyles cellStyles = CellStyles.getInstance();
        if (this.cellStyleId == null || this.cellStyleId.length() == 0) {
            return cellStyles.getDefaultStyle();
        }
        CellStyle cellStyle = cellStyles.getStyle(this.cellStyleId);
        if (cellStyle == null) {
            cellStyle = cellStyles.getDefaultStyle();
        }
        return cellStyle;
    }

    public String getActionListId() {
        return this.actionListId;
    }

    public void setActionListId(String string) {
        this.actionListId = string;
    }

    public ActionList getActionList() {
        ActionLists actionLists = ActionLists.getInstance();
        if (this.actionListId == null || this.actionListId.length() == 0) {
            return actionLists.getDefaultActionList();
        }
        ActionList actionList = actionLists.getActionList(this.actionListId);
        if (actionList == null) {
            actionList = actionLists.getDefaultActionList();
        }
        return actionList;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setId(String string) {
        this.id = string;
        if (this.name == null) {
            this.setName(Messages.getString(string));
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String string) {
        this.category = string;
    }

    public boolean isUserDefined() {
        return this.id == null;
    }

    public void addField(String string) {
        Field field = Configuration.getFieldFromId(string);
        if (field != null) {
            if (this.mapFieldTo != null) {
                this.map.put(string, this.mapFieldTo);
                this.mapFieldTo = null;
            }
            this.add(field);
        }
    }

    public void removeField(String string) {
        if (string == null) {
            return;
        }
        this.map.remove(string);
        for (int i = 0; i < this.size(); ++i) {
            Field field = (Field)this.get(i);
            if (!string.equals(field.getId())) continue;
            this.remove(i);
        }
    }

    public static void addDigesterEvents(Digester digester) {
        digester.addObjectCreate("*/spreadsheet", "com.projectlibre1.graphic.configuration.SpreadSheetFieldArray");
        digester.addSetProperties("*/spreadsheet");
        digester.addSetNext("*/spreadsheet", "add", "com.projectlibre1.configuration.NamedItem");
        digester.addSetProperties("*/spreadsheet/columns/column");
        digester.addCallMethod("*/spreadsheet/columns/column", "addField", 0);
    }

    public Object next() {
        return null;
    }

    public static final SpreadSheetFieldArray getFromId(String string, String string2) {
        SpreadSheetFieldArray spreadSheetFieldArray = (SpreadSheetFieldArray)Dictionary.get(string, Messages.getString(string2));
        if (spreadSheetFieldArray == null) {
            spreadSheetFieldArray = (SpreadSheetFieldArray)Dictionary.get(string, string2);
        }
        return spreadSheetFieldArray;
    }

    public final String getMapFieldTo() {
        return this.mapFieldTo;
    }

    public final void setMapFieldTo(String string) {
        this.mapFieldTo = string;
    }

    public final String getMappedValue(String string) {
        return (String)this.map.get(string);
    }

    public static Object[] toIdArray(Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = TimeDistributedHelper.getIdForObject(objectArray[i]);
        }
        return objectArray2;
    }

    public static Object[] fromIdArray(Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = TimeDistributedHelper.getObjectFromId((String)objectArray[i]);
        }
        return objectArray2;
    }

    public static Collection toIdArray(Collection collection) {
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            arrayList.add(TimeDistributedHelper.getIdForObject(iterator.next()));
        }
        return arrayList;
    }

    public static Collection fromIdArray(Collection collection) {
        ArrayList<Object> arrayList = new ArrayList<Object>(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            arrayList.add(TimeDistributedHelper.getObjectFromId((String)iterator.next()));
        }
        return arrayList;
    }

    public boolean isUserCreated() {
        return this.userCreated;
    }

    public void setUserCreated(boolean bl) {
        this.userCreated = bl;
    }

    public int getWidth(int n) {
        return this.widths != null && n >= 0 && n < this.widths.size() ? this.widths.get(n) : -1;
    }

    public WorkspaceSetting createWorkspace(int n) {
        Workspace workspace = new Workspace();
        workspace.fields.addAll(SpreadSheetFieldArray.toIdArray(this));
        if (this.widths != null) {
            workspace.widths.addAll(this.widths);
        }
        return workspace;
    }

    public void restoreWorkspace(WorkspaceSetting workspaceSetting, int n) {
        Workspace workspace = (Workspace)workspaceSetting;
        this.addAll(SpreadSheetFieldArray.fromIdArray(workspace.fields));
        if (workspace.version > 0.0f && workspace.widths != null && workspace.widths.size() > 0) {
            this.widths = new ArrayList(workspace.widths.size());
            this.widths.addAll(workspace.widths);
        }
    }

    public ArrayList<Integer> getWidths() {
        return this.widths;
    }

    public void setWidths(ArrayList<Integer> arrayList) {
        this.widths = arrayList;
    }

    public static SpreadSheetFieldArray restore(WorkspaceSetting workspaceSetting, String string, int n) {
        SpreadSheetFieldArray spreadSheetFieldArray = new SpreadSheetFieldArray();
        spreadSheetFieldArray.setCategory("taskSpreadsheet");
        spreadSheetFieldArray.restoreWorkspace(workspaceSetting, n);
        spreadSheetFieldArray.setName(string);
        Dictionary.add(spreadSheetFieldArray);
        return spreadSheetFieldArray;
    }

    public static class Workspace
    implements WorkspaceSetting {
        private static final long serialVersionUID = -4517935309304612237L;
        ArrayList<Integer> widths = new ArrayList();
        ArrayList fields = new ArrayList();
        float version = 1.0f;
    }
}

