/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class ZapResourceBundleControl
extends ResourceBundle.Control {
    private static final Map<String, String> LANGUAGE_MAPPINGS = new HashMap<String, String>(3);
    private final List<String> formats;
    private final Locale fallbackLocale;

    public ZapResourceBundleControl() {
        this(Locale.getDefault());
    }

    public ZapResourceBundleControl(List<String> formats) {
        this(formats, Locale.getDefault());
    }

    public ZapResourceBundleControl(Locale fallbackLocale) {
        this(ResourceBundle.Control.FORMAT_PROPERTIES, fallbackLocale);
    }

    public ZapResourceBundleControl(List<String> formats, Locale fallbackLocale) {
        if (formats == null) {
            throw new IllegalArgumentException("The parameter formats must not be null.");
        }
        this.formats = Collections.unmodifiableList(new ArrayList<String>(formats));
        this.fallbackLocale = fallbackLocale;
    }

    @Override
    public String toBundleName(String baseName, Locale locale) {
        String bundleName = super.toBundleName(baseName, locale);
        String language = locale.getLanguage();
        String mapping = LANGUAGE_MAPPINGS.get(language);
        if (mapping != null) {
            return bundleName.replace(baseName + "_" + language, baseName + "_" + mapping);
        }
        return bundleName;
    }

    @Override
    public List<String> getFormats(String baseName) {
        return this.formats;
    }

    @Override
    public Locale getFallbackLocale(String baseName, Locale locale) {
        return locale.equals(this.fallbackLocale) ? null : this.fallbackLocale;
    }

    static {
        LANGUAGE_MAPPINGS.put("in", "id");
        LANGUAGE_MAPPINGS.put("iw", "he");
        LANGUAGE_MAPPINGS.put("ji", "yi");
    }
}

