'\"
'\" Copyright (c) 1995 DSC Technologies Corporation
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" @(#) extbutton.n 1.21 01/04/23 16:04:44
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .HS name section [date [version]]
'\"	Replacement for .TH in other man pages.  See below for valid
'\"	section names.
'\"
'\" .AP type name in/out [indent]
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS [type [name]]
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .VS
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" @(#) man.macros 1.1 94/08/09 13:07:19
.\"
'\"	# Heading for Tcl/Tk man pages
.de HS
.ds ^3 \\0
.if !"\\$3"" .ds ^3 \\$3
.if '\\$2'cmds'      .TH "\\$1" 1 "\\*(^3" "\\$4" "\\$5"
.if '\\$2'lib'       .TH "\\$1" 3 "\\*(^3" "\\$4" "\\$5"
.if '\\$2'ncmds'     .TH "\\$1" n "\\*(^3" "\\$4" "\\$5"
.if '\\$2'tcl'       .TH "\\$1" n "\\*(^3"  Tcl   "Tcl Built-In Commands"
.if '\\$2'tk'        .TH "\\$1" n "\\*(^3"  Tk    "Tk Commands"
.if '\\$2'tclc'      .TH "\\$1" 3 "\\*(^3"  Tcl   "Tcl Library Procedures"
.if '\\$2'tkc'       .TH "\\$1" 3 "\\*(^3"  Tk    "Tk Library Procedures"
.if '\\$2'tclcmds'   .TH "\\$1" 1 "\\*(^3"  Tk    "Tcl Applications"
.if '\\$2'tkcmds'    .TH "\\$1" 1 "\\*(^3"  Tk    "Tk Applications"
.if '\\$2'iwid'      .TH "\\$1" 1 "\\*(^3"  Tk    "[incr Widgets]"
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.TH iwidgets::extbutton iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
iwidgets::extbutton \- Extends the behavior of the Tk button by allowing
a bitmap or image to coexist with text.
.SH SYNOPSIS
\fBiwidgets::extbutton\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Widget <- iwidgets::Extbutton
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fB
activebackground    activeforeground  bitmap
background          bd                cursor
disabledforeground  font              foreground
image               justify           relief      text\fR
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "WIDGET-SPECIFIC OPTIONS"
.ta 4c 8c 12c
.LP
.nf
Name:	\fBbitmapforeground\fR
Class:	\fBForeground\fR
Command-Line Switch:	\fB-bitmapforeground\fR
.fi
.IP
Configures the foreground color of the bitmap.
.LP
.nf
Name:	\fBcommand\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB-command\fR
.fi
.IP
Associate a command with the extbutton. Simulates a Tk button's
-command option. Invoked by either <1> events or by explicitly
calling the public invoke() method.
.LP
.nf
Name:   \fBdefaultring\fR
Class:  \fBDefaultRing\fR
Command-Line Switch:    \fB-defaultring\fR
.fi
.IP
Boolean describing whether the extbutton displays its default ring given in
any of the forms acceptable to \fBTcl_GetBoolean\fR.  The default is false.
.LP
.nf
Name:   \fBdefaultringpad\fR
Class:  \fBPad\fR
Command-Line Switch:    \fB-defaultringpad\fR
.fi
.IP
Specifies the amount of space to be allocated to the indentation of the
default ring ring given in any of the forms acceptable to \fBTcl_GetPixels\fR.
The option has no effect if the defaultring option is set to false.  The
default is 4 pixels.
.LP
.nf
Name:   \fBimagePos\fR
Class:  \fBPosition\fR
Command-Line Switch:    \fB-imagepos\fR
.fi
.IP
Specifies the image position relative to the message text: \fBn\fR, \fBne\fR,
\fBnw\fR, \fBs\fR, \fBse\fR, \fBsw\fR, \fBw\fR, \fBwn\fR, \fBws\fR, \fBe\fR,
\fBen\fR, or \fBes\fR. The default is w.
.LP
.nf
Name:	\fBringBackground\fR
Class:	\fBBackground\fR
Command-Line Switch:	\fB-ringbackground\fR
.fi
.IP
Configures the background color of the default ring frame (if -defaultring
is set to boolean true).
.LP
.BE

.SH DESCRIPTION
.PP
The \fBextbutton\fR extends the behavior of the atomic Tk button by
allowing text and an image or bitmap to coexist. The user may use
the -image or -bitmap options to specify an image as well as the
-imagepos option to specify image position relative to the text.
Note that the extbutton is not intended to be used without an
image/bitmap. There will be an emtpy space next to the text if
no image/bitmap is specified.

.SH "METHODS"
.PP
The \fBiwidgets::extbutton\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE

.SH "INHERITED METHODS"
Each of the following methods are inherited from itk::Archetype. See that
man page for details.
.DS C
\fIpathName \fBcget\fR
\fIpathName \fBcomponent\fR
\fIpathName \fBconfig\fR
\fIpathName \fBconfigure\fR
.DE

.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBinvoke\fR
Evaluates the command fragment associated with the -command option.
.TP
\fIpathName \fBflash\fR
Simulates the Tk button's flash command.
.DE

.SH EXAMPLES
.DS
package require Iwidgets 4.0
iwidgets::extbutton .eb -text "Bitmap example" -bitmap info \\
  -background bisque -activeforeground red -bitmapforeground blue \\
  -defaultring 1 -command {puts "Bisque is beautiful"}
pack .eb -expand 1

iwidgets::extbutton .eb -text "Image example" -relief ridge -image \\
  [image create photo -file $itk::library/../iwidgets/demos/images/clear.gif] \\
  -font 9x15bold -background lightgreen -imagepos e \\
  -activebackground lightyellow
pack .eb -expand 1
.DE
.SH AUTHOR
Chad Smith
.SH KEYWORDS
button, pushbutton
