// -*- c++ -*-

// Line class
// This class is a subclass of Tool and provides a rubber line drawing tool.

// $Id: line.h,v 1.10 2003/01/12 22:42:19 nhasan Exp $

#ifndef LINE_H
#define LINE_H

#include "tool.h"

class Line : public Tool
{
  Q_OBJECT
public:
  Line();
  void mousePressEvent(QMouseEvent *e);
  void mouseMoveEvent(QMouseEvent *e);
  void mouseReleaseEvent(QMouseEvent *e);
  void activating();
  const char* pixmap() const;
signals:
  void modified();
private:
  int startx, starty;
  int lastx, lasty;
  bool drawing;
  int activeButton;
};

#endif // LINE_H

