/***************************************************************************
                          mediawidget.cpp - The main widget
                             -------------------
    begin                : Sat June 23 13:35:30 CEST 2001
    copyright            : (C) 2001 Joseph Wenninger
    email                : jowenn@kde.org
 ***************************************************************************/
 
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "mediawidget.h"
#include "mediawidget.moc"
#include "player.h"

#include <kurl.h>
#include <kurldrag.h>
#include <klocale.h>

#include <qwidget.h>
#include <qpushbutton.h>
#include <qlcdnumber.h>
#include <qpopupmenu.h>
#include <qslider.h>
#include <qtooltip.h>

KSB_MediaWidget::KSB_MediaWidget(QWidget *parent):KSB_MediaWidget_skel(parent)
{
	player = new Player(this);
// player->openFile(KURL("/MP3/CD11/Gigi D'Agostino - Bla bla bla.mp3"));
// player->openFile(KURL("/home/jowenn/bar1.png"));
	connect(Play,SIGNAL(clicked()),player,SLOT(play()));
	connect(Pause,SIGNAL(clicked()),player,SLOT(pause()));
	connect(Stop,SIGNAL(clicked()),player,SLOT(stop()));
	connect(player, SIGNAL(timeout()), this, SLOT(playerTimeout()));
	connect(player, SIGNAL(finished()), this, SLOT(playerFinished()));

	connect(Position, SIGNAL(userChanged(int)), this, SLOT(skipToWrapper(int)));
	connect(this, SIGNAL(skipTo(unsigned long)), player, SLOT(skipTo(unsigned long)));
// connect(mSeeker, SIGNAL(sliderMoved(int)), this, SLOT(sliderMoved(int)));
//	connect(Menu,SIGNAL(clicked()),this,SLOT(showMenu()));
	setAcceptDrops(true);

	pretty="";
	needLengthUpdate=false;

	QToolTip::add(Play,i18n("Start playing<BR><HR><B><I>Current File</I></B>:"));
	QToolTip::add(Pause,i18n("Pause playing<BR><HR><B><I>Current File</I></B>:"));
	QToolTip::add(Stop,i18n("Stop playing<BR><HR><B><I>Current File</I></B>:"));
	QToolTip::add(Position,i18n("Current playing position<BR><HR><B><I>Current File</I></B>:"));
	QToolTip::add(time,i18n("Current playing position<BR><HR><I><B>Current File</I></B>:"));
}

void KSB_MediaWidget::skipToWrapper(int second)
{
	emit skipTo((unsigned long)(second*1000));
}

void KSB_MediaWidget::dragEnterEvent ( QDragEnterEvent * e)
{
	e->accept(KURLDrag::canDecode(e));
}

void KSB_MediaWidget::dropEvent ( QDropEvent * e)
{
	m_kuri_list.clear();
	if (KURLDrag::decode(e, m_kuri_list))
	{
		playerFinished();
	}
}


void KSB_MediaWidget::playerTimeout()
{
	if(player->current().isEmpty())
		return;

	if(Position->currentlyPressed())
		return;

// update the scrollbar length
	if(player->getLength())
	{
		int range = (int)(player->getLength() / 1000);
		Position->setRange(0, range);
		if (needLengthUpdate)
		{
			QString length=player->lengthString().right(5);
			needLengthUpdate=false;
			QToolTip::add(Play,i18n("Start playing<BR><HR><B><I>Current File</I></B>: ")+pretty+i18n("<BR><B><I>Total time</I></B>: ")+length);
			QToolTip::add(Pause,i18n("Pause playing<BR><HR><B><I>Current File</I></B>: ")+pretty+i18n("<BR><B><I>Total time</I></B>: ")+length);
			QToolTip::add(Stop,i18n("Stop playing<BR><HR><B><I>Current File</I></B>: ")+pretty+i18n("<BR><B><I>Total time</I></B>: ")+length);
			QToolTip::add(Position,i18n("Current playing position<BR><HR><B><I>Current File</I></B>: ")+pretty+i18n("<BR><B><I>Total time</I></B>: ")+length);
			QToolTip::add(time,i18n("Current playing position<BR><HR><B><I>Current File</I></B>: ")+pretty+i18n("<BR><B><I>Total time</I></B>: ")+length);
		}
	}
	else
	{
		Position->setRange(0, 1);
	}
	// set the position
	Position->setValue((int)(player->getTime() / 1000));	

	// update the time label
	time->display(player->lengthString().left(5));
}

void KSB_MediaWidget::playerFinished()
{
	if( m_kuri_list.count() > 0 )
	{
		KURL kurl = m_kuri_list.first();
		m_kuri_list.remove( kurl );
		player->openFile( kurl );
		player->play();
		needLengthUpdate=true;
		pretty=kurl.prettyURL();
		
		QToolTip::add(Play,i18n("Start playing<BR><HR><B><I>Current File</I></B>: ")+pretty+i18n("<BR><B><I>Total time</I></B>: "));
		QToolTip::add(Pause,i18n("Pause playing<BR><HR><B><I>Current File</I></B>: ")+pretty+i18n("<BR><B><I>Total time</I></B>: "));
		QToolTip::add(Stop,i18n("Stop playing<BR><HR><B><I>Current File</I></B>: ")+pretty+i18n("<BR><B><I>Total time</I></B>: "));
		QToolTip::add(Position,i18n("Current playing position<BR><HR><B><I>Current File</I></B>: ")+pretty+i18n("<BR><B><I>Total time</I></B>: "));
		QToolTip::add(time,i18n("Current playing position<BR><HR><B><I>Current File</I></B>: ")+pretty+i18n("<BR><B><I>Total time</I></B>: "));
	}
}
