/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.amd64;

import sun.jvm.hotspot.asm.amd64.AMD64Register;
import sun.jvm.hotspot.utilities.Assert;

public class AMD64Registers {
    public static final int NUM_REGISTERS = 16;
    public static final AMD64Register RAX = new AMD64Register(0, "rax");
    public static final AMD64Register RCX = new AMD64Register(1, "rcx");
    public static final AMD64Register RDX = new AMD64Register(2, "rdx");
    public static final AMD64Register RBX = new AMD64Register(3, "rbx");
    public static final AMD64Register RSP = new AMD64Register(4, "rsp");
    public static final AMD64Register RBP = new AMD64Register(5, "rbp");
    public static final AMD64Register RSI = new AMD64Register(6, "rsi");
    public static final AMD64Register RDI = new AMD64Register(7, "rdi");
    public static final AMD64Register R8 = new AMD64Register(8, "r8");
    public static final AMD64Register R9 = new AMD64Register(9, "r9");
    public static final AMD64Register R10 = new AMD64Register(10, "r10");
    public static final AMD64Register R11 = new AMD64Register(11, "r11");
    public static final AMD64Register R12 = new AMD64Register(12, "r12");
    public static final AMD64Register R13 = new AMD64Register(13, "r13");
    public static final AMD64Register R14 = new AMD64Register(14, "r14");
    public static final AMD64Register R15 = new AMD64Register(15, "r15");
    private static final AMD64Register[] registers = new AMD64Register[]{RAX, RCX, RDX, RBX, RSP, RBP, RSI, RDI, R8, R9, R10, R11, R12, R13, R14, R15};

    public static int getNumberOfRegisters() {
        return 16;
    }

    public static AMD64Register getRegister(int regNum) {
        Assert.that(regNum > -1 && regNum < 16, "invalid integer register number!");
        return registers[regNum];
    }

    public static String getRegisterName(int regNum) {
        Assert.that(regNum > -1 && regNum < 16, "invalid integer register number!");
        return registers[regNum].toString();
    }
}

