/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddressImpl;
import java.net.InetAddressImplFactory;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import sun.misc.Service;
import sun.net.InetAddressCachePolicy;
import sun.net.spi.nameservice.NameService;
import sun.net.spi.nameservice.NameServiceDescriptor;
import sun.net.util.IPAddressUtil;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetPropertyAction;
import sun.security.action.LoadLibraryAction;

public class InetAddress
implements Serializable {
    static final int IPv4 = 1;
    static final int IPv6 = 2;
    static transient boolean preferIPv6Address = false;
    String hostName;
    int address;
    int family;
    private static NameService nameService = null;
    private transient String canonicalHostName = null;
    private static final long serialVersionUID = 3286316764910316507L;
    private static Cache addressCache;
    private static Cache negativeCache;
    private static boolean addressCacheInit;
    static InetAddress[] unknown_array;
    static InetAddressImpl impl;
    private static HashMap lookupTable;

    InetAddress() {
    }

    private Object readResolve() throws ObjectStreamException {
        return new Inet4Address(this.hostName, this.address);
    }

    public boolean isMulticastAddress() {
        return false;
    }

    public boolean isAnyLocalAddress() {
        return false;
    }

    public boolean isLoopbackAddress() {
        return false;
    }

    public boolean isLinkLocalAddress() {
        return false;
    }

    public boolean isSiteLocalAddress() {
        return false;
    }

    public boolean isMCGlobal() {
        return false;
    }

    public boolean isMCNodeLocal() {
        return false;
    }

    public boolean isMCLinkLocal() {
        return false;
    }

    public boolean isMCSiteLocal() {
        return false;
    }

    public boolean isMCOrgLocal() {
        return false;
    }

    public boolean isReachable(int n2) throws IOException {
        return this.isReachable(null, 0, n2);
    }

    public boolean isReachable(NetworkInterface networkInterface, int n2, int n3) throws IOException {
        if (n2 < 0) {
            throw new IllegalArgumentException("ttl can't be negative");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("timeout can't be negative");
        }
        return impl.isReachable(this, n3, networkInterface, n2);
    }

    public String getHostName() {
        return this.getHostName(true);
    }

    String getHostName(boolean bl2) {
        if (this.hostName == null) {
            this.hostName = InetAddress.getHostFromNameService(this, bl2);
        }
        return this.hostName;
    }

    public String getCanonicalHostName() {
        if (this.canonicalHostName == null) {
            this.canonicalHostName = InetAddress.getHostFromNameService(this, true);
        }
        return this.canonicalHostName;
    }

    private static String getHostFromNameService(InetAddress inetAddress, boolean bl2) {
        String string;
        try {
            InetAddress[] inetAddressArray;
            string = nameService.getHostByAddr(inetAddress.getAddress());
            if (bl2 && (inetAddressArray = System.getSecurityManager()) != null) {
                inetAddressArray.checkConnect(string, -1);
            }
            inetAddressArray = InetAddress.getAllByName0(string, bl2);
            boolean bl3 = false;
            if (inetAddressArray != null) {
                for (int i2 = 0; !bl3 && i2 < inetAddressArray.length; ++i2) {
                    bl3 = inetAddress.equals(inetAddressArray[i2]);
                }
            }
            if (!bl3) {
                string = inetAddress.getHostAddress();
                return string;
            }
        }
        catch (SecurityException securityException) {
            string = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            string = inetAddress.getHostAddress();
        }
        return string;
    }

    public byte[] getAddress() {
        return null;
    }

    public String getHostAddress() {
        return null;
    }

    public int hashCode() {
        return -1;
    }

    public boolean equals(Object object) {
        return false;
    }

    public String toString() {
        return (this.hostName != null ? this.hostName : "") + "/" + this.getHostAddress();
    }

    private static void cacheInitIfNeeded() {
        assert (Thread.holdsLock(addressCache));
        if (addressCacheInit) {
            return;
        }
        unknown_array = new InetAddress[1];
        InetAddress.unknown_array[0] = impl.anyLocalAddress();
        addressCache.put(impl.anyLocalAddress().getHostName(), unknown_array);
        addressCacheInit = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cacheAddress(String string, Object object, boolean bl2) {
        string = string.toLowerCase();
        Cache cache = addressCache;
        synchronized (cache) {
            InetAddress.cacheInitIfNeeded();
            if (bl2) {
                addressCache.put(string, object);
            } else {
                negativeCache.put(string, object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getCachedAddress(String string) {
        string = string.toLowerCase();
        Cache cache = addressCache;
        synchronized (cache) {
            InetAddress.cacheInitIfNeeded();
            CacheEntry cacheEntry = addressCache.get(string);
            if (cacheEntry == null) {
                cacheEntry = negativeCache.get(string);
            }
            if (cacheEntry != null) {
                return cacheEntry.address;
            }
        }
        return null;
    }

    public static InetAddress getByAddress(String string, byte[] byArray) throws UnknownHostException {
        if (string != null && string.length() > 0 && string.charAt(0) == '[' && string.charAt(string.length() - 1) == ']') {
            string = string.substring(1, string.length() - 1);
        }
        if (byArray != null) {
            if (byArray.length == 4) {
                return new Inet4Address(string, byArray);
            }
            if (byArray.length == 16) {
                byte[] byArray2 = IPAddressUtil.convertFromIPv4MappedAddress(byArray);
                if (byArray2 != null) {
                    return new Inet4Address(string, byArray2);
                }
                return new Inet6Address(string, byArray);
            }
        }
        throw new UnknownHostException("addr is of illegal length");
    }

    public static InetAddress getByName(String string) throws UnknownHostException {
        return InetAddress.getAllByName(string)[0];
    }

    public static InetAddress[] getAllByName(String string) throws UnknownHostException {
        if (string == null || string.length() == 0) {
            InetAddress[] inetAddressArray = new InetAddress[]{impl.loopbackAddress()};
            return inetAddressArray;
        }
        boolean bl2 = false;
        if (string.charAt(0) == '[') {
            if (string.length() > 2 && string.charAt(string.length() - 1) == ']') {
                string = string.substring(1, string.length() - 1);
                bl2 = true;
            } else {
                throw new UnknownHostException(string);
            }
        }
        if (Character.digit(string.charAt(0), 16) != -1 || string.charAt(0) == ':') {
            byte[] byArray = null;
            int n2 = -1;
            String string2 = null;
            byArray = IPAddressUtil.textToNumericFormatV4(string);
            if (byArray == null) {
                int n3 = string.indexOf("%");
                if (n3 != -1 && (n2 = InetAddress.checkNumericZone(string)) == -1) {
                    string2 = string.substring(n3 + 1);
                }
                byArray = IPAddressUtil.textToNumericFormatV6(string);
            } else if (bl2) {
                throw new UnknownHostException("[" + string + "]");
            }
            InetAddress[] inetAddressArray = new InetAddress[1];
            if (byArray != null) {
                inetAddressArray[0] = byArray.length == 4 ? new Inet4Address(null, byArray) : (string2 != null ? new Inet6Address(null, byArray, string2) : new Inet6Address(null, byArray, n2));
                return inetAddressArray;
            }
        } else if (bl2) {
            throw new UnknownHostException("[" + string + "]");
        }
        return InetAddress.getAllByName0(string);
    }

    private static int checkNumericZone(String string) throws UnknownHostException {
        int n2 = string.indexOf(37);
        int n3 = string.length();
        int n4 = 0;
        if (n2 == -1) {
            return -1;
        }
        for (int i2 = n2 + 1; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == ']') {
                if (i2 != n2 + 1) break;
                return -1;
            }
            int n5 = Character.digit(c2, 10);
            if (n5 < 0) {
                return -1;
            }
            n4 = n4 * 10 + n5;
        }
        return n4;
    }

    private static InetAddress[] getAllByName0(String string) throws UnknownHostException {
        return InetAddress.getAllByName0(string, true);
    }

    static InetAddress[] getAllByName0(String string, boolean bl2) throws UnknownHostException {
        SecurityManager securityManager;
        Object object = null;
        Object object2 = null;
        if (bl2 && (securityManager = System.getSecurityManager()) != null) {
            securityManager.checkConnect(string, -1);
        }
        if ((object = InetAddress.getCachedAddress(string)) == null) {
            try {
                object = InetAddress.getAddressFromNameService(string);
            }
            catch (UnknownHostException unknownHostException) {
                throw new UnknownHostException(string + ": " + unknownHostException.getMessage());
            }
        }
        if (object == unknown_array) {
            throw new UnknownHostException(string);
        }
        object2 = ((InetAddress[])object).clone();
        return (InetAddress[])object2;
    }

    private static Object getAddressFromNameService(String string) throws UnknownHostException {
        InetAddress[] inetAddressArray = null;
        boolean bl2 = false;
        inetAddressArray = InetAddress.checkLookupTable(string);
        if (inetAddressArray == null) {
            try {
                byte[][] byArray = nameService.lookupAllHostAddr(string);
                InetAddress[] inetAddressArray2 = new InetAddress[byArray.length];
                for (int i2 = 0; i2 < byArray.length; ++i2) {
                    byte[] byArray2 = byArray[i2];
                    inetAddressArray2[i2] = byArray2.length == 4 ? new Inet4Address(string, byArray2) : new Inet6Address(string, byArray2, -1);
                }
                inetAddressArray = inetAddressArray2;
                bl2 = true;
            }
            catch (UnknownHostException unknownHostException) {
                inetAddressArray = unknown_array;
                bl2 = false;
                throw unknownHostException;
            }
            finally {
                InetAddress.cacheAddress(string, inetAddressArray, bl2);
                InetAddress.updateLookupTable(string);
            }
        }
        return inetAddressArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object checkLookupTable(String string) {
        Object object = null;
        HashMap hashMap = lookupTable;
        synchronized (hashMap) {
            if (!lookupTable.containsKey(string)) {
                lookupTable.put(string, null);
                return object;
            }
            while (lookupTable.containsKey(string)) {
                try {
                    lookupTable.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        object = InetAddress.getCachedAddress(string);
        if (object == null) {
            hashMap = lookupTable;
            synchronized (hashMap) {
                lookupTable.put(string, null);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateLookupTable(String string) {
        HashMap hashMap = lookupTable;
        synchronized (hashMap) {
            lookupTable.remove(string);
            lookupTable.notifyAll();
        }
    }

    public static InetAddress getByAddress(byte[] byArray) throws UnknownHostException {
        return InetAddress.getByAddress(null, byArray);
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        SecurityManager securityManager = System.getSecurityManager();
        try {
            InetAddress[] inetAddressArray;
            String string = impl.getLocalHostName();
            if (securityManager != null) {
                securityManager.checkConnect(string, -1);
            }
            try {
                inetAddressArray = (InetAddress[])InetAddress.getAddressFromNameService(string);
            }
            catch (UnknownHostException unknownHostException) {
                throw new UnknownHostException(string + ": " + unknownHostException.getMessage());
            }
            return inetAddressArray[0];
        }
        catch (SecurityException securityException) {
            return impl.loopbackAddress();
        }
    }

    private static native void init();

    static InetAddress anyLocalAddress() {
        return impl.anyLocalAddress();
    }

    static Object loadImpl(String string) {
        String string2 = (String)AccessController.doPrivileged(new GetPropertyAction("impl.prefix", ""));
        Object var1_2 = null;
        try {
            var1_2 = Class.forName("java.net." + string2 + string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Class not found: java.net." + string2 + string + ":\ncheck impl.prefix property " + "in your properties file.");
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Could not instantiate: java.net." + string2 + string + ":\ncheck impl.prefix property " + "in your properties file.");
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Cannot access class: java.net." + string2 + string + ":\ncheck impl.prefix property " + "in your properties file.");
        }
        if (var1_2 == null) {
            try {
                var1_2 = Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                throw new Error("System property impl.prefix incorrect");
            }
        }
        return var1_2;
    }

    static {
        preferIPv6Address = (Boolean)AccessController.doPrivileged(new GetBooleanAction("java.net.preferIPv6Addresses"));
        AccessController.doPrivileged(new LoadLibraryAction("net"));
        InetAddress.init();
        addressCache = new Cache(InetAddressCachePolicy.get());
        negativeCache = new Cache(InetAddressCachePolicy.getNegative());
        addressCacheInit = false;
        lookupTable = new HashMap();
        new InetAddressImplFactory();
        impl = InetAddressImplFactory.create();
        String string = null;
        String string2 = "sun.net.spi.nameservice.provider.";
        int n2 = 1;
        while (nameService == null) {
            string = (String)AccessController.doPrivileged(new GetPropertyAction(string2 + n2, "default"));
            ++n2;
            if (string.equals("default")) {
                nameService = new NameService(){

                    public byte[][] lookupAllHostAddr(String string) throws UnknownHostException {
                        return impl.lookupAllHostAddr(string);
                    }

                    public String getHostByAddr(byte[] byArray) throws UnknownHostException {
                        return impl.getHostByAddr(byArray);
                    }
                };
                break;
            }
            final String string3 = string;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() {
                        Iterator iterator = Service.providers(NameServiceDescriptor.class);
                        while (iterator.hasNext()) {
                            NameServiceDescriptor nameServiceDescriptor = (NameServiceDescriptor)iterator.next();
                            if (!string3.equalsIgnoreCase(nameServiceDescriptor.getType() + "," + nameServiceDescriptor.getProviderName())) continue;
                            try {
                                InetAddress.nameService = nameServiceDescriptor.createNameService();
                                break;
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                System.err.println("Cannot create name service:" + string3 + ": " + exception);
                            }
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {}
        }
    }

    static final class Cache {
        private int policy;
        private LinkedHashMap cache;

        public Cache(int n2) {
            this.policy = n2;
            this.cache = new LinkedHashMap();
        }

        public Cache put(String string, Object object) {
            if (this.policy == 0) {
                return this;
            }
            if (this.policy != -1) {
                LinkedList<String> linkedList = new LinkedList<String>();
                Iterator<Object> iterator = this.cache.keySet().iterator();
                long l2 = System.currentTimeMillis();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    CacheEntry cacheEntry = (CacheEntry)this.cache.get(string2);
                    if (cacheEntry.expiration < 0L || cacheEntry.expiration >= l2) break;
                    linkedList.add(string2);
                }
                iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    this.cache.remove(iterator.next());
                }
            }
            long l3 = this.policy == -1 ? -1L : System.currentTimeMillis() + (long)(this.policy * 1000);
            CacheEntry cacheEntry = new CacheEntry(object, l3);
            this.cache.put(string, cacheEntry);
            return this;
        }

        public CacheEntry get(String string) {
            if (this.policy == 0) {
                return null;
            }
            CacheEntry cacheEntry = (CacheEntry)this.cache.get(string);
            if (cacheEntry != null && this.policy != -1 && cacheEntry.expiration >= 0L && cacheEntry.expiration < System.currentTimeMillis()) {
                this.cache.remove(string);
                cacheEntry = null;
            }
            return cacheEntry;
        }
    }

    static final class CacheEntry {
        Object address;
        long expiration;

        CacheEntry(Object object, long l2) {
            this.address = object;
            this.expiration = l2;
        }
    }
}

