/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.TextEvent;
import java.awt.im.InputMethodRequests;
import java.awt.peer.TextFieldPeer;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.MToolkit;

public class MTextFieldPeer
extends MComponentPeer
implements TextFieldPeer {
    private boolean firstChangeSkipped;
    private static final int padding = 16;
    public static final int BORDER = 2;
    public static final int MARGIN = 4;

    native void pCreate(MComponentPeer var1);

    private static native void initIDs();

    void create(MComponentPeer mComponentPeer) {
        this.firstChangeSkipped = false;
        this.pCreate(mComponentPeer);
    }

    void initialize() {
        TextField textField = (TextField)this.target;
        this.setText(textField.getText());
        if (textField.echoCharIsSet()) {
            this.setEchoChar(textField.getEchoChar());
        }
        int n2 = textField.getSelectionStart();
        int n3 = textField.getSelectionEnd();
        if (n3 > n2) {
            this.select(n2, n3);
        } else {
            this.setCaretPosition(n2);
        }
        if (!this.target.isBackgroundSet()) {
            this.setTargetBackground(SystemColor.text);
        }
        if (!this.target.isForegroundSet()) {
            this.target.setForeground(SystemColor.textText);
        }
        this.setEditable(textField.isEditable());
        super.initialize();
    }

    public MTextFieldPeer(TextField textField) {
        super(textField);
    }

    public void setEditable(boolean bl2) {
        this.pSetEditable(bl2);
        this.setBackground(this.target.getBackground());
    }

    public native void pSetEditable(boolean var1);

    public native void select(int var1, int var2);

    public native int getSelectionStart();

    public native int getSelectionEnd();

    public native void setText(String var1);

    public native void insertReplaceText(String var1);

    public native void preDispose();

    public native String getText();

    public native void setEchoChar(char var1);

    public native void setFont(Font var1);

    public native void setCaretPosition(int var1);

    public native int getCaretPosition();

    public Dimension getMinimumSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.target.getFont());
        return new Dimension(fontMetrics.stringWidth(((TextField)this.target).getText()) + 20, fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent() + 16);
    }

    public Dimension getPreferredSize(int n2) {
        return this.getMinimumSize(n2);
    }

    public Dimension getMinimumSize(int n2) {
        FontMetrics fontMetrics = this.getFontMetrics(this.target.getFont());
        return new Dimension(fontMetrics.charWidth('0') * n2 + 20, fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent() + 16);
    }

    public boolean isFocusable() {
        return true;
    }

    public void action(final long l2, final int n2) {
        MToolkit.executeOnEventHandlerThread(this.target, new Runnable(){

            public void run() {
                MTextFieldPeer.this.postEvent(new ActionEvent(MTextFieldPeer.this.target, 1001, ((TextField)MTextFieldPeer.this.target).getText(), l2, n2));
            }
        });
    }

    protected void disposeImpl() {
        this.preDispose();
        super.disposeImpl();
    }

    public void valueChanged() {
        this.postEvent(new TextEvent(this.target, 900));
    }

    public void pasteFromClipboard() {
        Clipboard clipboard = this.target.getToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        if (transferable != null) {
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                this.insertReplaceText(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void print(Graphics graphics) {
        TextField textField = (TextField)this.target;
        Dimension dimension = textField.size();
        int n2 = dimension.width - 4;
        int n3 = dimension.height - 4;
        Color color = textField.getBackground();
        Color color2 = textField.getForeground();
        Color color3 = color.brighter();
        String string = textField.getText();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        graphics.setFont(textField.getFont());
        graphics.setColor(textField.isEditable() ? color3 : color);
        graphics.fillRect(2, 2, n2, n3);
        graphics.setColor(color);
        this.draw3DRect(graphics, color, 1, 1, dimension.width - 3, dimension.height - 3, false);
        if (string != null) {
            graphics.clipRect(2, 4, n2, dimension.height - 8);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            n2 = dimension.width - 2;
            n3 = dimension.height - 8;
            int n7 = this.pos2x(n5) - n4;
            int n8 = this.pos2x(n6) - n4;
            if (n7 < 4 && n8 > n2) {
                graphics.setColor(color3);
                graphics.fillRect(2, 4, n2 - 2, n3);
            } else {
                graphics.setColor(color);
                if (n7 >= 4 && n7 <= n2) {
                    graphics.setColor(color3);
                    if (n8 > n2) {
                        graphics.fillRect(n7, 4, n2 - n7, n3);
                    } else if (n7 != n8) {
                        graphics.fillRect(n7, 4, n8 - n7, n3);
                    }
                } else if (n8 >= 4 && n8 <= n2) {
                    graphics.setColor(color3);
                    graphics.fillRect(2, 4, n8 - 2, n3);
                }
            }
            graphics.setColor(color2);
            int n9 = 4 - n4;
            char c2 = textField.getEchoChar();
            if (c2 == '\u0000') {
                graphics.drawString(string, n9, 6 + fontMetrics.getMaxAscent());
            } else {
                char[] cArray = new char[string.length()];
                for (int i2 = 0; i2 < cArray.length; ++i2) {
                    cArray[i2] = c2;
                }
                graphics.drawChars(cArray, 0, cArray.length, n9, 6 + fontMetrics.getMaxAscent());
            }
        }
        this.target.print(graphics);
    }

    int pos2x(int n2) {
        TextField textField = (TextField)this.target;
        FontMetrics fontMetrics = this.getFontMetrics(textField.getFont());
        int n3 = 4;
        int[] nArray = fontMetrics.getWidths();
        String string = textField.getText();
        char c2 = textField.getEchoChar();
        if (c2 == '\u0000') {
            for (int i2 = 0; i2 < n2; ++i2) {
                n3 += nArray[string.charAt(i2)];
            }
        } else {
            n3 += nArray[c2] * n2;
        }
        return n3;
    }

    public void setEchoCharacter(char c2) {
        this.setEchoChar(c2);
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public Dimension minimumSize(int n2) {
        return this.getMinimumSize(n2);
    }

    public Dimension preferredSize(int n2) {
        return this.getPreferredSize(n2);
    }

    void pShow() {
        super.pShow();
        this.notifyTextComponentChange(true);
    }

    void pHide() {
        this.notifyTextComponentChange(false);
        super.pHide();
    }

    void pDispose() {
        this.notifyTextComponentChange(false);
        super.pDispose();
    }

    public InputMethodRequests getInputMethodRequests() {
        return null;
    }

    public int getIndexAtPoint(int n2, int n3) {
        return -1;
    }

    public Rectangle getCharacterBounds(int n2) {
        return null;
    }

    public long filterEvents(long l2) {
        return 0L;
    }

    static {
        MTextFieldPeer.initIDs();
    }
}

