/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001-2004 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * gui_utils.c - utilities for the user interface
 */

#include <gtk/gtk.h>
#include "types.h"

extern GdkColormap *colormap;

/* set style of a label */
void
setlabelstyle (GtkWidget * label, gchar * color, gchar * font)
{
	GdkColor themecolor;
	PangoFontDescription *fnt;

	gdk_color_parse (color, &themecolor);
	if (!gdk_colormap_alloc_color (colormap, &themecolor, FALSE, TRUE))
		g_warning ("Allocation of color failed in setlabelstyle");

	gtk_widget_modify_fg (label, GTK_STATE_NORMAL, &themecolor);
	fnt = pango_font_description_from_string(font);
	gtk_widget_modify_font(GTK_WIDGET(label), fnt);
	pango_font_description_free(fnt);
}

/* set style of a frame */
void
setframestyle (GtkWidget * frame, gchar * color, gchar * font)
{
	GdkColor themecolor;
	GtkWidget *label;
	PangoFontDescription *fnt;
	GtkStyle *framestyle;

	gdk_color_parse (color, &themecolor);
	if (!gdk_colormap_alloc_color (colormap, &themecolor, FALSE, TRUE))
		g_warning ("Allocation of color failed in setframestyle");

	framestyle = gtk_style_copy (frame->style);		
	framestyle->bg[GTK_STATE_NORMAL] = themecolor;
	gtk_widget_set_style (GTK_WIDGET (frame), framestyle);

	label = gtk_frame_get_label_widget (GTK_FRAME(frame));
	gtk_widget_modify_fg (label, GTK_STATE_NORMAL, &themecolor);
	fnt = pango_font_description_from_string(font);
	gtk_widget_modify_font(GTK_WIDGET(label), fnt);
	pango_font_description_free(fnt);
}

/* get color style of a label */
gchar *
getlabelcolor (GtkWidget * label)
{
	GtkStyle *labelstyle;
	GdkColor labelcolor;
	gchar *col;

	labelstyle = gtk_style_copy (label->style);
	labelcolor = labelstyle->fg[GTK_STATE_NORMAL];

	col = g_strdup_printf("#%02X%02X%02X",	 
			labelcolor.red >> 8, labelcolor.green >> 8, labelcolor.blue >> 8);

	return (col);
}
