/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.SelectorProvider;

public abstract class DatagramChannel
extends AbstractSelectableChannel
implements ByteChannel,
ScatteringByteChannel,
GatheringByteChannel {
    protected DatagramChannel(SelectorProvider provider) {
        super(provider);
    }

    public static DatagramChannel open() throws IOException {
        return SelectorProvider.provider().openDatagramChannel();
    }

    public final long read(ByteBuffer[] dsts) throws IOException {
        long b = 0L;
        for (int i = 0; i < dsts.length; ++i) {
            b += (long)this.read(dsts[i]);
        }
        return b;
    }

    public final long write(ByteBuffer[] srcs) throws IOException {
        long b = 0L;
        for (int i = 0; i < srcs.length; ++i) {
            b += (long)this.write(srcs[i]);
        }
        return b;
    }

    public abstract DatagramChannel connect(SocketAddress var1) throws IOException;

    public abstract DatagramChannel disconnect() throws IOException;

    public abstract boolean isConnected();

    public abstract int read(ByteBuffer var1) throws IOException;

    public abstract long read(ByteBuffer[] var1, int var2, int var3) throws IOException;

    public abstract SocketAddress receive(ByteBuffer var1) throws IOException;

    public abstract int send(ByteBuffer var1, SocketAddress var2) throws IOException;

    public abstract DatagramSocket socket();

    public abstract int write(ByteBuffer var1) throws IOException;

    public abstract long write(ByteBuffer[] var1, int var2, int var3) throws IOException;

    public final int validOps() {
        return 5;
    }
}

