/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.Serializable;
import java.security.Certificate;
import java.security.IdentityScope;
import java.security.KeyManagementException;
import java.security.Principal;
import java.security.PublicKey;
import java.util.Vector;

public abstract class Identity
implements Principal,
Serializable {
    private static final long serialVersionUID = 3609922007826600659L;
    private String name;
    private IdentityScope scope;
    private PublicKey publicKey;
    private String info;
    private Vector certificates;

    protected Identity() {
    }

    public Identity(String name, IdentityScope scope) throws KeyManagementException {
        this.name = name;
        this.scope = scope;
    }

    public Identity(String name) {
        this.name = name;
        this.scope = null;
    }

    public final String getName() {
        return this.name;
    }

    public final IdentityScope getScope() {
        return this.scope;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(PublicKey key) throws KeyManagementException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSecurityAccess("setIdentityPublicKey");
        }
        this.publicKey = key;
    }

    public void setInfo(String info) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSecurityAccess("setIdentityInfo");
        }
        this.info = info;
    }

    public String getInfo() {
        return this.info;
    }

    public void addCertificate(Certificate certificate) throws KeyManagementException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSecurityAccess("addIdentityCertificate");
        }
        if (this.certificates.size() > 0 && ((Certificate)this.certificates.firstElement()).getPublicKey() != this.publicKey) {
            throw new KeyManagementException("Public key does not match");
        }
        this.certificates.addElement(certificate);
    }

    public void removeCertificate(Certificate certificate) throws KeyManagementException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSecurityAccess("removeIdentityCertificate");
        }
        if (!this.certificates.contains(certificate)) {
            throw new KeyManagementException("Certificate not found");
        }
        this.certificates.removeElement(certificate);
    }

    public Certificate[] certificates() {
        Certificate[] certs = new Certificate[this.certificates.size()];
        int max = this.certificates.size();
        for (int i = 0; i < max; ++i) {
            certs[i] = (Certificate)this.certificates.elementAt(i);
        }
        return certs;
    }

    public final boolean equals(Object identity) {
        if (identity instanceof Identity) {
            if (identity == this) {
                return true;
            }
            if (((Identity)identity).getName() == this.name && ((Identity)identity).getScope() == this.scope) {
                return true;
            }
            return this.identityEquals((Identity)identity);
        }
        return false;
    }

    protected boolean identityEquals(Identity identity) {
        return identity.getName() == this.name && identity.getPublicKey() == this.publicKey;
    }

    public String toString() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSecurityAccess("printIdentity");
        }
        return this.name + ":@" + this.scope + " Public Key: " + this.publicKey;
    }

    public String toString(boolean detailed) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSecurityAccess("printIdentity");
        }
        if (detailed) {
            return this.name + ":@" + this.scope + " Public Key: " + this.publicKey;
        }
        return this.name + ":@" + this.scope + " Public Key: " + this.publicKey;
    }

    public int hashCode() {
        int ret = this.name.hashCode();
        if (this.publicKey != null) {
            ret |= this.publicKey.hashCode();
        }
        if (this.scope != null) {
            ret |= this.scope.hashCode();
        }
        if (this.info != null) {
            ret |= this.info.hashCode();
        }
        if (this.certificates != null) {
            ret |= this.certificates.hashCode();
        }
        return ret;
    }
}

