/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.security.DigestException;
import java.security.DummyMessageDigest;
import java.security.MessageDigestSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;

public abstract class MessageDigest
extends MessageDigestSpi {
    private static final String MESSAGE_DIGEST = "MessageDigest";
    private String algorithm;
    Provider provider;
    private byte[] lastDigest;

    protected MessageDigest(String algorithm) {
        this.algorithm = algorithm;
        this.provider = null;
    }

    public static MessageDigest getInstance(String algorithm) throws NoSuchAlgorithmException {
        Provider[] p = Security.getProviders();
        for (int i = 0; i < p.length; ++i) {
            try {
                return MessageDigest.getInstance(algorithm, p[i]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                continue;
            }
        }
        throw new NoSuchAlgorithmException(algorithm);
    }

    public static MessageDigest getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (provider == null || provider.length() == 0) {
            throw new IllegalArgumentException("Illegal provider");
        }
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        return MessageDigest.getInstance(algorithm, p);
    }

    public static MessageDigest getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("Illegal provider");
        }
        MessageDigest result = null;
        Object o = null;
        try {
            o = Engine.getInstance(MESSAGE_DIGEST, algorithm, provider);
        }
        catch (InvocationTargetException ite) {
            throw new NoSuchAlgorithmException(algorithm);
        }
        if (o instanceof MessageDigestSpi) {
            result = new DummyMessageDigest((MessageDigestSpi)o, algorithm);
        } else if (o instanceof MessageDigest) {
            result = (MessageDigest)o;
            result.algorithm = algorithm;
        } else {
            throw new NoSuchAlgorithmException(algorithm);
        }
        result.provider = provider;
        return result;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public void update(byte input) {
        this.engineUpdate(input);
    }

    public void update(byte[] input, int offset, int len) {
        this.engineUpdate(input, offset, len);
    }

    public void update(byte[] input) {
        this.engineUpdate(input, 0, input.length);
    }

    public byte[] digest() {
        this.lastDigest = this.engineDigest();
        return this.lastDigest;
    }

    public int digest(byte[] buf, int offset, int len) throws DigestException {
        return this.engineDigest(buf, offset, len);
    }

    public byte[] digest(byte[] input) {
        this.update(input);
        return this.digest();
    }

    public String toString() {
        return this.getClass().getName() + " Message Digest <" + this.digestToString() + ">";
    }

    public static boolean isEqual(byte[] digesta, byte[] digestb) {
        if (digesta.length != digestb.length) {
            return false;
        }
        for (int i = digesta.length - 1; i >= 0; --i) {
            if (digesta[i] == digestb[i]) continue;
            return false;
        }
        return true;
    }

    public void reset() {
        this.engineReset();
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final int getDigestLength() {
        return this.engineGetDigestLength();
    }

    public Object clone() throws CloneNotSupportedException {
        if (this instanceof Cloneable) {
            return super.clone();
        }
        throw new CloneNotSupportedException();
    }

    private String digestToString() {
        byte[] digest = this.lastDigest;
        if (digest == null) {
            return "incomplete";
        }
        StringBuffer buf = new StringBuffer();
        int len = digest.length;
        for (int i = 0; i < len; ++i) {
            byte b = digest[i];
            byte high = (byte)((b & 0xFF) >>> 4);
            int low = b & 0xF;
            buf.append(high > 9 ? 87 + high : 48 + high);
            buf.append(low > 9 ? 87 + low : 48 + low);
        }
        return buf.toString();
    }
}

