/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.text.DateFormatSymbols;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.SimpleTimeZone;

public abstract class TimeZone
implements Serializable,
Cloneable {
    public static final int SHORT = 0;
    public static final int LONG = 1;
    private String ID;
    private static TimeZone defaultZone0;
    private static final long serialVersionUID = 3581463369166924961L;
    private static Hashtable timezones0;

    private static synchronized TimeZone defaultZone() {
        if (defaultZone0 == null) {
            String tzid = System.getProperty("user.timezone");
            if (tzid == null) {
                tzid = TimeZone.getDefaultTimeZoneId();
            }
            if (tzid == null) {
                tzid = "GMT";
            }
            defaultZone0 = TimeZone.getTimeZone(tzid);
        }
        return defaultZone0;
    }

    private static synchronized Hashtable timezones() {
        if (timezones0 == null) {
            Hashtable timezones;
            timezones0 = timezones = new Hashtable();
            SimpleTimeZone tz = new SimpleTimeZone(-39600000, "MIT");
            timezones0.put("MIT", tz);
            timezones0.put("Pacific/Apia", tz);
            timezones0.put("Pacific/Midway", tz);
            timezones0.put("Pacific/Niue", tz);
            timezones0.put("Pacific/Pago_Pago", tz);
            tz = new SimpleTimeZone(-36000000, "America/Adak", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
            timezones0.put("America/Adak", tz);
            tz = new SimpleTimeZone(-36000000, "HST");
            timezones0.put("HST", tz);
            timezones0.put("Pacific/Fakaofo", tz);
            timezones0.put("Pacific/Honolulu", tz);
            timezones0.put("Pacific/Johnston", tz);
            timezones0.put("Pacific/Rarotonga", tz);
            timezones0.put("Pacific/Tahiti", tz);
            tz = new SimpleTimeZone(-34200000, "Pacific/Marquesas");
            timezones0.put("Pacific/Marquesas", tz);
            tz = new SimpleTimeZone(-32400000, "AST", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
            timezones0.put("AST", tz);
            timezones0.put("America/Anchorage", tz);
            timezones0.put("America/Juneau", tz);
            timezones0.put("America/Nome", tz);
            timezones0.put("America/Yakutat", tz);
            tz = new SimpleTimeZone(-32400000, "Pacific/Gambier");
            timezones0.put("Pacific/Gambier", tz);
            tz = new SimpleTimeZone(-28800000, "PST", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
            timezones0.put("PST", tz);
            timezones0.put("PST8PDT", tz);
            timezones0.put("America/Dawson", tz);
            timezones0.put("America/Los_Angeles", tz);
            timezones0.put("America/Tijuana", tz);
            timezones0.put("America/Vancouver", tz);
            timezones0.put("America/Whitehorse", tz);
            timezones0.put("US/Pacific-New", tz);
            tz = new SimpleTimeZone(-28800000, "Pacific/Pitcairn");
            timezones0.put("Pacific/Pitcairn", tz);
            tz = new SimpleTimeZone(-25200000, "MST", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
            timezones0.put("MST", tz);
            timezones0.put("MST7MDT", tz);
            timezones0.put("America/Boise", tz);
            timezones0.put("America/Chihuahua", tz);
            timezones0.put("America/Denver", tz);
            timezones0.put("America/Edmonton", tz);
            timezones0.put("America/Inuvik", tz);
            timezones0.put("America/Mazatlan", tz);
            timezones0.put("America/Shiprock", tz);
            timezones0.put("America/Yellowknife", tz);
            tz = new SimpleTimeZone(-25200000, "MST7");
            timezones0.put("MST7", tz);
            timezones0.put("PNT", tz);
            timezones0.put("America/Dawson_Creek", tz);
            timezones0.put("America/Hermosillo", tz);
            timezones0.put("America/Phoenix", tz);
            tz = new SimpleTimeZone(-21600000, "CST", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
            timezones0.put("CST", tz);
            timezones0.put("CST6CDT", tz);
            timezones0.put("America/Cambridge_Bay", tz);
            timezones0.put("America/Cancun", tz);
            timezones0.put("America/Chicago", tz);
            timezones0.put("America/Menominee", tz);
            timezones0.put("America/Merida", tz);
            timezones0.put("America/Mexico_City", tz);
            timezones0.put("America/Monterrey", tz);
            timezones0.put("America/Rainy_River", tz);
            timezones0.put("America/Winnipeg", tz);
            tz = new SimpleTimeZone(-21600000, "America/Belize");
            timezones0.put("America/Belize", tz);
            timezones0.put("America/Costa_Rica", tz);
            timezones0.put("America/El_Salvador", tz);
            timezones0.put("America/Guatemala", tz);
            timezones0.put("America/Managua", tz);
            timezones0.put("America/Regina", tz);
            timezones0.put("America/Swift_Current", tz);
            timezones0.put("America/Tegucigalpa", tz);
            timezones0.put("Pacific/Galapagos", tz);
            tz = new SimpleTimeZone(-21600000, "Pacific/Easter", 9, 9, -1, 0, 2, 9, -1, 0);
            timezones0.put("Pacific/Easter", tz);
            tz = new SimpleTimeZone(-18000000, "America/Grand_Turk", 3, 1, 1, 0, 9, -1, 1, 0);
            timezones0.put("America/Grand_Turk", tz);
            timezones0.put("America/Havana", tz);
            tz = new SimpleTimeZone(-18000000, "EST5");
            timezones0.put("EST5", tz);
            timezones0.put("IET", tz);
            timezones0.put("America/Bogota", tz);
            timezones0.put("America/Cayman", tz);
            timezones0.put("America/Eirunepe", tz);
            timezones0.put("America/Guayaquil", tz);
            timezones0.put("America/Indiana/Indianapolis", tz);
            timezones0.put("America/Indiana/Knox", tz);
            timezones0.put("America/Indiana/Marengo", tz);
            timezones0.put("America/Indiana/Vevay", tz);
            timezones0.put("America/Indianapolis", tz);
            timezones0.put("America/Iqaluit", tz);
            timezones0.put("America/Jamaica", tz);
            timezones0.put("America/Lima", tz);
            timezones0.put("America/Panama", tz);
            timezones0.put("America/Pangnirtung", tz);
            timezones0.put("America/Port-au-Prince", tz);
            timezones0.put("America/Porto_Acre", tz);
            timezones0.put("America/Rankin_Inlet", tz);
            tz = new SimpleTimeZone(-18000000, "EST", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
            timezones0.put("EST", tz);
            timezones0.put("EST5EDT", tz);
            timezones0.put("America/Detroit", tz);
            timezones0.put("America/Kentucky/Louisville", tz);
            timezones0.put("America/Kentucky/Monticello", tz);
            timezones0.put("America/Louisville", tz);
            timezones0.put("America/Montreal", tz);
            timezones0.put("America/Nassau", tz);
            timezones0.put("America/New_York", tz);
            timezones0.put("America/Nipigon", tz);
            timezones0.put("America/Thunder_Bay", tz);
            tz = new SimpleTimeZone(-14400000, "PRT");
            timezones0.put("PRT", tz);
            timezones0.put("America/Anguilla", tz);
            timezones0.put("America/Antigua", tz);
            timezones0.put("America/Aruba", tz);
            timezones0.put("America/Barbados", tz);
            timezones0.put("America/Boa_Vista", tz);
            timezones0.put("America/Caracas", tz);
            timezones0.put("America/Curacao", tz);
            timezones0.put("America/Dominica", tz);
            timezones0.put("America/Grenada", tz);
            timezones0.put("America/Guadeloupe", tz);
            timezones0.put("America/Guyana", tz);
            timezones0.put("America/La_Paz", tz);
            timezones0.put("America/Manaus", tz);
            timezones0.put("America/Martinique", tz);
            timezones0.put("America/Montserrat", tz);
            timezones0.put("America/Port_of_Spain", tz);
            timezones0.put("America/Porto_Velho", tz);
            timezones0.put("America/Puerto_Rico", tz);
            timezones0.put("America/Santo_Domingo", tz);
            timezones0.put("America/St_Kitts", tz);
            timezones0.put("America/St_Lucia", tz);
            timezones0.put("America/St_Thomas", tz);
            timezones0.put("America/St_Vincent", tz);
            timezones0.put("America/Tortola", tz);
            tz = new SimpleTimeZone(-14400000, "America/Asuncion", 9, 1, 1, 0, 1, -1, 1, 0);
            timezones0.put("America/Asuncion", tz);
            tz = new SimpleTimeZone(-14400000, "America/Cuiaba", 9, 2, 1, 0, 1, 3, 1, 0);
            timezones0.put("America/Cuiaba", tz);
            tz = new SimpleTimeZone(-14400000, "America/Goose_Bay", 3, 1, 1, 60000, 9, -1, 1, 60000);
            timezones0.put("America/Goose_Bay", tz);
            tz = new SimpleTimeZone(-14400000, "America/Glace_Bay", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
            timezones0.put("America/Glace_Bay", tz);
            timezones0.put("America/Halifax", tz);
            timezones0.put("America/Thule", tz);
            timezones0.put("Atlantic/Bermuda", tz);
            tz = new SimpleTimeZone(-14400000, "America/Santiago", 9, 9, -1, 0, 2, 9, -1, 0);
            timezones0.put("America/Santiago", tz);
            timezones0.put("Antarctica/Palmer", tz);
            tz = new SimpleTimeZone(-14400000, "Atlantic/Stanley", 8, 2, 1, 0, 3, 16, -1, 0);
            timezones0.put("Atlantic/Stanley", tz);
            tz = new SimpleTimeZone(-12600000, "CNT", 3, 1, 1, 60000, 9, -1, 1, 60000);
            timezones0.put("CNT", tz);
            timezones0.put("America/St_Johns", tz);
            tz = new SimpleTimeZone(-10800000, "America/Araguaina", 9, 2, 1, 0, 1, 3, 1, 0);
            timezones0.put("America/Araguaina", tz);
            timezones0.put("America/Sao_Paulo", tz);
            tz = new SimpleTimeZone(-10800000, "AGT");
            timezones0.put("AGT", tz);
            timezones0.put("America/Belem", tz);
            timezones0.put("America/Buenos_Aires", tz);
            timezones0.put("America/Catamarca", tz);
            timezones0.put("America/Cayenne", tz);
            timezones0.put("America/Cordoba", tz);
            timezones0.put("America/Fortaleza", tz);
            timezones0.put("America/Jujuy", tz);
            timezones0.put("America/Maceio", tz);
            timezones0.put("America/Mendoza", tz);
            timezones0.put("America/Montevideo", tz);
            timezones0.put("America/Paramaribo", tz);
            timezones0.put("America/Recife", tz);
            timezones0.put("America/Rosario", tz);
            tz = new SimpleTimeZone(-10800000, "America/Godthab", 2, 30, -7, 79200000, 9, 30, -7, 79200000);
            timezones0.put("America/Godthab", tz);
            tz = new SimpleTimeZone(-10800000, "America/Miquelon", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
            timezones0.put("America/Miquelon", tz);
            tz = new SimpleTimeZone(-7200000, "America/Noronha");
            timezones0.put("America/Noronha", tz);
            timezones0.put("Atlantic/South_Georgia", tz);
            tz = new SimpleTimeZone(-3600000, "America/Scoresbysund", 2, -1, 1, 0, 9, -1, 1, 0);
            timezones0.put("America/Scoresbysund", tz);
            timezones0.put("Atlantic/Azores", tz);
            tz = new SimpleTimeZone(-3600000, "Atlantic/Cape_Verde");
            timezones0.put("Atlantic/Cape_Verde", tz);
            timezones0.put("Atlantic/Jan_Mayen", tz);
            tz = new SimpleTimeZone(0, "GMT");
            timezones0.put("GMT", tz);
            timezones0.put("UTC", tz);
            timezones0.put("Africa/Abidjan", tz);
            timezones0.put("Africa/Accra", tz);
            timezones0.put("Africa/Bamako", tz);
            timezones0.put("Africa/Banjul", tz);
            timezones0.put("Africa/Bissau", tz);
            timezones0.put("Africa/Casablanca", tz);
            timezones0.put("Africa/Conakry", tz);
            timezones0.put("Africa/Dakar", tz);
            timezones0.put("Africa/El_Aaiun", tz);
            timezones0.put("Africa/Freetown", tz);
            timezones0.put("Africa/Lome", tz);
            timezones0.put("Africa/Monrovia", tz);
            timezones0.put("Africa/Nouakchott", tz);
            timezones0.put("Africa/Ouagadougou", tz);
            timezones0.put("Africa/Sao_Tome", tz);
            timezones0.put("Africa/Timbuktu", tz);
            timezones0.put("Atlantic/Reykjavik", tz);
            timezones0.put("Atlantic/St_Helena", tz);
            timezones0.put("Europe/Belfast", tz);
            timezones0.put("Europe/Dublin", tz);
            timezones0.put("Europe/London", tz);
            tz = new SimpleTimeZone(0, "WET", 2, -1, 1, 3600000, 9, -1, 1, 3600000);
            timezones0.put("WET", tz);
            timezones0.put("Atlantic/Canary", tz);
            timezones0.put("Atlantic/Faeroe", tz);
            timezones0.put("Atlantic/Madeira", tz);
            timezones0.put("Europe/Lisbon", tz);
            tz = new SimpleTimeZone(3600000, "Africa/Algiers");
            timezones0.put("Africa/Algiers", tz);
            timezones0.put("Africa/Bangui", tz);
            timezones0.put("Africa/Brazzaville", tz);
            timezones0.put("Africa/Douala", tz);
            timezones0.put("Africa/Kinshasa", tz);
            timezones0.put("Africa/Lagos", tz);
            timezones0.put("Africa/Libreville", tz);
            timezones0.put("Africa/Luanda", tz);
            timezones0.put("Africa/Malabo", tz);
            timezones0.put("Africa/Ndjamena", tz);
            timezones0.put("Africa/Niamey", tz);
            timezones0.put("Africa/Porto-Novo", tz);
            timezones0.put("Africa/Tunis", tz);
            tz = new SimpleTimeZone(3600000, "Africa/Windhoek", 8, 1, 1, 0x6DDD00, 3, 1, 1, 0x6DDD00);
            timezones0.put("Africa/Windhoek", tz);
            tz = new SimpleTimeZone(3600000, "CET", 2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
            timezones0.put("CET", tz);
            timezones0.put("ECT", tz);
            timezones0.put("MET", tz);
            timezones0.put("Africa/Ceuta", tz);
            timezones0.put("Arctic/Longyearbyen", tz);
            timezones0.put("Europe/Amsterdam", tz);
            timezones0.put("Europe/Andorra", tz);
            timezones0.put("Europe/Belgrade", tz);
            timezones0.put("Europe/Berlin", tz);
            timezones0.put("Europe/Bratislava", tz);
            timezones0.put("Europe/Brussels", tz);
            timezones0.put("Europe/Budapest", tz);
            timezones0.put("Europe/Copenhagen", tz);
            timezones0.put("Europe/Gibraltar", tz);
            timezones0.put("Europe/Ljubljana", tz);
            timezones0.put("Europe/Luxembourg", tz);
            timezones0.put("Europe/Madrid", tz);
            timezones0.put("Europe/Malta", tz);
            timezones0.put("Europe/Monaco", tz);
            timezones0.put("Europe/Oslo", tz);
            timezones0.put("Europe/Paris", tz);
            timezones0.put("Europe/Prague", tz);
            timezones0.put("Europe/Rome", tz);
            timezones0.put("Europe/San_Marino", tz);
            timezones0.put("Europe/Sarajevo", tz);
            timezones0.put("Europe/Skopje", tz);
            timezones0.put("Europe/Stockholm", tz);
            timezones0.put("Europe/Tirane", tz);
            timezones0.put("Europe/Vaduz", tz);
            timezones0.put("Europe/Vatican", tz);
            timezones0.put("Europe/Vienna", tz);
            timezones0.put("Europe/Warsaw", tz);
            timezones0.put("Europe/Zagreb", tz);
            timezones0.put("Europe/Zurich", tz);
            tz = new SimpleTimeZone(0x6DDD00, "ART", 3, -1, 6, 0, 8, -1, 5, 82800000);
            timezones0.put("ART", tz);
            timezones0.put("Africa/Cairo", tz);
            tz = new SimpleTimeZone(0x6DDD00, "CAT");
            timezones0.put("CAT", tz);
            timezones0.put("Africa/Blantyre", tz);
            timezones0.put("Africa/Bujumbura", tz);
            timezones0.put("Africa/Gaborone", tz);
            timezones0.put("Africa/Harare", tz);
            timezones0.put("Africa/Johannesburg", tz);
            timezones0.put("Africa/Kigali", tz);
            timezones0.put("Africa/Lubumbashi", tz);
            timezones0.put("Africa/Lusaka", tz);
            timezones0.put("Africa/Maputo", tz);
            timezones0.put("Africa/Maseru", tz);
            timezones0.put("Africa/Mbabane", tz);
            timezones0.put("Africa/Tripoli", tz);
            timezones0.put("Europe/Riga", tz);
            timezones0.put("Europe/Tallinn", tz);
            timezones0.put("Europe/Vilnius", tz);
            tz = new SimpleTimeZone(0x6DDD00, "Asia/Amman", 2, -1, 5, 0, 8, -1, 5, 0);
            timezones0.put("Asia/Amman", tz);
            tz = new SimpleTimeZone(0x6DDD00, "Asia/Beirut", 2, -1, 1, 0, 9, -1, 1, 0);
            timezones0.put("Asia/Beirut", tz);
            tz = new SimpleTimeZone(0x6DDD00, "Asia/Damascus", 3, 1, 0, 0, 9, 1, 0, 0);
            timezones0.put("Asia/Damascus", tz);
            tz = new SimpleTimeZone(0x6DDD00, "Asia/Gaza", 3, 3, 6, 0, 9, 3, 6, 0);
            timezones0.put("Asia/Gaza", tz);
            tz = new SimpleTimeZone(0x6DDD00, "Asia/Jerusalem", 3, 1, 0, 3600000, 9, 1, 0, 3600000);
            timezones0.put("Asia/Jerusalem", tz);
            tz = new SimpleTimeZone(0x6DDD00, "EET", 2, -1, 1, 10800000, 9, -1, 1, 10800000);
            timezones0.put("EET", tz);
            timezones0.put("Asia/Istanbul", tz);
            timezones0.put("Asia/Nicosia", tz);
            timezones0.put("Europe/Athens", tz);
            timezones0.put("Europe/Bucharest", tz);
            timezones0.put("Europe/Chisinau", tz);
            timezones0.put("Europe/Helsinki", tz);
            timezones0.put("Europe/Istanbul", tz);
            timezones0.put("Europe/Kiev", tz);
            timezones0.put("Europe/Nicosia", tz);
            timezones0.put("Europe/Simferopol", tz);
            timezones0.put("Europe/Sofia", tz);
            timezones0.put("Europe/Uzhgorod", tz);
            timezones0.put("Europe/Zaporozhye", tz);
            tz = new SimpleTimeZone(0x6DDD00, "Europe/Kaliningrad", 2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
            timezones0.put("Europe/Kaliningrad", tz);
            timezones0.put("Europe/Minsk", tz);
            tz = new SimpleTimeZone(10800000, "Asia/Baghdad", 3, 1, 0, 10800000, 9, 1, 0, 10800000);
            timezones0.put("Asia/Baghdad", tz);
            tz = new SimpleTimeZone(10800000, "Europe/Moscow", 2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
            timezones0.put("Europe/Moscow", tz);
            timezones0.put("Europe/Tiraspol", tz);
            tz = new SimpleTimeZone(10800000, "EAT");
            timezones0.put("EAT", tz);
            timezones0.put("Africa/Addis_Ababa", tz);
            timezones0.put("Africa/Asmera", tz);
            timezones0.put("Africa/Dar_es_Salaam", tz);
            timezones0.put("Africa/Djibouti", tz);
            timezones0.put("Africa/Kampala", tz);
            timezones0.put("Africa/Khartoum", tz);
            timezones0.put("Africa/Mogadishu", tz);
            timezones0.put("Africa/Nairobi", tz);
            timezones0.put("Antarctica/Syowa", tz);
            timezones0.put("Asia/Aden", tz);
            timezones0.put("Asia/Bahrain", tz);
            timezones0.put("Asia/Kuwait", tz);
            timezones0.put("Asia/Qatar", tz);
            timezones0.put("Asia/Riyadh", tz);
            timezones0.put("Indian/Antananarivo", tz);
            timezones0.put("Indian/Comoro", tz);
            timezones0.put("Indian/Mayotte", tz);
            tz = new SimpleTimeZone(12600000, "Asia/Tehran");
            timezones0.put("Asia/Tehran", tz);
            tz = new SimpleTimeZone(14400000, "Asia/Baku", 2, -1, 1, 3600000, 9, -1, 1, 3600000);
            timezones0.put("Asia/Baku", tz);
            tz = new SimpleTimeZone(14400000, "Asia/Aqtau", 2, -1, 1, 0, 9, -1, 1, 0);
            timezones0.put("Asia/Aqtau", tz);
            timezones0.put("Asia/Tbilisi", tz);
            tz = new SimpleTimeZone(14400000, "Asia/Yerevan", 2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
            timezones0.put("Asia/Yerevan", tz);
            timezones0.put("Europe/Samara", tz);
            tz = new SimpleTimeZone(14400000, "NET");
            timezones0.put("NET", tz);
            timezones0.put("Asia/Dubai", tz);
            timezones0.put("Asia/Muscat", tz);
            timezones0.put("Indian/Mahe", tz);
            timezones0.put("Indian/Mauritius", tz);
            timezones0.put("Indian/Reunion", tz);
            tz = new SimpleTimeZone(16200000, "Asia/Kabul");
            timezones0.put("Asia/Kabul", tz);
            tz = new SimpleTimeZone(18000000, "Asia/Aqtobe", 2, -1, 1, 0, 9, -1, 1, 0);
            timezones0.put("Asia/Aqtobe", tz);
            tz = new SimpleTimeZone(18000000, "Asia/Bishkek", 2, -1, 1, 9000000, 9, -1, 1, 9000000);
            timezones0.put("Asia/Bishkek", tz);
            tz = new SimpleTimeZone(18000000, "Asia/Yekaterinburg", 2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
            timezones0.put("Asia/Yekaterinburg", tz);
            tz = new SimpleTimeZone(18000000, "PLT");
            timezones0.put("PLT", tz);
            timezones0.put("Asia/Ashgabat", tz);
            timezones0.put("Asia/Dushanbe", tz);
            timezones0.put("Asia/Karachi", tz);
            timezones0.put("Asia/Samarkand", tz);
            timezones0.put("Asia/Tashkent", tz);
            timezones0.put("Indian/Chagos", tz);
            timezones0.put("Indian/Kerguelen", tz);
            timezones0.put("Indian/Maldives", tz);
            tz = new SimpleTimeZone(19800000, "IST");
            timezones0.put("IST", tz);
            timezones0.put("Asia/Calcutta", tz);
            tz = new SimpleTimeZone(20700000, "Asia/Katmandu");
            timezones0.put("Asia/Katmandu", tz);
            tz = new SimpleTimeZone(21600000, "BST");
            timezones0.put("BST", tz);
            timezones0.put("Antarctica/Mawson", tz);
            timezones0.put("Asia/Colombo", tz);
            timezones0.put("Asia/Dhaka", tz);
            timezones0.put("Asia/Thimphu", tz);
            tz = new SimpleTimeZone(21600000, "Asia/Almaty", 2, -1, 1, 0, 9, -1, 1, 0);
            timezones0.put("Asia/Almaty", tz);
            tz = new SimpleTimeZone(21600000, "Asia/Novosibirsk", 2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
            timezones0.put("Asia/Novosibirsk", tz);
            timezones0.put("Asia/Omsk", tz);
            tz = new SimpleTimeZone(23400000, "Asia/Rangoon");
            timezones0.put("Asia/Rangoon", tz);
            timezones0.put("Indian/Cocos", tz);
            tz = new SimpleTimeZone(25200000, "VST");
            timezones0.put("VST", tz);
            timezones0.put("Antarctica/Davis", tz);
            timezones0.put("Asia/Bangkok", tz);
            timezones0.put("Asia/Hovd", tz);
            timezones0.put("Asia/Jakarta", tz);
            timezones0.put("Asia/Phnom_Penh", tz);
            timezones0.put("Asia/Saigon", tz);
            timezones0.put("Asia/Vientiane", tz);
            timezones0.put("Indian/Christmas", tz);
            tz = new SimpleTimeZone(25200000, "Asia/Krasnoyarsk", 2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
            timezones0.put("Asia/Krasnoyarsk", tz);
            tz = new SimpleTimeZone(28800000, "CTT");
            timezones0.put("CTT", tz);
            timezones0.put("Antarctica/Casey", tz);
            timezones0.put("Asia/Brunei", tz);
            timezones0.put("Asia/Chungking", tz);
            timezones0.put("Asia/Harbin", tz);
            timezones0.put("Asia/Hong_Kong", tz);
            timezones0.put("Asia/Kashgar", tz);
            timezones0.put("Asia/Kuala_Lumpur", tz);
            timezones0.put("Asia/Kuching", tz);
            timezones0.put("Asia/Macao", tz);
            timezones0.put("Asia/Manila", tz);
            timezones0.put("Asia/Shanghai", tz);
            timezones0.put("Asia/Singapore", tz);
            timezones0.put("Asia/Taipei", tz);
            timezones0.put("Asia/Ujung_Pandang", tz);
            timezones0.put("Asia/Ulaanbaatar", tz);
            timezones0.put("Asia/Urumqi", tz);
            timezones0.put("Australia/Perth", tz);
            tz = new SimpleTimeZone(28800000, "Asia/Irkutsk", 2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
            timezones0.put("Asia/Irkutsk", tz);
            tz = new SimpleTimeZone(32400000, "JST");
            timezones0.put("JST", tz);
            timezones0.put("Asia/Dili", tz);
            timezones0.put("Asia/Jayapura", tz);
            timezones0.put("Asia/Pyongyang", tz);
            timezones0.put("Asia/Seoul", tz);
            timezones0.put("Asia/Tokyo", tz);
            timezones0.put("Pacific/Palau", tz);
            tz = new SimpleTimeZone(32400000, "Asia/Yakutsk", 2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
            timezones0.put("Asia/Yakutsk", tz);
            tz = new SimpleTimeZone(34200000, "Australia/Adelaide", 9, -1, 1, 0x6DDD00, 2, -1, 1, 0x6DDD00);
            timezones0.put("Australia/Adelaide", tz);
            timezones0.put("Australia/Broken_Hill", tz);
            tz = new SimpleTimeZone(34200000, "ACT");
            timezones0.put("ACT", tz);
            timezones0.put("Australia/Darwin", tz);
            tz = new SimpleTimeZone(36000000, "Antarctica/DumontDUrville");
            timezones0.put("Antarctica/DumontDUrville", tz);
            timezones0.put("Australia/Brisbane", tz);
            timezones0.put("Australia/Lindeman", tz);
            timezones0.put("Pacific/Guam", tz);
            timezones0.put("Pacific/Port_Moresby", tz);
            timezones0.put("Pacific/Saipan", tz);
            timezones0.put("Pacific/Truk", tz);
            timezones0.put("Pacific/Yap", tz);
            tz = new SimpleTimeZone(36000000, "Asia/Vladivostok", 2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
            timezones0.put("Asia/Vladivostok", tz);
            tz = new SimpleTimeZone(36000000, "Australia/Hobart", 9, 1, 1, 0x6DDD00, 2, -1, 1, 0x6DDD00);
            timezones0.put("Australia/Hobart", tz);
            tz = new SimpleTimeZone(36000000, "AET", 9, -1, 1, 0x6DDD00, 2, -1, 1, 0x6DDD00);
            timezones0.put("AET", tz);
            timezones0.put("Australia/Melbourne", tz);
            timezones0.put("Australia/Sydney", tz);
            tz = new SimpleTimeZone(37800000, "Australia/Lord_Howe", 9, -1, 1, 0x6DDD00, 2, -1, 1, 0x6DDD00, 1800000);
            timezones0.put("Australia/Lord_Howe", tz);
            tz = new SimpleTimeZone(39600000, "Asia/Magadan", 2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
            timezones0.put("Asia/Magadan", tz);
            tz = new SimpleTimeZone(39600000, "SST");
            timezones0.put("SST", tz);
            timezones0.put("Pacific/Efate", tz);
            timezones0.put("Pacific/Guadalcanal", tz);
            timezones0.put("Pacific/Kosrae", tz);
            timezones0.put("Pacific/Noumea", tz);
            timezones0.put("Pacific/Ponape", tz);
            tz = new SimpleTimeZone(41400000, "Pacific/Norfolk");
            timezones0.put("Pacific/Norfolk", tz);
            tz = new SimpleTimeZone(43200000, "NST", 9, 1, 1, 0x6DDD00, 2, 3, 1, 0x6DDD00);
            timezones0.put("NST", tz);
            timezones0.put("Antarctica/McMurdo", tz);
            timezones0.put("Antarctica/South_Pole", tz);
            timezones0.put("Pacific/Auckland", tz);
            tz = new SimpleTimeZone(43200000, "Asia/Anadyr", 2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
            timezones0.put("Asia/Anadyr", tz);
            timezones0.put("Asia/Kamchatka", tz);
            tz = new SimpleTimeZone(43200000, "Pacific/Fiji");
            timezones0.put("Pacific/Fiji", tz);
            timezones0.put("Pacific/Funafuti", tz);
            timezones0.put("Pacific/Kwajalein", tz);
            timezones0.put("Pacific/Majuro", tz);
            timezones0.put("Pacific/Nauru", tz);
            timezones0.put("Pacific/Tarawa", tz);
            timezones0.put("Pacific/Wake", tz);
            timezones0.put("Pacific/Wallis", tz);
            tz = new SimpleTimeZone(45900000, "Pacific/Chatham", 9, 1, 1, 9900000, 2, 3, 1, 9900000);
            timezones0.put("Pacific/Chatham", tz);
            tz = new SimpleTimeZone(46800000, "Pacific/Enderbury");
            timezones0.put("Pacific/Enderbury", tz);
            timezones0.put("Pacific/Tongatapu", tz);
            tz = new SimpleTimeZone(50400000, "Pacific/Kiritimati");
            timezones0.put("Pacific/Kiritimati", tz);
        }
        return timezones0;
    }

    private static native String getDefaultTimeZoneId();

    public abstract int getOffset(int var1, int var2, int var3, int var4, int var5, int var6);

    public int getOffset(long date) {
        if (this.inDaylightTime(new Date(date))) {
            return this.getRawOffset() + this.getDSTSavings();
        }
        return this.getRawOffset();
    }

    public abstract int getRawOffset();

    public abstract void setRawOffset(int var1);

    public String getID() {
        return this.ID;
    }

    public void setID(String id) {
        this.ID = id;
    }

    public final String getDisplayName() {
        return this.getDisplayName(false, 1, Locale.getDefault());
    }

    public final String getDisplayName(Locale locale) {
        return this.getDisplayName(false, 1, locale);
    }

    public final String getDisplayName(boolean dst, int style) {
        return this.getDisplayName(dst, style, Locale.getDefault());
    }

    public String getDisplayName(boolean dst, int style, Locale locale) {
        try {
            DateFormatSymbols dfs = new DateFormatSymbols(locale);
            String[][] zoneinfo = dfs.getZoneStrings();
            for (int i = 0; i < zoneinfo.length; ++i) {
                if (!zoneinfo[i][0].equals(this.getID())) continue;
                if (!dst) {
                    if (style == 0) {
                        return zoneinfo[i][2];
                    }
                    return zoneinfo[i][1];
                }
                if (style == 0) {
                    return zoneinfo[i][4];
                }
                return zoneinfo[i][3];
            }
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        return this.getDefaultDisplayName(dst);
    }

    private String getDefaultDisplayName(boolean dst) {
        int offset = this.getRawOffset();
        if (dst && this instanceof SimpleTimeZone) {
            offset += ((SimpleTimeZone)this).getDSTSavings();
        }
        StringBuffer sb = new StringBuffer(9);
        sb.append("GMT");
        sb.append(offset >= 0 ? (char)'+' : '-');
        offset = Math.abs(offset) / 60000;
        int hours = offset / 60;
        int minutes = offset % 60;
        sb.append((char)(48 + hours / 10)).append((char)(48 + hours % 10));
        sb.append(':');
        sb.append((char)(48 + minutes / 10)).append((char)(48 + minutes % 10));
        return sb.toString();
    }

    public abstract boolean useDaylightTime();

    public abstract boolean inDaylightTime(Date var1);

    public int getDSTSavings() {
        if (this.useDaylightTime()) {
            return 3600000;
        }
        return 0;
    }

    public static TimeZone getTimeZone(String ID) {
        TimeZone tz = (TimeZone)TimeZone.timezones().get(ID);
        if (tz != null) {
            if (tz.getID().equals(ID)) {
                return tz;
            }
            tz = (TimeZone)tz.clone();
            tz.setID(ID);
            TimeZone.timezones().put(ID, tz);
            return tz;
        }
        if (ID.startsWith("GMT")) {
            int pos = 3;
            int offset_direction = 1;
            if (ID.charAt(pos) == '-') {
                offset_direction = -1;
                ++pos;
            } else if (ID.charAt(pos) == '+') {
                ++pos;
            }
            try {
                int minute;
                int hour;
                String offset_str = ID.substring(pos);
                int idx = offset_str.indexOf(":");
                if (idx != -1) {
                    hour = Integer.parseInt(offset_str.substring(0, idx));
                    minute = Integer.parseInt(offset_str.substring(idx + 1));
                } else {
                    int offset_length = offset_str.length();
                    if (offset_length <= 2) {
                        hour = Integer.parseInt(offset_str);
                        minute = 0;
                    } else {
                        hour = Integer.parseInt(offset_str.substring(0, offset_length - 2));
                        minute = Integer.parseInt(offset_str.substring(offset_length - 2));
                    }
                }
                return new SimpleTimeZone((hour * 3600000 + minute * 60000) * offset_direction, ID);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return TimeZone.getTimeZone("GMT");
    }

    public static String[] getAvailableIDs(int rawOffset) {
        int count = 0;
        Iterator iter = TimeZone.timezones().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            if (((TimeZone)entry.getValue()).getRawOffset() != rawOffset) continue;
            ++count;
        }
        String[] ids = new String[count];
        count = 0;
        iter = TimeZone.timezones().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            if (((TimeZone)entry.getValue()).getRawOffset() != rawOffset) continue;
            ids[count++] = (String)entry.getKey();
        }
        return ids;
    }

    public static String[] getAvailableIDs() {
        return (String[])TimeZone.timezones().keySet().toArray(new String[TimeZone.timezones().size()]);
    }

    public static TimeZone getDefault() {
        return TimeZone.defaultZone();
    }

    public static void setDefault(TimeZone zone) {
        defaultZone0 = zone;
    }

    public boolean hasSameRules(TimeZone other) {
        return other.getRawOffset() == this.getRawOffset();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }
}

