/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class WindowsTabbedPaneUI
extends BasicTabbedPaneUI {
    private static Set managingFocusForwardTraversalKeys;
    private static Set managingFocusBackwardTraversalKeys;
    private boolean contentOpaque = true;

    protected void installDefaults() {
        super.installDefaults();
        this.contentOpaque = UIManager.getBoolean("TabbedPane.contentOpaque");
        if (managingFocusForwardTraversalKeys == null) {
            managingFocusForwardTraversalKeys = new TreeSet();
            managingFocusForwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 0));
        }
        this.tabPane.setFocusTraversalKeys(0, managingFocusForwardTraversalKeys);
        if (managingFocusBackwardTraversalKeys == null) {
            managingFocusBackwardTraversalKeys = new TreeSet();
            managingFocusBackwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 1));
        }
        this.tabPane.setFocusTraversalKeys(1, managingFocusBackwardTraversalKeys);
    }

    protected void uninstallDefaults() {
        this.tabPane.setFocusTraversalKeys(0, null);
        this.tabPane.setFocusTraversalKeys(1, null);
        super.uninstallDefaults();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsTabbedPaneUI();
    }

    protected void setRolloverTab(int n2) {
        if (XPStyle.getXP() != null) {
            int n3 = this.getRolloverTab();
            super.setRolloverTab(n2);
            Rectangle rectangle = null;
            Rectangle rectangle2 = null;
            if (n3 >= 0 && n3 < this.tabPane.getTabCount()) {
                rectangle = this.getTabBounds(this.tabPane, n3);
            }
            if (n2 >= 0) {
                rectangle2 = this.getTabBounds(this.tabPane, n2);
            }
            if (rectangle != null) {
                if (rectangle2 != null) {
                    this.tabPane.repaint(rectangle.union(rectangle2));
                } else {
                    this.tabPane.repaint(rectangle);
                }
            } else if (rectangle2 != null) {
                this.tabPane.repaint(rectangle2);
            }
        }
    }

    protected void paintContentBorder(Graphics graphics, int n2, int n3) {
        XPStyle.Skin skin;
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null && (this.contentOpaque || this.tabPane.isOpaque()) && (skin = xPStyle.getSkin("tab.pane")) != null) {
            int n4;
            Insets insets = this.tabPane.getInsets();
            Insets insets2 = UIManager.getInsets("TabbedPane.tabAreaInsets");
            int n5 = insets.left;
            int n6 = insets.top;
            int n7 = this.tabPane.getWidth() - insets.right - insets.left;
            int n8 = this.tabPane.getHeight() - insets.top - insets.bottom;
            if (n2 == 2 || n2 == 4) {
                n4 = this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth);
                if (n2 == 2) {
                    n5 += n4 - insets2.bottom;
                }
                n7 -= n4 - insets2.bottom;
            } else {
                n4 = this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight);
                if (n2 == 1) {
                    n6 += n4 - insets2.bottom;
                }
                n8 -= n4 - insets2.bottom;
            }
            Color color = xPStyle.getColor("tab.pane.bordercolorhint", null);
            if (color != null) {
                graphics.setColor(color);
                graphics.fillRect(n5, n6, n7, n8);
            }
            this.paintRotatedSkin(graphics, skin, n2, n5, n6, n7, n8, 0);
            return;
        }
        super.paintContentBorder(graphics, n2, n3);
    }

    protected void paintTabBackground(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        if (XPStyle.getXP() == null) {
            super.paintTabBackground(graphics, n2, n3, n4, n5, n6, n7, bl2);
        }
    }

    protected void paintTabBorder(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            String string;
            int n8 = this.tabPane.getTabCount();
            int n9 = this.getRunForTab(n8, n3);
            if (this.tabRuns[n9] == n3) {
                string = "tab.tabitemleftedge";
            } else if (n8 > 1 && this.lastTabInRun(n8, n9) == n3) {
                string = "tab.tabitemrightedge";
                if (bl2) {
                    if (n2 == 1 || n2 == 3) {
                        ++n6;
                    } else {
                        ++n7;
                    }
                }
            } else {
                string = "tab.tabitem";
            }
            int n10 = 0;
            if (bl2) {
                n10 = 2;
            } else if (n3 == this.getRolloverTab()) {
                n10 = 1;
            }
            this.paintRotatedSkin(graphics, xPStyle.getSkin(string), n2, n4, n5, n6, n7, n10);
        } else {
            super.paintTabBorder(graphics, n2, n3, n4, n5, n6, n7, bl2);
        }
    }

    private void paintRotatedSkin(Graphics graphics, XPStyle.Skin skin, int n2, int n3, int n4, int n5, int n6, int n7) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.translate(n3, n4);
        switch (n2) {
            case 4: {
                graphics2D.translate(n5, 0);
                graphics2D.rotate(Math.toRadians(90.0));
                skin.paintSkin(graphics2D, 0, 0, n6, n5, n7);
                break;
            }
            case 2: {
                graphics2D.scale(-1.0, 1.0);
                graphics2D.rotate(Math.toRadians(90.0));
                skin.paintSkin(graphics2D, 0, 0, n6, n5, n7);
                break;
            }
            case 3: {
                graphics2D.translate(0, n6);
                graphics2D.scale(-1.0, 1.0);
                graphics2D.rotate(Math.toRadians(180.0));
                skin.paintSkin(graphics2D, 0, 0, n5, n6, n7);
                break;
            }
            default: {
                skin.paintSkin(graphics2D, 0, 0, n5, n6, n7);
            }
        }
        graphics2D.dispose();
    }
}

