/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.security;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import javax.security.auth.Subject;
import javax.security.auth.SubjectDomainCombiner;

public class JMXSubjectDomainCombiner
extends SubjectDomainCombiner {
    private static final CodeSource nullCodeSource = new CodeSource(null, (Certificate[])null);
    private static final ProtectionDomain pdNoPerms = new ProtectionDomain(nullCodeSource, new Permissions());
    private static final Permissions allPermissions = new Permissions();
    private static final ProtectionDomain pdAllPerms;
    private static final AccessControlContext systemACC;

    public JMXSubjectDomainCombiner(Subject subject) {
        super(subject);
    }

    public ProtectionDomain[] combine(ProtectionDomain[] protectionDomainArray, ProtectionDomain[] protectionDomainArray2) {
        ProtectionDomain[] protectionDomainArray3;
        if (protectionDomainArray == null || protectionDomainArray.length == 0) {
            protectionDomainArray3 = new ProtectionDomain[]{pdNoPerms};
        } else {
            protectionDomainArray3 = new ProtectionDomain[protectionDomainArray.length + 1];
            for (int i2 = 0; i2 < protectionDomainArray.length; ++i2) {
                protectionDomainArray3[i2] = protectionDomainArray[i2];
            }
            protectionDomainArray3[protectionDomainArray.length] = pdNoPerms;
        }
        return super.combine(protectionDomainArray3, protectionDomainArray2);
    }

    private static boolean hasOnlySystemCode(AccessControlContext accessControlContext) {
        return systemACC.equals(accessControlContext);
    }

    public static AccessControlContext getContext(Subject subject) {
        AccessControlContext accessControlContext = AccessController.getContext();
        if (JMXSubjectDomainCombiner.hasOnlySystemCode(accessControlContext)) {
            accessControlContext = new AccessControlContext(new ProtectionDomain[]{pdAllPerms});
        }
        return new AccessControlContext(accessControlContext, new JMXSubjectDomainCombiner(subject));
    }

    static {
        allPermissions.add(new AllPermission());
        pdAllPerms = new ProtectionDomain(nullCodeSource, allPermissions);
        systemACC = new AccessControlContext(new ProtectionDomain[0]);
    }
}

