/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.management.Attribute;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class MBeanServerInvocationHandler
implements InvocationHandler {
    private final MBeanServerConnection connection;
    private final ObjectName objectName;

    public MBeanServerInvocationHandler(MBeanServerConnection mBeanServerConnection, ObjectName objectName) {
        this.connection = mBeanServerConnection;
        this.objectName = objectName;
    }

    public static Object newProxyInstance(MBeanServerConnection mBeanServerConnection, ObjectName objectName, Class clazz, boolean bl2) {
        MBeanServerInvocationHandler mBeanServerInvocationHandler = new MBeanServerInvocationHandler(mBeanServerConnection, objectName);
        Class[] classArray = bl2 ? new Class[]{clazz, NotificationEmitter.class} : new Class[]{clazz};
        return Proxy.newProxyInstance(clazz.getClassLoader(), classArray, mBeanServerInvocationHandler);
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        int n2;
        Class<?> clazz = method.getDeclaringClass();
        if (clazz.equals(NotificationBroadcaster.class) || clazz.equals(NotificationEmitter.class)) {
            return this.invokeBroadcasterMethod(object, method, objectArray);
        }
        String string = method.getName();
        Class<?>[] classArray = method.getParameterTypes();
        Class<?> clazz2 = method.getReturnType();
        int n3 = n2 = objectArray == null ? 0 : objectArray.length;
        if (string.startsWith("get") && string.length() > 3 && n2 == 0 && !clazz2.equals(Void.TYPE)) {
            return this.connection.getAttribute(this.objectName, string.substring(3));
        }
        if (string.startsWith("is") && string.length() > 2 && n2 == 0 && (clazz2.equals(Boolean.TYPE) || clazz2.equals(Boolean.class))) {
            return this.connection.getAttribute(this.objectName, string.substring(2));
        }
        if (string.startsWith("set") && string.length() > 3 && n2 == 1 && clazz2.equals(Void.TYPE)) {
            Attribute attribute = new Attribute(string.substring(3), objectArray[0]);
            this.connection.setAttribute(this.objectName, attribute);
            return null;
        }
        String[] stringArray = new String[classArray.length];
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            stringArray[i2] = classArray[i2].getName();
        }
        try {
            return this.connection.invoke(this.objectName, string, objectArray, stringArray);
        }
        catch (MBeanException mBeanException) {
            throw mBeanException.getTargetException();
        }
    }

    private Object invokeBroadcasterMethod(Object object, Method method, Object[] objectArray) throws Exception {
        int n2;
        String string = method.getName();
        int n3 = n2 = objectArray == null ? 0 : objectArray.length;
        if (string.equals("addNotificationListener")) {
            if (n2 != 3) {
                String string2 = "Bad arg count to addNotificationListener: " + n2;
                throw new IllegalArgumentException(string2);
            }
            NotificationListener notificationListener = (NotificationListener)objectArray[0];
            NotificationFilter notificationFilter = (NotificationFilter)objectArray[1];
            Object object2 = objectArray[2];
            this.connection.addNotificationListener(this.objectName, notificationListener, notificationFilter, object2);
            return null;
        }
        if (string.equals("removeNotificationListener")) {
            NotificationListener notificationListener = (NotificationListener)objectArray[0];
            switch (n2) {
                case 1: {
                    this.connection.removeNotificationListener(this.objectName, notificationListener);
                    return null;
                }
                case 3: {
                    NotificationFilter notificationFilter = (NotificationFilter)objectArray[1];
                    Object object3 = objectArray[2];
                    this.connection.removeNotificationListener(this.objectName, notificationListener, notificationFilter, object3);
                    return null;
                }
            }
            String string3 = "Bad arg count to removeNotificationListener: " + n2;
            throw new IllegalArgumentException(string3);
        }
        if (string.equals("getNotificationInfo")) {
            if (objectArray != null) {
                throw new IllegalArgumentException("getNotificationInfo has args");
            }
            MBeanInfo mBeanInfo = this.connection.getMBeanInfo(this.objectName);
            return mBeanInfo.getNotifications();
        }
        throw new IllegalArgumentException("Bad method name: " + string);
    }
}

