/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import sun.security.provider.certpath.CertificateRevokedException;
import sun.security.provider.certpath.CrlRevocationChecker;
import sun.security.provider.certpath.OCSPChecker;
import sun.security.util.Debug;

class PKIXMasterCertPathValidator {
    private static final Debug debug = Debug.getInstance("certpath");
    private List certPathCheckers;

    PKIXMasterCertPathValidator(List list) {
        this.certPathCheckers = list;
    }

    void validate(CertPath certPath, List list) throws CertPathValidatorException {
        X509Certificate x509Certificate = null;
        PKIXCertPathChecker pKIXCertPathChecker = null;
        int n2 = list.size();
        if (debug != null) {
            debug.println("--------------------------------------------------------------");
            debug.println("Executing PKIX certification path validation algorithm.");
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object;
            Set set;
            if (debug != null) {
                debug.println("Checking cert" + (i2 + 1) + " ...");
            }
            if ((set = (x509Certificate = (X509Certificate)list.get(i2)).getCriticalExtensionOIDs()) == null) {
                set = Collections.EMPTY_SET;
            }
            if (debug != null && !set.isEmpty()) {
                debug.println("Set of critical extensions:");
                object = set.iterator();
                while (object.hasNext()) {
                    debug.println((String)object.next());
                }
            }
            object = null;
            for (int i3 = 0; i3 < this.certPathCheckers.size(); ++i3) {
                block19: {
                    pKIXCertPathChecker = (PKIXCertPathChecker)this.certPathCheckers.get(i3);
                    if (debug != null) {
                        debug.println("-Using checker" + (i3 + 1) + " ... [" + pKIXCertPathChecker.getClass().getName() + "]");
                    }
                    if (i2 == 0) {
                        pKIXCertPathChecker.init(false);
                    }
                    try {
                        pKIXCertPathChecker.check(x509Certificate, set);
                        if (this.isRevocationCheck(pKIXCertPathChecker, i3, this.certPathCheckers)) {
                            if (debug != null) {
                                debug.println("-checker" + (i3 + 1) + " validation succeeded");
                            }
                            ++i3;
                            continue;
                        }
                    }
                    catch (CertPathValidatorException certPathValidatorException) {
                        if (object != null && pKIXCertPathChecker instanceof CrlRevocationChecker) {
                            throw object;
                        }
                        CertPathValidatorException certPathValidatorException2 = new CertPathValidatorException(certPathValidatorException.getMessage(), certPathValidatorException.getCause(), certPath, n2 - (i2 + 1));
                        if (certPathValidatorException instanceof CertificateRevokedException) {
                            throw certPathValidatorException2;
                        }
                        if (!this.isRevocationCheck(pKIXCertPathChecker, i3, this.certPathCheckers)) {
                            throw certPathValidatorException2;
                        }
                        object = certPathValidatorException2;
                        if (debug == null) break block19;
                        debug.println(certPathValidatorException.getMessage());
                        debug.println("preparing to failover (from OCSP to CRLs)");
                    }
                }
                if (debug == null) continue;
                debug.println("-checker" + (i3 + 1) + " validation succeeded");
            }
            if (debug != null) {
                debug.println("checking for unresolvedCritExts");
            }
            if (!set.isEmpty()) {
                throw new CertPathValidatorException("unrecognized critical extension(s)", null, certPath, n2 - (i2 + 1));
            }
            if (debug == null) continue;
            debug.println("\ncert" + (i2 + 1) + " validation succeeded.\n");
        }
        if (debug != null) {
            debug.println("Cert path validation succeeded. (PKIX validation algorithm)");
            debug.println("--------------------------------------------------------------");
        }
    }

    private boolean isRevocationCheck(PKIXCertPathChecker pKIXCertPathChecker, int n2, List list) {
        Object e2;
        return pKIXCertPathChecker instanceof OCSPChecker && n2 + 1 < list.size() && (e2 = list.get(n2 + 1)) instanceof CrlRevocationChecker;
    }
}

