/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.provider;

import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.der.DERWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;

public class DSASignature
extends SignatureSpi {
    private DSAPublicKey publicKey;
    private DSAPrivateKey privateKey;
    private MessageDigest digest;

    private /* synthetic */ void finit$() {
        this.digest = null;
    }

    public DSASignature() {
        this.finit$();
    }

    private void init() {
        if (this.digest == null) {
            try {
                this.digest = MessageDigest.getInstance("SHA1", "GNU");
            }
            catch (NoSuchAlgorithmException nsae) {
                this.digest = null;
            }
            catch (NoSuchProviderException nspe) {
                this.digest = null;
            }
        }
        this.digest.reset();
    }

    public void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof DSAPublicKey)) {
            throw new InvalidKeyException();
        }
        this.publicKey = (DSAPublicKey)publicKey;
        this.init();
    }

    public void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof DSAPrivateKey)) {
            throw new InvalidKeyException();
        }
        this.privateKey = (DSAPrivateKey)privateKey;
        this.init();
    }

    public void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        if (!(privateKey instanceof DSAPrivateKey)) {
            throw new InvalidKeyException();
        }
        this.privateKey = (DSAPrivateKey)privateKey;
        this.appRandom = random;
        this.init();
    }

    public void engineUpdate(byte b) throws SignatureException {
        if (this.digest == null) {
            throw new SignatureException();
        }
        this.digest.update(b);
    }

    public void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        if (this.digest == null) {
            throw new SignatureException();
        }
        this.digest.update(b, off, len);
    }

    public byte[] engineSign() throws SignatureException {
        if (this.digest == null) {
            throw new SignatureException();
        }
        if (this.privateKey == null) {
            throw new SignatureException();
        }
        try {
            BigInteger g = this.privateKey.getParams().getG();
            BigInteger p = this.privateKey.getParams().getP();
            BigInteger q = this.privateKey.getParams().getQ();
            BigInteger x = this.privateKey.getX();
            BigInteger k = new BigInteger(159, this.appRandom);
            BigInteger r = g.modPow(k, p);
            r = r.mod(q);
            byte[] bytes = this.digest.digest();
            BigInteger sha = new BigInteger(1, bytes);
            BigInteger s = sha.add(x.multiply(r));
            s = s.multiply(k.modInverse(q)).mod(q);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ArrayList seq = new ArrayList(2);
            seq.set(0, new DERValue(2, r));
            seq.set(1, new DERValue(2, s));
            DERWriter.write(bout, new DERValue(48, seq));
            return bout.toByteArray();
        }
        catch (IOException ioe) {
            throw new SignatureException();
        }
        catch (ArithmeticException ae) {
            throw new SignatureException();
        }
    }

    public int engineSign(byte[] outbuf, int offset, int len) throws SignatureException {
        byte[] tmp = this.engineSign();
        if (tmp.length > len) {
            throw new SignatureException();
        }
        System.arraycopy(tmp, 0, outbuf, offset, tmp.length);
        return tmp.length;
    }

    public boolean engineVerify(byte[] sigBytes) throws SignatureException {
        try {
            DERReader in = new DERReader(sigBytes);
            DERValue val = in.read();
            if (!val.isConstructed()) {
                throw new SignatureException("badly formed signature");
            }
            BigInteger r = (BigInteger)in.read().getValue();
            BigInteger s = (BigInteger)in.read().getValue();
            BigInteger g = this.publicKey.getParams().getG();
            BigInteger p = this.publicKey.getParams().getP();
            BigInteger q = this.publicKey.getParams().getQ();
            BigInteger y = this.publicKey.getY();
            BigInteger w = s.modInverse(q);
            byte[] bytes = this.digest.digest();
            BigInteger sha = new BigInteger(1, bytes);
            BigInteger u1 = w.multiply(sha).mod(q);
            BigInteger u2 = r.multiply(w).mod(q);
            BigInteger v = g.modPow(u1, p).multiply(y.modPow(u2, p)).mod(p).mod(q);
            return v.equals(r);
        }
        catch (IOException ioe) {
            throw new SignatureException("badly formed signature");
        }
    }

    public void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new InvalidParameterException();
    }

    public void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        throw new InvalidParameterException();
    }

    public Object engineGetParameter(String param) throws InvalidParameterException {
        throw new InvalidParameterException();
    }

    public Object clone() {
        return new DSASignature(this);
    }

    private DSASignature(DSASignature copy) {
        this();
        this.publicKey = copy.publicKey;
        this.privateKey = copy.privateKey;
        this.digest = copy.digest;
    }
}

