/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JSplitPane;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.netbeans.lib.profiler.ui.components.JTitledPanel;

public class JExtendedSplitPane
extends JSplitPane {
    private ActionListener splitPaneActionListener = new SplitPaneActionListener();
    private ComponentListener splitPaneComponentListener = new SplitPaneComponentListener();
    private double dividerLocation;
    private int dividerSize;

    public JExtendedSplitPane() {
    }

    public JExtendedSplitPane(int newOrientation) {
        super(newOrientation);
    }

    public JExtendedSplitPane(int newOrientation, boolean newContinuousLayout) {
        super(newOrientation, newContinuousLayout);
    }

    public JExtendedSplitPane(int newOrientation, boolean newContinuousLayout, Component newLeftComponent, Component newRightComponent) {
        super(newOrientation, newContinuousLayout, newLeftComponent, newRightComponent);
        this.registerListeners(newLeftComponent);
        this.registerListeners(newRightComponent);
        this.updateVisibility();
        if (!newLeftComponent.isVisible()) {
            this.computeDividerLocationWhenInitiallyHidden(newLeftComponent);
        }
        if (!newRightComponent.isVisible()) {
            this.computeDividerLocationWhenInitiallyHidden(newRightComponent);
        }
    }

    public JExtendedSplitPane(int newOrientation, Component newLeftComponent, Component newRightComponent) {
        super(newOrientation, newLeftComponent, newRightComponent);
        this.registerListeners(newLeftComponent);
        this.registerListeners(newRightComponent);
        this.updateVisibility();
        if (!newLeftComponent.isVisible()) {
            this.computeDividerLocationWhenInitiallyHidden(newLeftComponent);
        }
        if (!newRightComponent.isVisible()) {
            this.computeDividerLocationWhenInitiallyHidden(newRightComponent);
        }
    }

    public void setBottomComponent(Component comp) {
        this.setRightComponent(comp);
    }

    public void setDividerSize(int newSize) {
        super.setDividerSize(newSize);
        this.dividerSize = newSize;
    }

    public void setLeftComponent(Component comp) {
        if (this.getLeftComponent() != null) {
            this.unregisterListeners(this.getLeftComponent());
        }
        super.setLeftComponent(comp);
        if (this.getLeftComponent() != null) {
            this.registerListeners(this.getLeftComponent());
        }
        this.updateVisibility();
    }

    public void setRightComponent(Component comp) {
        if (this.getRightComponent() != null) {
            this.unregisterListeners(this.getRightComponent());
        }
        super.setRightComponent(comp);
        if (this.getRightComponent() != null) {
            this.registerListeners(this.getRightComponent());
        }
        this.updateVisibility();
    }

    public void setTopComponent(Component comp) {
        this.setLeftComponent(comp);
    }

    public BasicSplitPaneDivider getDivider() {
        if (this.getUI() == null) {
            return null;
        }
        return ((BasicSplitPaneUI)this.getUI()).getDivider();
    }

    private Component getFirstComponent() {
        if (this.getOrientation() == 1) {
            return this.getLeftComponent();
        }
        return this.getTopComponent();
    }

    private Component getSecondComponent() {
        if (this.getOrientation() == 1) {
            return this.getRightComponent();
        }
        return this.getBottomComponent();
    }

    private void computeDividerLocationWhenHidden(Component hiddenComponent) {
        if (this.getTopComponent().isVisible() || this.getBottomComponent().isVisible()) {
            this.dividerLocation = this.getOrientation() == 1 ? (hiddenComponent == this.getFirstComponent() ? (double)hiddenComponent.getSize().width / (this.getSize().getWidth() - (double)this.dividerSize) : (this.getSize().getWidth() - (double)this.dividerSize - (double)hiddenComponent.getSize().width) / (this.getSize().getWidth() - (double)this.dividerSize)) : (hiddenComponent == this.getFirstComponent() ? (double)hiddenComponent.getSize().height / (this.getSize().getHeight() - (double)this.dividerSize) : (this.getSize().getHeight() - (double)this.dividerSize - (double)hiddenComponent.getSize().height) / (this.getSize().getHeight() - (double)this.dividerSize));
        }
    }

    private void computeDividerLocationWhenInitiallyHidden(Component hiddenComponent) {
        if (this.getTopComponent().isVisible() || this.getBottomComponent().isVisible()) {
            this.dividerLocation = this.getOrientation() == 1 ? (hiddenComponent == this.getFirstComponent() ? (double)hiddenComponent.getPreferredSize().width / (this.getPreferredSize().getWidth() - (double)this.dividerSize) : (this.getPreferredSize().getWidth() - (double)this.dividerSize - (double)hiddenComponent.getPreferredSize().width) / (this.getPreferredSize().getWidth() - (double)this.dividerSize)) : (hiddenComponent == this.getFirstComponent() ? (double)hiddenComponent.getPreferredSize().height / (this.getPreferredSize().getHeight() - (double)this.dividerSize) : (this.getPreferredSize().getHeight() - (double)this.dividerSize - (double)hiddenComponent.getPreferredSize().height) / (this.getPreferredSize().getHeight() - (double)this.dividerSize));
        }
    }

    private void registerListeners(Component component) {
        if (this.splitPaneComponentListener != null) {
            component.addComponentListener(this.splitPaneComponentListener);
        }
        if (this.splitPaneActionListener != null && component instanceof JTitledPanel) {
            ((JTitledPanel)component).addActionListener(this.splitPaneActionListener);
        }
    }

    private void unregisterListeners(Component component) {
        if (this.splitPaneComponentListener != null) {
            component.removeComponentListener(this.splitPaneComponentListener);
        }
        if (this.splitPaneActionListener != null && component instanceof JTitledPanel) {
            ((JTitledPanel)component).removeActionListener(this.splitPaneActionListener);
        }
    }

    private void updateVisibility() {
        Component firstComponent = this.getFirstComponent();
        Component secondComponent = this.getSecondComponent();
        BasicSplitPaneDivider divider = this.getDivider();
        if (firstComponent == null || secondComponent == null || divider == null) {
            return;
        }
        if (firstComponent.isVisible() && secondComponent.isVisible()) {
            if (!divider.isVisible()) {
                super.setDividerSize(this.dividerSize);
                divider.setVisible(true);
                this.setDividerLocation(this.dividerLocation);
            }
            if (!this.isVisible()) {
                this.setVisible(true);
            }
        } else if (!firstComponent.isVisible() && !secondComponent.isVisible()) {
            if (this.isVisible()) {
                this.setVisible(false);
            }
        } else {
            if (divider.isVisible()) {
                super.setDividerSize(0);
                divider.setVisible(false);
                this.setDividerLocation(0);
            }
            if (!this.isVisible()) {
                this.setVisible(true);
            }
        }
    }

    private class SplitPaneComponentListener
    extends ComponentAdapter {
        private SplitPaneComponentListener() {
        }

        public void componentHidden(ComponentEvent e) {
            JExtendedSplitPane.this.computeDividerLocationWhenHidden(e.getComponent());
            if (JExtendedSplitPane.this.dividerLocation == 0.0 || JExtendedSplitPane.this.dividerLocation == 1.0) {
                JExtendedSplitPane.this.dividerLocation = 0.5;
            }
            JExtendedSplitPane.this.updateVisibility();
        }

        public void componentShown(ComponentEvent e) {
            JExtendedSplitPane.this.updateVisibility();
        }
    }

    private class SplitPaneActionListener
    implements ActionListener {
        private SplitPaneActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            switch (e.getID()) {
                case 1000: {
                    break;
                }
                case 1001: {
                    JExtendedSplitPane.this.setDividerLocation(JExtendedSplitPane.this.getLastDividerLocation());
                    break;
                }
                case 1002: {
                    break;
                }
                case 1003: {
                    if (e.getSource() == JExtendedSplitPane.this.getFirstComponent()) {
                        JExtendedSplitPane.this.setDividerLocation(((JExtendedSplitPane)JExtendedSplitPane.this).getFirstComponent().getPreferredSize().height);
                        break;
                    }
                    JExtendedSplitPane.this.setDividerLocation(JExtendedSplitPane.this.getSize().height - JExtendedSplitPane.this.dividerSize - ((JExtendedSplitPane)JExtendedSplitPane.this).getSecondComponent().getPreferredSize().height);
                }
            }
        }
    }
}

