/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.lib.profiler.ui.UIUtils;

public class SnippetPanel
extends JPanel
implements MouseListener,
KeyListener,
FocusListener {
    private static Color lineColor;
    private static Color backgroundColor;
    private static Color focusedBackgroundColor;
    private static Color textColor;
    private JComponent content;
    private String snippetName;
    private Title title;
    private boolean collapsed = false;

    public SnippetPanel(String snippetName, JComponent content) {
        this.snippetName = snippetName;
        this.content = content;
        this.setLayout(new BorderLayout());
        this.title = new Title(snippetName){

            public AccessibleContext getAccessibleContext() {
                return SnippetPanel.this.getAccessibleContext();
            }
        };
        this.title.setFocusable(true);
        this.title.addKeyListener(this);
        this.title.addMouseListener(this);
        this.title.addFocusListener(this);
        this.title.setToolTipText(content.getToolTipText());
        content.setToolTipText(null);
        this.add((Component)this.title, "North");
        this.add((Component)content, "Center");
        this.getAccessibleContext().setAccessibleName(snippetName);
    }

    private static void initColors() {
        boolean inverseColors;
        Color systemBackgroundColor = UIUtils.getProfilerResultsBackground();
        int backgroundRed = systemBackgroundColor.getRed();
        int backgroundGreen = systemBackgroundColor.getGreen();
        int backgroundBlue = systemBackgroundColor.getBlue();
        boolean bl = inverseColors = backgroundRed < 41 || backgroundGreen < 32 || backgroundBlue < 25;
        if (inverseColors) {
            lineColor = UIUtils.getSafeColor(backgroundRed + 41, backgroundGreen + 32, backgroundBlue + 8);
            backgroundColor = UIUtils.getSafeColor(backgroundRed + 7, backgroundGreen + 7, backgroundBlue + 7);
            focusedBackgroundColor = UIUtils.getSafeColor(backgroundRed + 25, backgroundGreen + 25, backgroundBlue + 25);
        } else {
            lineColor = UIUtils.getSafeColor(backgroundRed - 41, backgroundGreen - 32, backgroundBlue - 8);
            backgroundColor = UIUtils.getSafeColor(backgroundRed - 7, backgroundGreen - 7, backgroundBlue - 7);
            focusedBackgroundColor = UIUtils.getSafeColor(backgroundRed - 25, backgroundGreen - 25, backgroundBlue - 25);
        }
        textColor = UIManager.getColor("Button.foreground");
    }

    public void setCollapsed(boolean collapsed) {
        if (this.collapsed == collapsed) {
            return;
        }
        this.collapsed = collapsed;
        if (collapsed) {
            this.title.collapse();
        } else {
            this.title.expand();
        }
        this.content.setVisible(!collapsed);
        this.revalidate();
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setContent(JComponent content) {
        this.content = content;
    }

    public JComponent getContent() {
        return this.content;
    }

    public void setSnippetName(String snippetName) {
        this.snippetName = snippetName;
    }

    public String getSnippetName() {
        return this.snippetName;
    }

    public void focusGained(FocusEvent e) {
        this.title.repaint();
    }

    public void focusLost(FocusEvent e) {
        this.title.repaint();
    }

    public void keyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 32) {
            this.setCollapsed(!this.isCollapsed());
        }
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyTyped(KeyEvent evt) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        this.title.setCursor(Cursor.getPredefinedCursor(12));
        this.title.setRollOver(true);
    }

    public void mouseExited(MouseEvent e) {
        this.title.setCursor(Cursor.getPredefinedCursor(0));
        this.title.setRollOver(false);
    }

    public void mousePressed(MouseEvent e) {
        this.setCollapsed(!this.collapsed);
        this.requestFocus();
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void requestFocus() {
        if (this.title != null) {
            this.title.requestFocus();
        }
    }

    static {
        SnippetPanel.initColors();
    }

    private static class TitleUI
    extends ComponentUI {
        ImageIcon collapsedIcon = new ImageIcon(TitleUI.class.getResource("collapsedSnippet.png"));
        ImageIcon expandedIcon = new ImageIcon(TitleUI.class.getResource("expandedSnippet.png"));

        private TitleUI() {
        }

        public Dimension getPreferredSize(JComponent c) {
            FontMetrics fm = c.getGraphics().getFontMetrics(c.getFont());
            return new Dimension(20 + fm.getStringBounds((String)((Title)c).name, (Graphics)c.getGraphics()).getBounds().width, fm.getHeight() + 4);
        }

        public void installUI(JComponent c) {
            Font f = UIManager.getFont("Label.font");
            c.setFont(f.deriveFont(1));
        }

        public void paint(Graphics g, JComponent c) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Title title = (Title)c;
            Font font = c.getFont();
            if (title.collapsed) {
                g.setFont(font.deriveFont(0));
            } else {
                g.setFont(font);
            }
            g.setColor(lineColor);
            FontMetrics fm = g.getFontMetrics(font);
            g.drawLine(0, 0, c.getWidth(), 0);
            if (title.collapsed) {
                if (title.rollOver || title.isFocusOwner()) {
                    g.setColor(focusedBackgroundColor);
                } else {
                    g.setColor(backgroundColor);
                }
            }
            g.drawLine(0, 1 + fm.getHeight() + 2, c.getWidth(), 1 + fm.getHeight() + 2);
            if (title.rollOver || title.isFocusOwner()) {
                g.setColor(focusedBackgroundColor);
            } else {
                g.setColor(backgroundColor);
            }
            g.fillRect(0, 1, c.getWidth(), fm.getHeight() + 2);
            g.setColor(textColor);
            g.drawString(title.name, 20, fm.getHeight() - 1);
            int iconX = 5;
            int iconY = 5;
            ImageIcon icon = title.collapsed ? this.collapsedIcon : this.expandedIcon;
            icon.paintIcon(c, g, iconX, iconY);
        }
    }

    private static class Title
    extends JComponent
    implements Accessible {
        String name;
        private boolean collapsed;
        private boolean rollOver;

        private Title(String name) {
            this.name = name;
            this.setUI(new TitleUI());
        }

        public void setRollOver(boolean rollOver) {
            if (rollOver == this.rollOver) {
                return;
            }
            this.rollOver = rollOver;
            this.repaint();
        }

        public void collapse() {
            this.collapsed = true;
            this.repaint();
        }

        public void expand() {
            this.collapsed = false;
            this.repaint();
        }
    }

    public static class Padding
    extends JPanel {
        public Padding() {
            this.setBackground(UIUtils.getProfilerResultsBackground());
            this.setOpaque(true);
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(lineColor);
            g.drawLine(0, 0, this.getWidth(), 0);
        }
    }
}

