/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainer;
import org.netbeans.lib.profiler.results.cpu.FlatProfileProvider;
import org.netbeans.lib.profiler.ui.LiveResultsPanel;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.FilterComponent;
import org.netbeans.lib.profiler.ui.cpu.CPUResUserActionsHandler;
import org.netbeans.lib.profiler.ui.cpu.CPUSelectionHandler;
import org.netbeans.lib.profiler.ui.cpu.FlatProfilePanel;

public class LiveFlatProfileCollectorPanel
extends FlatProfilePanel
implements LiveResultsPanel {
    private JPopupMenu popup;
    private TargetAppRunner runner = null;
    private boolean firstTime = true;
    private boolean updateResultsInProgress = false;
    private boolean updateResultsPending = false;

    public LiveFlatProfileCollectorPanel(TargetAppRunner runner, CPUResUserActionsHandler actionsHandler, CPUSelectionHandler selectionHandler) {
        super(actionsHandler, selectionHandler);
        this.runner = runner;
        this.initComponents();
    }

    public void setDataToDisplay(FlatProfileContainer fpc) {
        this.threadId = -1;
        this.flatProfileContainer = fpc;
        this.collectingTwoTimeStamps = this.flatProfileContainer.isCollectingTwoTimeStamps();
        this.flatProfileContainer.filterOriginalData(FilterComponent.getFilterStrings(this.filterString), this.filterType, this.valueFilterValue);
        this.prepareResults(this.firstTime);
        this.firstTime = false;
        this.setResultsAvailable(this.hasData());
    }

    public BufferedImage getViewImage(boolean onlyVisibleArea) {
        if (onlyVisibleArea) {
            return UIUtils.createScreenshot(this.jScrollPane);
        }
        return UIUtils.createScreenshot(this.resTable);
    }

    public String getViewName() {
        return "cpu-live";
    }

    public boolean fitsVisibleArea() {
        return !this.jScrollPane.getVerticalScrollBar().isEnabled();
    }

    public void handleRemove() {
    }

    public void handleShutdown() {
        if (this.popup != null && this.popup.isVisible()) {
            this.updateResultsPending = false;
            this.popup.setVisible(false);
        }
    }

    public boolean hasData() {
        return this.flatProfileContainer != null && this.flatProfileContainer.getNRows() > 0;
    }

    public boolean hasView() {
        return this.resTable != null;
    }

    public void prepareResults() {
        super.prepareResults();
    }

    public boolean supports(int instrumentationType) {
        return instrumentationType == 2 || instrumentationType == 3;
    }

    public void updateLiveResults() {
        FlatProfileProvider flatProvider;
        if (this.popup != null && this.popup.isVisible()) {
            this.updateResultsPending = true;
            return;
        }
        if (this.updateResultsInProgress) {
            return;
        }
        this.updateResultsInProgress = true;
        String selectedRowString = null;
        if (this.resTable != null) {
            int selectedRowIndex = this.resTable.getSelectedRow();
            if (selectedRowIndex >= this.resTable.getRowCount()) {
                selectedRowIndex = -1;
                this.resTable.clearSelection();
            }
            if (selectedRowIndex != -1) {
                selectedRowString = this.resTable.getValueAt(selectedRowIndex, 0).toString();
            }
        }
        if ((flatProvider = this.runner.getProfilerClient().getFlatProfileProvider()) != null) {
            FlatProfileContainer fpc = flatProvider.createFlatProfile();
            int retryCounter = 2;
            boolean doRetry = false;
            do {
                doRetry = false;
                if (fpc != null) {
                    this.setDataToDisplay(fpc);
                    if (selectedRowString != null) {
                        this.resTable.selectRowByContents(selectedRowString, 0, false);
                    }
                } else {
                    doRetry = true;
                }
                if (!doRetry) continue;
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    doRetry = false;
                }
            } while (--retryCounter > 0 && doRetry);
        }
        this.updateResultsInProgress = false;
    }

    protected String[] getMethodClassNameAndSig(int methodId, int currentView) {
        ProfilingSessionStatus status = this.runner.getProfilingSessionStatus();
        String className = status.getInstrMethodClasses()[methodId];
        if (currentView == 0) {
            String methodName = status.getInstrMethodNames() != null ? status.getInstrMethodNames()[methodId] : null;
            String methodSig = status.getInstrMethodSignatures() != null ? status.getInstrMethodSignatures()[methodId] : null;
            return new String[]{className, methodName, methodSig};
        }
        return new String[]{className, null, null};
    }

    protected JPopupMenu createPopupMenu() {
        if (this.popup == null) {
            this.popup = super.createPopupMenu();
        }
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (LiveFlatProfileCollectorPanel.this.updateResultsPending) {
                            LiveFlatProfileCollectorPanel.this.updateLiveResults();
                            LiveFlatProfileCollectorPanel.this.updateResultsPending = false;
                        }
                    }
                });
            }
        });
        return this.popup;
    }

    protected void obtainResults() {
        if (!this.collectingTwoTimeStamps && this.sortBy == 3) {
            this.sortBy = 2;
        }
        this.flatProfileContainer.filterOriginalData(FilterComponent.getFilterStrings(this.filterString), this.filterType, this.valueFilterValue);
        this.flatProfileContainer.sortBy(this.sortBy, this.sortOrder);
    }

    protected void showReverseCallGraph(int threadId, int methodId, int currentView, int sortingColumn, boolean sortingOrder) {
        throw new IllegalStateException();
    }

    protected boolean supportsReverseCallGraph() {
        return false;
    }

    protected boolean supportsSubtreeCallGraph() {
        return false;
    }

    void setSelectedRowString(String rowString) {
        if (rowString != null) {
            this.resTable.selectRowByContents(rowString, 0, false);
        }
    }

    String getSelectedRowString() {
        String selectedRowString = null;
        if (this.resTable != null) {
            int selectedRowIndex = this.resTable.getSelectedRow();
            if (selectedRowIndex >= this.resTable.getRowCount()) {
                selectedRowIndex = -1;
                this.resTable.clearSelection();
            }
            if (selectedRowIndex != -1) {
                selectedRowString = this.resTable.getValueAt(selectedRowIndex, 0).toString();
            }
        }
        return selectedRowString;
    }

    private void initComponents() {
        this.setPreferredSize(new Dimension(800, 600));
    }
}

