/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.monitor;

import java.awt.Color;
import java.util.ResourceBundle;
import org.netbeans.lib.profiler.results.monitor.VMTelemetryDataManager;
import org.netbeans.lib.profiler.ui.monitor.VMTelemetryXYChartModel;

public class MemoryXYChartModel
extends VMTelemetryXYChartModel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.monitor.Bundle");
    private static final String HEAP_SIZE_STRING = messages.getString("MemoryXYChartModel_HeapSizeString");
    private static final String HEAP_USED_STRING = messages.getString("MemoryXYChartModel_HeapUsedString");
    private static final Color MAX_HEAP_COLOR = new Color(220, 220, 220);

    public MemoryXYChartModel(VMTelemetryDataManager vmTelemetryDataManager) {
        super(vmTelemetryDataManager);
        this.setupModel(new String[]{HEAP_SIZE_STRING, HEAP_USED_STRING}, new Color[]{new Color(255, 127, 127), new Color(127, 63, 191)});
    }

    public Color getLimitYColor() {
        return MAX_HEAP_COLOR;
    }

    public long getLimitYValue() {
        return this.vmTelemetryDataManager.maxHeapSize;
    }

    public long getMaxDisplayYValue(int seriesIndex) {
        return Math.max(this.getMaxYValue(0), this.getMaxYValue(1));
    }

    public long[] getYValues(int seriesIndex) {
        switch (seriesIndex) {
            case 0: {
                return this.vmTelemetryDataManager.totalMemory;
            }
            case 1: {
                return this.vmTelemetryDataManager.usedMemory;
            }
        }
        return null;
    }
}

