/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.modules.startup;

import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.openide.LifecycleManager;
import org.openide.modules.ModuleInstall;

public class VisualVMStartup
extends ModuleInstall {
    private static final Logger LOGGER = Logger.getLogger(VisualVMStartup.class.getName());

    public void validate() {
        if (!VisualVMStartup.isCurrentJavaSupported()) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            JOptionPane.showMessageDialog(null, "You are running VisualVM using an unsupported  \nversion of Java (" + System.getProperty("java.version", "unknown version") + "),\n" + "from (" + System.getProperty("java.home", "unknown version") + "), startup terminated.  \n\n" + "Please refer to https://visualvm.dev.java.net  \n" + "for information about requirements and setup.  \n\n", "Error Starting VisualVM", 0);
            LifecycleManager.getDefault().exit();
        }
    }

    private static boolean isCurrentJavaSupported() {
        boolean isCurrentJavaSupported;
        String javaVersion = System.getProperty("java.version");
        Class<?> desktopClass = null;
        try {
            desktopClass = Class.forName("java.awt.Desktop");
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        Class<?> vmClass = null;
        try {
            vmClass = Class.forName("com.sun.tools.attach.VirtualMachine");
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        boolean bl = isCurrentJavaSupported = (javaVersion.startsWith("1.6") || javaVersion.startsWith("1.7")) && desktopClass != null && vmClass != null;
        if (!isCurrentJavaSupported) {
            LOGGER.warning("Error starting VisualVM, unsupported Java version: " + VisualVMStartup.getJavaInfo());
        }
        return isCurrentJavaSupported;
    }

    private static String getJavaInfo() {
        Properties systemProperties = System.getProperties();
        String javaVersion = systemProperties.getProperty("java.version", "unknown version");
        String vmName = systemProperties.getProperty("java.vm.name", "unknown name");
        String vmVerison = systemProperties.getProperty("java.vm.version", "");
        String vmInfo = systemProperties.getProperty("java.vm.info", "");
        String vendorInfo = systemProperties.getProperty("java.vendor", "unknown vendor");
        return javaVersion + "; " + vmName + " (" + vmVerison + ", " + vmInfo + "); " + vendorInfo;
    }
}

