/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import org.netbeans.swing.tabcontrol.SlidingButtonUI;
import org.netbeans.swing.tabcontrol.TabData;

public final class SlidingButton
extends JToggleButton {
    public static final String UI_CLASS_ID = "SlidingButtonUI";
    private int orientation;
    private TabData data;
    private Timer blinkTimer = null;
    private boolean blinkState = false;

    public SlidingButton(TabData tabData, int n) {
        super(tabData.getText(), tabData.getIcon(), false);
        Object object;
        Component component = tabData.getComponent();
        if (component instanceof JComponent && (object = ((JComponent)component).getClientProperty("SlidingName")) instanceof String) {
            this.setText((String)object);
        }
        this.orientation = n;
        this.data = tabData;
        this.setFocusable(false);
        this.setRolloverEnabled(true);
        this.setIconTextGap(3);
        this.setVerticalAlignment(0);
        this.setHorizontalAlignment(0);
        this.setMargin(new Insets(0, 3, 0, 3));
        this.setBorderPainted(false);
    }

    public void addNotify() {
        super.addNotify();
    }

    public void removeNotify() {
        super.removeNotify();
        this.setBlinking(false);
    }

    public String getToolTipText() {
        return this.data.getTooltip();
    }

    public void updateUI() {
        ButtonUI buttonUI = (ButtonUI)UIManager.getUI(this);
        if (buttonUI == null) {
            buttonUI = (ButtonUI)SlidingButtonUI.createUI(this);
        }
        this.setUI(buttonUI);
    }

    public String getUIClassID() {
        return UI_CLASS_ID;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public boolean isBlinking() {
        return this.blinkState;
    }

    public void setBlinking(boolean bl) {
        if (!bl && this.blinkTimer != null) {
            this.blinkTimer.stop();
            this.blinkTimer = null;
            boolean bl2 = this.blinkState;
            this.blinkState = false;
            if (bl2) {
                this.repaint();
            }
        } else if (bl && this.blinkTimer == null) {
            this.blinkTimer = new Timer(700, new BlinkListener());
            this.blinkState = true;
            this.blinkTimer.start();
            this.repaint();
        }
    }

    public final boolean isBlinkState() {
        return this.blinkState;
    }

    public final Color getBackground() {
        return this.isBlinkState() ? new Color(252, 250, 244) : super.getBackground();
    }

    public TabData getData() {
        return this.data;
    }

    private class BlinkListener
    implements ActionListener {
        private BlinkListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SlidingButton.this.blinkState = !SlidingButton.this.blinkState;
            SlidingButton.this.repaint();
        }
    }
}

