/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.io.File;
import javax.swing.JPanel;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.HeapSummary;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.heapwalk.AbstractTopLevelController;
import org.netbeans.modules.profiler.heapwalk.AnalysisController;
import org.netbeans.modules.profiler.heapwalk.ClassesController;
import org.netbeans.modules.profiler.heapwalk.HeapWalker;
import org.netbeans.modules.profiler.heapwalk.InstancesController;
import org.netbeans.modules.profiler.heapwalk.NavigationHistoryManager;
import org.netbeans.modules.profiler.heapwalk.SummaryController;
import org.netbeans.modules.profiler.heapwalk.ui.HeapFragmentWalkerUI;

public class HeapFragmentWalker {
    private AnalysisController analysisController;
    private ClassesController classesController;
    private Heap heapFragment;
    private HeapFragmentWalkerUI walkerUI;
    private HeapWalker heapWalker;
    private InstancesController instancesController;
    private NavigationHistoryManager navigationHistoryManager;
    private SummaryController summaryController;
    private int totalLiveBytes;
    private int totalLiveInstances;

    public HeapFragmentWalker(Heap heapFragment, HeapWalker heapWalker) {
        this.heapFragment = heapFragment;
        this.heapWalker = heapWalker;
        HeapSummary summary = heapFragment.getSummary();
        this.totalLiveBytes = summary.getTotalLiveBytes();
        this.totalLiveInstances = summary.getTotalLiveInstances();
        this.summaryController = new SummaryController(this);
        this.classesController = new ClassesController(this);
        this.instancesController = new InstancesController(this);
        this.analysisController = new AnalysisController(this);
        this.navigationHistoryManager = new NavigationHistoryManager(this);
    }

    public AbstractTopLevelController getActiveController() {
        HeapFragmentWalkerUI ui = (HeapFragmentWalkerUI)this.getPanel();
        if (ui == null) {
            return null;
        }
        if (ui.isSummaryViewActive()) {
            return this.summaryController;
        }
        if (ui.isClassesViewActive()) {
            return this.classesController;
        }
        if (ui.isInstancesViewActive()) {
            return this.instancesController;
        }
        if (ui.isAnalysisViewActive()) {
            return this.analysisController;
        }
        return null;
    }

    public AnalysisController getAnalysisController() {
        return this.analysisController;
    }

    public ClassesController getClassesController() {
        return this.classesController;
    }

    public File getHeapDumpFile() {
        return this.heapWalker.getHeapDumpFile();
    }

    public Heap getHeapFragment() {
        return this.heapFragment;
    }

    public InstancesController getInstancesController() {
        return this.instancesController;
    }

    public boolean isNavigationBackAvailable() {
        return this.navigationHistoryManager.isNavigationBackAvailable();
    }

    public boolean isNavigationForwardAvailable() {
        return this.navigationHistoryManager.isNavigationForwardAvailable();
    }

    public JPanel getPanel() {
        if (this.walkerUI == null) {
            this.walkerUI = new HeapFragmentWalkerUI(this);
        }
        return this.walkerUI;
    }

    public SummaryController getSummaryController() {
        return this.summaryController;
    }

    public int getTotalLiveBytes() {
        return this.totalLiveBytes;
    }

    public int getTotalLiveInstances() {
        return this.totalLiveInstances;
    }

    public void createNavigationHistoryPoint() {
        HeapFragmentWalkerUI ui = (HeapFragmentWalkerUI)this.getPanel();
        if (ui == null) {
            return;
        }
        this.navigationHistoryManager.createNavigationHistoryPoint();
        ui.updateNavigationActions();
    }

    public void navigateBack() {
        HeapFragmentWalkerUI ui = (HeapFragmentWalkerUI)this.getPanel();
        if (ui == null) {
            return;
        }
        this.navigationHistoryManager.navigateBack();
        ui.updateNavigationActions();
    }

    public void navigateForward() {
        HeapFragmentWalkerUI ui = (HeapFragmentWalkerUI)this.getPanel();
        if (ui == null) {
            return;
        }
        this.navigationHistoryManager.navigateForward();
        ui.updateNavigationActions();
    }

    public void showInstancesForClass(JavaClass jClass) {
        this.switchToInstancesView();
        this.instancesController.setClass(jClass);
    }

    public void switchToAnalysisView() {
        ((HeapFragmentWalkerUI)this.getPanel()).showAnalysisView();
    }

    public void switchToClassesView() {
        ((HeapFragmentWalkerUI)this.getPanel()).showClassesView();
    }

    public void switchToHistoryAnalysisView() {
        ((HeapFragmentWalkerUI)this.getPanel()).showHistoryAnalysisView();
    }

    public void switchToHistoryClassesView() {
        ((HeapFragmentWalkerUI)this.getPanel()).showHistoryClassesView();
    }

    public void switchToHistoryInstancesView() {
        ((HeapFragmentWalkerUI)this.getPanel()).showHistoryInstancesView();
    }

    public void switchToHistorySummaryView() {
        ((HeapFragmentWalkerUI)this.getPanel()).showHistorySummaryView();
    }

    public void switchToInstancesView() {
        ((HeapFragmentWalkerUI)this.getPanel()).showInstancesView();
    }

    public void switchToSummaryView() {
        ((HeapFragmentWalkerUI)this.getPanel()).showSummaryView();
    }

    NavigationHistoryManager.NavigationHistoryCapable getNavigationHistorySource() {
        AbstractTopLevelController activeController = this.getActiveController();
        if (activeController instanceof NavigationHistoryManager.NavigationHistoryCapable) {
            return (NavigationHistoryManager.NavigationHistoryCapable)((Object)activeController);
        }
        return null;
    }
}

