/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.model;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.modules.profiler.heapwalk.model.AbstractHeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerFieldNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;

public class PrimitiveFieldNode
extends AbstractHeapWalkerNode
implements HeapWalkerFieldNode {
    private FieldValue fieldValue;

    public PrimitiveFieldNode(FieldValue fieldValue, HeapWalkerNode parent) {
        this(fieldValue, parent, parent == null ? 1 : parent.getMode());
    }

    public PrimitiveFieldNode(FieldValue fieldValue, HeapWalkerNode parent, int mode) {
        super(parent, mode);
        this.fieldValue = fieldValue;
    }

    public FieldValue getFieldValue() {
        return this.fieldValue;
    }

    public boolean isLeaf() {
        return true;
    }

    public boolean isStatic() {
        return this.fieldValue.getField().isStatic();
    }

    protected Icon computeIcon() {
        ImageIcon icon = BrowserUtils.ICON_PRIMITIVE;
        if (this.isStatic()) {
            icon = BrowserUtils.createStaticIcon(icon);
        }
        return icon;
    }

    protected String computeName() {
        return this.fieldValue.getField().getName();
    }

    protected String computeType() {
        return this.fieldValue.getField().getType().getName();
    }

    protected String computeValue() {
        return this.fieldValue.getValue();
    }

    public static class ArrayItem
    extends PrimitiveFieldNode
    implements org.netbeans.modules.profiler.heapwalk.model.ArrayItem {
        private String type;
        private String value;
        private int itemIndex;

        public ArrayItem(int itemIndex, String type, String value, HeapWalkerNode parent) {
            this(itemIndex, type, value, parent, parent == null ? 1 : parent.getMode());
        }

        public ArrayItem(int itemIndex, String type, String value, HeapWalkerNode parent, int mode) {
            super(null, parent, mode);
            this.itemIndex = itemIndex;
            this.type = type;
            this.value = value;
        }

        public int getItemIndex() {
            return this.itemIndex;
        }

        public boolean isStatic() {
            return false;
        }

        protected String computeName() {
            return "[" + this.itemIndex + "]";
        }

        protected String computeType() {
            return this.type;
        }

        protected String computeValue() {
            return this.value;
        }
    }
}

