/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;

public class HyperlinkTextArea
extends HTMLTextArea {
    private String originalText;
    private boolean selected = false;

    public HyperlinkTextArea() {
        this.setFont(UIManager.getFont("Label.font"));
        this.setForeground(Color.DARK_GRAY);
        this.setOpaque(false);
        this.setFocusable(true);
        this.setHighlighter(null);
        this.setShowPopup(false);
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                if (HyperlinkTextArea.this.isSelected()) {
                    return;
                }
                HyperlinkTextArea.this.setCursor(Cursor.getPredefinedCursor(12));
                if (HyperlinkTextArea.this.isFocusOwner()) {
                    return;
                }
                HyperlinkTextArea.this.decorateHighlight();
            }

            public void mouseExited(MouseEvent e) {
                if (HyperlinkTextArea.this.isSelected()) {
                    return;
                }
                HyperlinkTextArea.this.setCursor(Cursor.getDefaultCursor());
                if (HyperlinkTextArea.this.isFocusOwner()) {
                    return;
                }
                HyperlinkTextArea.this.decorateNormal();
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (!HyperlinkTextArea.this.isSelected()) {
                    HyperlinkTextArea.this.decorateHighlight();
                }
            }

            public void focusLost(FocusEvent e) {
                if (!HyperlinkTextArea.this.isSelected()) {
                    HyperlinkTextArea.this.decorateNormal();
                }
            }
        });
    }

    public HyperlinkTextArea(String text) {
        this();
        this.setText(text);
    }

    public void updateAppearance() {
        if (this.isSelected() || this.isFocusOwner()) {
            this.decorateHighlight();
        } else {
            this.decorateNormal();
        }
    }

    public void setForeground(Color color) {
        String originalTextBkp = this.originalText;
        super.setForeground(color);
        this.originalText = originalTextBkp;
        super.setText(this.originalText);
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        if (selected) {
            this.decorateHighlight();
        } else {
            this.decorateNormal();
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setText(String value) {
        this.originalText = value;
        super.setText(value);
    }

    public void scrollRectToVisible(Rectangle aRect) {
    }

    protected Color getHighlightColor() {
        return Color.BLACK;
    }

    protected String getHighlightText(String originalText) {
        return "<u>" + originalText + "</u>";
    }

    protected Color getNormalColor() {
        return Color.DARK_GRAY;
    }

    protected String getNormalText(String originalText) {
        return originalText;
    }

    private void decorateHighlight() {
        this.setForeground(this.getHighlightColor());
        super.setText(this.getHighlightText(this.originalText));
    }

    private void decorateNormal() {
        this.setForeground(this.getNormalColor());
        super.setText(this.getNormalText(this.originalText));
    }
}

