/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.wizards.providers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.netbeans.modules.profiler.ui.wizards.providers.SettingsPersistor;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public abstract class IDESettingsPersistor
implements SettingsPersistor {
    public void loadSettings() {
        Properties settings = this.loadProperties();
        this.parsePersistableSettings(settings);
    }

    public void storeSettings() {
        Properties settings = this.loadProperties();
        Properties newSettings = this.preparePersistableSettings();
        this.mergeProperties(newSettings, settings);
        this.storeProperties(settings);
    }

    protected abstract String getSettingsFileName();

    protected abstract void parsePersistableSettings(Properties var1);

    protected abstract Properties preparePersistableSettings();

    private File getSettingsFile() {
        FileObject settingsFO = null;
        try {
            settingsFO = IDEUtils.getSettingsFolder(true);
        }
        catch (IOException e) {
            // empty catch block
        }
        File settingsDir = settingsFO == null ? null : FileUtil.toFile((FileObject)settingsFO);
        return new File(settingsDir, this.getSettingsFileName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties() {
        FileInputStream fis = null;
        Properties settings = new Properties();
        try {
            fis = new FileInputStream(this.getSettingsFile());
            settings.load(fis);
        }
        catch (IOException e) {
        }
        finally {
            try {
                fis.close();
            }
            catch (Exception e) {}
        }
        return settings;
    }

    private void mergeProperties(Properties sourceProperties, Properties destProperties) {
        Set<Object> propKeySet = sourceProperties.keySet();
        for (String string : propKeySet) {
            String value = sourceProperties.getProperty(string);
            destProperties.setProperty(string, sourceProperties.getProperty(string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeProperties(Properties properties) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.getSettingsFile());
            properties.store(fos, "");
        }
        catch (IOException e) {
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException e) {}
        }
    }
}

