/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.netbeans.lib.profiler.server.ProfilerRuntimeMemory;
import org.netbeans.lib.profiler.server.ThreadInfo;
import org.netbeans.lib.profiler.server.system.GC;
import org.netbeans.lib.profiler.server.system.Threads;

public class ProfilerRuntimeObjLiveness
extends ProfilerRuntimeMemory {
    protected static ReferenceQueue rq;
    protected static WeakRefSet objSet;
    protected static ReferenceManagerThread rmt;
    protected static boolean runGCOnGetResults;
    protected static boolean objLivenessProfilingDisabled;

    public static void enableProfiling(boolean v) {
        if (v) {
            ProfilerRuntimeObjLiveness.createNewDataStructures();
            GC.resetGCEpochCounter();
            ProfilerRuntimeMemory.enableProfiling(true);
            objLivenessProfilingDisabled = false;
        } else {
            objLivenessProfilingDisabled = true;
            ProfilerRuntimeMemory.enableProfiling(false);
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ProfilerRuntimeObjLiveness.clearDataStructures();
        }
    }

    public static void resetProfilerCollectors() {
        if (rmt != null) {
            GC.runGC();
            rmt.terminate();
        }
        ProfilerRuntimeObjLiveness.createNewDataStructures();
    }

    public static void signalObjGC(ProfilerRuntimeObjLivenessWeakRef wr) {
        long objectId = wr.objId;
        objSet.remove(wr);
        ProfilerRuntimeObjLiveness.writeObjGCEvent(objectId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void traceObjAlloc(Object object, char classId) {
        if (objLivenessProfilingDisabled) {
            return;
        }
        if (ThreadInfo.profilingSuspended() || ThreadInfo.isCurrentThreadProfilerServerThread()) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (!ti.isInitialized()) {
            ti.initialize(true);
        }
        if (ti.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++ti.inProfilingRuntimeMethod;
        classId = classId;
        int objCount = 0;
        int[] nArray = allocatedInstancesCount;
        synchronized (allocatedInstancesCount) {
            char c = classId;
            int n = allocatedInstancesCount[c] + 1;
            allocatedInstancesCount[c] = n;
            objCount = n;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (allocatedInstThreshold[classId] <= 0) {
                char epoch = (char)GC.getCurrentGCEpoch();
                long objectId = (long)classId << 48 | (long)epoch << 32 | (long)objCount;
                ProfilerRuntimeObjLivenessWeakRef wr = new ProfilerRuntimeObjLivenessWeakRef(object, rq, objectId);
                objSet.put(wr);
                long objSize = ProfilerRuntimeObjLiveness.getCachedObjectSize(classId, object);
                ProfilerRuntimeObjLiveness.getAndSendCurrentStackTrace(classId, epoch, objCount, objSize);
                ProfilerRuntimeObjLiveness.allocatedInstThreshold[classId] = ProfilerRuntimeObjLiveness.nextRandomizedInterval();
            }
            char c2 = classId;
            allocatedInstThreshold[c2] = (short)(allocatedInstThreshold[c2] - 1);
            --ti.inProfilingRuntimeMethod;
            return;
        }
    }

    protected static void setRunGCOnGetResults(boolean v) {
        runGCOnGetResults = v;
    }

    protected static boolean getRunGCOnGetResults() {
        return runGCOnGetResults;
    }

    protected static void clearDataStructures() {
        ProfilerRuntimeMemory.clearDataStructures();
        if (rmt != null) {
            GC.runGC();
            rmt.terminate();
        }
        rq = null;
        objSet = null;
        rmt = null;
    }

    protected static void createNewDataStructures() {
        ProfilerRuntimeMemory.createNewDataStructures();
        rq = new ReferenceQueue();
        objSet = new WeakRefSet();
        rmt = new ReferenceManagerThread();
        Threads.recordAdditionalProfilerOwnThread(rmt);
        rmt.start();
    }

    static {
        objLivenessProfilingDisabled = true;
    }

    static class WeakRefSet {
        private WeakReference[] keys;
        private int capacity = 1003;
        private int nObjects;
        private int threshold;

        WeakRefSet() {
            this.setThreshold();
            this.keys = new WeakReference[this.capacity];
        }

        public synchronized void put(WeakReference key) {
            if (this.nObjects > this.threshold) {
                this.rehash();
            }
            int pos = key.hashCode() % this.capacity;
            while (this.keys[pos] != null) {
                pos = (pos + 1) % this.capacity;
            }
            this.keys[pos] = key;
            ++this.nObjects;
        }

        public synchronized void remove(WeakReference key) {
            int pos = key.hashCode() % this.capacity;
            while (this.keys[pos] != key) {
                pos = (pos + 1) % this.capacity;
            }
            this.keys[pos] = null;
            --this.nObjects;
        }

        private void setThreshold() {
            this.threshold = this.capacity * 3 / 4;
        }

        private void rehash() {
            WeakReference[] oldKeys = this.keys;
            int oldCapacity = this.capacity;
            this.capacity = this.capacity * 2 + 1;
            this.keys = new WeakReference[this.capacity];
            for (int i = 0; i < oldCapacity; ++i) {
                if (oldKeys[i] == null) continue;
                int pos = oldKeys[i].hashCode() % this.capacity;
                while (this.keys[pos] != null) {
                    pos = (pos + 1) % this.capacity;
                }
                this.keys[pos] = oldKeys[i];
            }
            this.setThreshold();
        }
    }

    static class ReferenceManagerThread
    extends Thread {
        private boolean terminated;

        ReferenceManagerThread() {
            ThreadInfo.addProfilerServerThread(this);
            this.setName("*** Profiler Agent Special Execution Thread 3");
        }

        public void run() {
            while (!this.terminated) {
                try {
                    ProfilerRuntimeObjLivenessWeakRef wr = (ProfilerRuntimeObjLivenessWeakRef)rq.remove(200L);
                    if (wr == null) continue;
                    ProfilerRuntimeObjLiveness.signalObjGC(wr);
                }
                catch (InterruptedException interruptedException) {}
            }
            ThreadInfo.removeProfilerServerThread(this);
        }

        public void terminate() {
            this.terminated = true;
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static class ProfilerRuntimeObjLivenessWeakRef
    extends WeakReference {
        long objId;

        ProfilerRuntimeObjLivenessWeakRef(Object obj, ReferenceQueue rq, long objId) {
            super(obj, rq);
            this.objId = objId;
        }
    }
}

