/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu.marking;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.results.cpu.marking.Mark;
import org.netbeans.lib.profiler.results.cpu.marking.MarkMapper;
import org.netbeans.lib.profiler.results.cpu.marking.MarkMapping;

public class MarkingEngine {
    private static MarkingEngine instance;
    private final Object mapperGuard = new Object();
    private final Object markGuard = new Object();
    private Mark defaultMark = null;
    private MarkMapper mapper = null;
    private Set observers = new HashSet();
    private String[] labels;
    private Mark[] markBackMap;
    private MarkMapping[] marks;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MarkingEngine() {
        Object object = this.mapperGuard;
        synchronized (object) {
            this.mapper = new MarkMapper();
            this.addStateObserver(this.mapper);
        }
    }

    public static synchronized MarkingEngine getDefault() {
        if (instance == null) {
            instance = new MarkingEngine();
        }
        return instance;
    }

    public static synchronized void configure(Mark rootMark, MarkMapping[] marks) {
        MarkingEngine.getDefault().defaultMark = rootMark;
        MarkingEngine.getDefault().setMarks(marks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLabelForId(char markId) {
        Object object = this.markGuard;
        synchronized (object) {
            if (this.marks == null) {
                return null;
            }
            if (markId > '\u0000' && markId <= this.labels.length) {
                return this.labels[markId - '\u0001'];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mark getMarkForId(char markId) {
        Object object = this.markGuard;
        synchronized (object) {
            if (this.marks == null) {
                return null;
            }
            if (markId > '\u0000' && markId <= this.labels.length) {
                return this.markBackMap[markId - '\u0001'];
            }
            return this.defaultMark != null ? this.defaultMark : Mark.DEFAULT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMarkId(Mark mark) {
        Object object = this.markGuard;
        synchronized (object) {
            if (mark.isDefault) {
                return 0;
            }
            for (int i = 0; i < this.labels.length; ++i) {
                if (!this.labels[i].equals(mark.label)) continue;
                return (char)(i + 1);
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MarkMapper getMarker() {
        Object object = this.mapperGuard;
        synchronized (object) {
            return this.mapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientUtils.SourceCodeSelection[] getMarkerMethods() {
        Object object = this.markGuard;
        synchronized (object) {
            if (this.marks == null) {
                return new ClientUtils.SourceCodeSelection[0];
            }
            ClientUtils.SourceCodeSelection[] methods = new ClientUtils.SourceCodeSelection[this.marks.length];
            for (int i = 0; i < this.marks.length; ++i) {
                methods[i] = this.marks[i].markMask;
            }
            return methods;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNMarks() {
        Object object = this.markGuard;
        synchronized (object) {
            return this.labels != null ? this.labels.length : 0;
        }
    }

    public void addStateObserver(StateObserver observer) {
        this.observers.add(observer);
    }

    public void removeStateObserver(StateObserver observer) {
        this.observers.remove(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Mark mark(int methodId, ProfilingSessionStatus status) {
        ClientUtils.SourceCodeSelection method = null;
        Object object = this.markGuard;
        synchronized (object) {
            if (this.marks == null) {
                return Mark.DEFAULT;
            }
            status.beginTrans(false);
            try {
                method = new ClientUtils.SourceCodeSelection(status.getInstrMethodClasses()[methodId], status.getInstrMethodNames()[methodId], status.getInstrMethodSignatures()[methodId]);
            }
            finally {
                status.endTrans();
            }
            String methodSig = method.toFlattened();
            for (int i = 0; i < this.marks.length; ++i) {
                if (!methodSig.startsWith(this.marks[i].markSig)) continue;
                return this.marks[i].mark;
            }
            return Mark.DEFAULT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMarks(MarkMapping[] marks) {
        boolean stateChange = false;
        Object object = this.markGuard;
        synchronized (object) {
            stateChange = (this.marks != null || marks != null) && (this.marks == null && marks != null || this.marks != null && marks == null || !this.marks.equals(marks));
            this.marks = marks;
            if (marks != null) {
                int i;
                LinkedHashSet labelSet = new LinkedHashSet();
                for (i = 0; i < marks.length; ++i) {
                    labelSet.addAll(marks[i].mark.getLabels());
                }
                this.labels = new String[labelSet.size()];
                this.labels = labelSet.toArray(this.labels);
                this.markBackMap = new Mark[this.labels.length];
                block4: for (i = 0; i < this.labels.length; ++i) {
                    for (int j = 0; j < marks.length; ++j) {
                        if (!marks[j].mark.getLabel().equals(this.labels[i])) continue;
                        this.markBackMap[i] = marks[j].mark;
                        continue block4;
                    }
                }
            }
        }
        if (stateChange) {
            this.fireStateChanged();
        }
    }

    private void fireStateChanged() {
        Iterator iter = this.observers.iterator();
        while (iter.hasNext()) {
            ((StateObserver)iter.next()).stateChanged(this);
        }
    }

    public static interface StateObserver {
        public void stateChanged(MarkingEngine var1);
    }
}

