/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options;

import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.netbeans.modules.options.OptionsDisplayerImpl;
import org.netbeans.spi.options.OptionsCategory;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CategoryModel
implements LookupListener {
    private static Reference<CategoryModel> INSTANCE = new WeakReference<CategoryModel>(new CategoryModel());
    private final RequestProcessor RP = new RequestProcessor();
    private static String currentCategoryID = null;
    private String highlitedCategoryID = null;
    private boolean categoriesValid = true;
    private final Map<String, Category> id2Category = Collections.synchronizedMap(new LinkedHashMap());
    private MasterLookup masterLookup;
    private final RequestProcessor.Task masterLookupTask = this.RP.create(new Runnable(){

        public void run() {
            String[] stringArray = CategoryModel.this.getCategoryIDs();
            ArrayList<Lookup> arrayList = new ArrayList<Lookup>();
            for (int i = 0; i < stringArray.length; ++i) {
                Category category = CategoryModel.this.getCategory(stringArray[i]);
                Lookup lookup = category.getLookup();
                assert (lookup != null);
                if (lookup == Lookup.EMPTY) continue;
                arrayList.add(lookup);
            }
            CategoryModel.this.getMasterLookup().setLookups(arrayList);
        }
    }, true);
    private final RequestProcessor.Task categoryTask = this.RP.create(new Runnable(){

        public void run() {
            Map map = CategoryModel.this.loadOptionsCategories();
            LinkedHashMap<String, Category> linkedHashMap = new LinkedHashMap<String, Category>();
            for (Map.Entry entry : map.entrySet()) {
                OptionsCategory optionsCategory = (OptionsCategory)entry.getValue();
                String string = (String)entry.getKey();
                Category category = new Category(string, optionsCategory);
                linkedHashMap.put(category.getID(), category);
            }
            CategoryModel.this.id2Category.clear();
            CategoryModel.this.id2Category.putAll(linkedHashMap);
            CategoryModel.this.masterLookupTask.schedule(0);
        }
    }, true);

    private CategoryModel() {
        this.categoryTask.schedule(0);
    }

    public static CategoryModel getInstance() {
        CategoryModel categoryModel = INSTANCE.get();
        if (categoryModel == null) {
            categoryModel = new CategoryModel();
            INSTANCE = new WeakReference<CategoryModel>(categoryModel);
        }
        return categoryModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean needsReinit() {
        Class<CategoryModel> clazz = CategoryModel.class;
        synchronized (CategoryModel.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return !this.categoriesValid;
        }
    }

    boolean isInitialized() {
        return this.categoryTask.isFinished();
    }

    boolean isLookupInitialized() {
        return this.masterLookupTask.isFinished();
    }

    void waitForInitialization() {
        this.categoryTask.waitFinished();
    }

    public String getCurrentCategoryID() {
        return this.verifyCategoryID(currentCategoryID);
    }

    public void setCurrentCategoryID(String string) {
        currentCategoryID = this.verifyCategoryID(string);
    }

    String getHighlitedCategoryID() {
        return this.verifyCategoryID(this.highlitedCategoryID);
    }

    private String verifyCategoryID(String string) {
        String[] stringArray;
        String string2;
        String string3 = string2 = this.findCurrentCategoryID(string) != -1 ? string : null;
        if (string2 == null && (stringArray = this.getCategoryIDs()).length > 0) {
            string2 = string = stringArray[0];
        }
        return string2;
    }

    private int findCurrentCategoryID(String string) {
        return string == null ? -1 : Arrays.asList(this.getCategoryIDs()).indexOf(string);
    }

    public String[] getCategoryIDs() {
        this.categoryTask.waitFinished();
        Set<String> set = this.id2Category.keySet();
        return set.toArray(new String[set.size()]);
    }

    Category getCurrent() {
        String string = this.getCurrentCategoryID();
        return string == null ? null : this.getCategory(string);
    }

    void setCurrent(Category category) {
        category.setCurrent();
    }

    void setHighlited(Category category, boolean bl) {
        category.setHighlited(bl);
    }

    HelpCtx getHelpCtx() {
        Category category = this.getCurrent();
        return category == null ? null : category.getHelpCtx();
    }

    void update(PropertyChangeListener propertyChangeListener, boolean bl) {
        String[] stringArray = this.getCategoryIDs();
        for (int i = 0; i < stringArray.length; ++i) {
            Category category = this.getCategory(stringArray[i]);
            category.update(propertyChangeListener, bl);
        }
    }

    void save() {
        String[] stringArray = this.getCategoryIDs();
        for (int i = 0; i < stringArray.length; ++i) {
            Category category = this.getCategory(stringArray[i]);
            category.applyChanges();
        }
    }

    void cancel() {
        String[] stringArray = this.getCategoryIDs();
        for (int i = 0; i < stringArray.length; ++i) {
            Category category = this.getCategory(stringArray[i]);
            category.cancel();
        }
    }

    boolean dataValid() {
        boolean bl = true;
        String[] stringArray = this.getCategoryIDs();
        for (int i = 0; bl && i < stringArray.length; ++i) {
            Category category = this.getCategory(stringArray[i]);
            bl = category.isValid();
        }
        return bl;
    }

    boolean isChanged() {
        boolean bl = false;
        String[] stringArray = this.getCategoryIDs();
        for (int i = 0; !bl && i < stringArray.length; ++i) {
            Category category = this.getCategory(stringArray[i]);
            bl = category.isChanged();
        }
        return bl;
    }

    Category getNextCategory() {
        int n = this.findCurrentCategoryID(this.getCurrentCategoryID());
        String[] stringArray = this.getCategoryIDs();
        String string = "";
        string = n >= 0 && n < stringArray.length && stringArray.length > 0 ? (n + 1 < stringArray.length ? stringArray[n + 1] : stringArray[0]) : null;
        return string != null ? this.getCategory(string) : null;
    }

    Category getPreviousCategory() {
        int n = this.findCurrentCategoryID(this.getCurrentCategoryID());
        String[] stringArray = this.getCategoryIDs();
        String string = "";
        string = n >= 0 && n < stringArray.length && stringArray.length > 0 ? (n - 1 >= 0 ? stringArray[n - 1] : stringArray[stringArray.length - 1]) : null;
        return string != null ? this.getCategory(string) : null;
    }

    Category getCategory(String string) {
        this.categoryTask.waitFinished();
        return this.id2Category.get(string);
    }

    private MasterLookup getMasterLookup() {
        if (this.masterLookup == null) {
            this.masterLookup = new MasterLookup();
        }
        return this.masterLookup;
    }

    private Map<String, OptionsCategory> loadOptionsCategories() {
        Lookup lookup = Lookups.forPath((String)"OptionsDialog");
        Lookup.Result result = lookup.lookup(new Lookup.Template(OptionsCategory.class));
        result.addLookupListener((LookupListener)this);
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        for (Lookup.Item item : result.allItems()) {
            linkedHashMap.put(item.getId().substring("OptionsDialog".length() + 1), item.getInstance());
        }
        return Collections.unmodifiableMap(linkedHashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resultChanged(LookupEvent lookupEvent) {
        Class<CategoryModel> clazz = CategoryModel.class;
        synchronized (CategoryModel.class) {
            this.categoriesValid = false;
            OptionsDisplayerImpl.lookupListener.resultChanged(lookupEvent);
            INSTANCE = new WeakReference<CategoryModel>(new CategoryModel());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MasterLookup
    extends ProxyLookup {
        private MasterLookup() {
        }

        private void setLookups(List<Lookup> list) {
            this.setLookups(list.toArray(new Lookup[list.size()]));
        }

        protected void beforeLookup(Lookup.Template template) {
            super.beforeLookup(template);
            CategoryModel.this.masterLookupTask.waitFinished();
        }
    }

    final class Category {
        private OptionsCategory category;
        private OptionsPanelController controller;
        private boolean isUpdated;
        private HelpCtx helpCtx;
        private JComponent component;
        private Lookup lookup;
        private final String id;

        private Category(String string, OptionsCategory optionsCategory) {
            this.category = optionsCategory;
            this.id = string;
        }

        boolean isCurrent() {
            return this.getID().equals(CategoryModel.this.getCurrentCategoryID());
        }

        boolean isHighlited() {
            return this.getID().equals(CategoryModel.this.getHighlitedCategoryID());
        }

        private void setCurrent() {
            CategoryModel.this.setCurrentCategoryID(this.getID());
        }

        private void setHighlited(boolean bl) {
            if (bl) {
                CategoryModel.this.highlitedCategoryID = this.getID();
            } else {
                CategoryModel.this.highlitedCategoryID = currentCategoryID;
            }
        }

        public Icon getIcon() {
            return this.category.getIcon();
        }

        public String getID() {
            return this.id;
        }

        public String getCategoryName() {
            return this.category.getCategoryName();
        }

        public String getTitle() {
            return this.category.getTitle();
        }

        private synchronized OptionsPanelController create() {
            if (this.controller == null) {
                this.controller = this.category.create();
            }
            return this.controller;
        }

        final void update(PropertyChangeListener propertyChangeListener, boolean bl) {
            if (!this.isUpdated && !bl || this.isUpdated && bl) {
                this.isUpdated = true;
                this.getComponent();
                this.create().update();
                if (propertyChangeListener != null) {
                    this.create().addPropertyChangeListener(propertyChangeListener);
                }
            }
        }

        private void applyChanges() {
            if (this.isUpdated) {
                this.create().applyChanges();
            }
            this.isUpdated = false;
        }

        private void cancel() {
            if (this.isUpdated) {
                this.create().cancel();
            }
            this.isUpdated = false;
        }

        private boolean isValid() {
            boolean bl = true;
            if (this.isUpdated) {
                bl = this.create().isValid();
            }
            return bl;
        }

        private boolean isChanged() {
            boolean bl = false;
            if (this.isUpdated) {
                bl = this.create().isChanged();
            }
            return bl;
        }

        public JComponent getComponent() {
            if (this.component == null) {
                this.component = this.create().getComponent((Lookup)CategoryModel.this.getMasterLookup());
            }
            return this.component;
        }

        private HelpCtx getHelpCtx() {
            return this.create().getHelpCtx();
        }

        private Lookup getLookup() {
            if (this.lookup == null) {
                this.lookup = this.create().getLookup();
            }
            return this.lookup;
        }
    }
}

