/*
 * Note: this file originally auto-generated by mib2c using
 *       version : 15899 $ of $ 
 *
 * $Id:$
 */
/*
 * *********************************************************************
 * *********************************************************************
 * *********************************************************************
 * ***                                                               ***
 * ***  NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE  ***
 * ***                                                               ***
 * ***                                                               ***
 * ***       THIS FILE DOES NOT CONTAIN ANY USER EDITABLE CODE.      ***
 * ***                                                               ***
 * ***                                                               ***
 * ***       THE GENERATED CODE IS INTERNAL IMPLEMENTATION, AND      ***
 * ***                                                               ***
 * ***                                                               ***
 * ***    IS SUBJECT TO CHANGE WITHOUT WARNING IN FUTURE RELEASES.   ***
 * ***                                                               ***
 * ***                                                               ***
 * *********************************************************************
 * *********************************************************************
 * *********************************************************************
 */

/*
 * standard Net-SNMP includes 
 */
#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>

/*
 * include our parent header 
 */
#include "ipIfStatsTable.h"


#include <net-snmp/agent/table_container.h>
#include <net-snmp/library/container.h>

#include "ipIfStatsTable_interface.h"

#include <ctype.h>

/**********************************************************************
 **********************************************************************
 ***
 *** Table ipIfStatsTable
 ***
 **********************************************************************
 **********************************************************************/
/*
 * IP-MIB::ipIfStatsTable is subid 3 of ipTrafficStats.
 * Its status is Current.
 * OID: .1.3.6.1.2.1.4.31.3, length: 9
 */
typedef struct ipIfStatsTable_interface_ctx_s {

    netsnmp_container *container;
    netsnmp_cache  *cache;

    ipIfStatsTable_registration *user_ctx;

    netsnmp_table_registration_info tbl_info;

    netsnmp_baby_steps_access_methods access_multiplexer;

    u_long last_changed;

} ipIfStatsTable_interface_ctx;

static ipIfStatsTable_interface_ctx ipIfStatsTable_if_ctx;

static void     _ipIfStatsTable_container_init(ipIfStatsTable_interface_ctx
                                               * if_ctx);
static void    
_ipIfStatsTable_container_shutdown(ipIfStatsTable_interface_ctx * if_ctx);


netsnmp_container *
ipIfStatsTable_container_get(void)
{
    return ipIfStatsTable_if_ctx.container;
}

ipIfStatsTable_registration *
ipIfStatsTable_registration_get(void)
{
    return ipIfStatsTable_if_ctx.user_ctx;
}

ipIfStatsTable_registration *
ipIfStatsTable_registration_set(ipIfStatsTable_registration * newreg)
{
    ipIfStatsTable_registration *old = ipIfStatsTable_if_ctx.user_ctx;
    ipIfStatsTable_if_ctx.user_ctx = newreg;
    return old;
}

int
ipIfStatsTable_container_size(void)
{
    return CONTAINER_SIZE(ipIfStatsTable_if_ctx.container);
}

/*
 * ipIfStatsTableLastChanged, which is the last time that a row in
 * the table was changed or the last time a row was added/deleted from the
 * table.
 */
void
ipIfStatsTable_lastChange_set(u_long table_changed)
{
    DEBUGMSGTL(("ipIfStatsTable:lastChanged_set",
                "called. was %ld, now %ld\n",
                ipIfStatsTable_if_ctx.last_changed, table_changed));
    ipIfStatsTable_if_ctx.last_changed = table_changed;
}

/*
 * mfd multiplexer modes
 */
static Netsnmp_Node_Handler _mfd_ipIfStatsTable_pre_request;
static Netsnmp_Node_Handler _mfd_ipIfStatsTable_post_request;
static Netsnmp_Node_Handler _mfd_ipIfStatsTable_object_lookup;
static Netsnmp_Node_Handler _mfd_ipIfStatsTable_get_values;
/**
 * @internal
 * Initialize the table ipIfStatsTable 
 *    (Define its contents and how it's structured)
 */
void
_ipIfStatsTable_initialize_interface(ipIfStatsTable_registration * reg_ptr,
                                     u_long flags)
{
    netsnmp_baby_steps_access_methods *access_multiplexer =
        &ipIfStatsTable_if_ctx.access_multiplexer;
    netsnmp_table_registration_info *tbl_info =
        &ipIfStatsTable_if_ctx.tbl_info;
    netsnmp_handler_registration *reginfo;
    netsnmp_mib_handler *handler;
    int             mfd_modes = 0;

    DEBUGMSGTL(("internal:ipIfStatsTable:_ipIfStatsTable_initialize_interface", "called\n"));


    /*************************************************
     *
     * save interface context for ipIfStatsTable
     */
    /*
     * Setting up the table's definition
     */
    netsnmp_table_helper_add_indexes(tbl_info, ASN_INTEGER,
                                               /** index: ipIfStatsIPVersion */
                                     ASN_INTEGER,
                                               /** index: ipIfStatsIfIndex */
                                     0);

    /*
     * Define the minimum and maximum accessible columns.  This
     * optimizes retrieval. 
     */
    tbl_info->min_column = IPIFSTATSTABLE_MIN_COL;
    tbl_info->max_column = IPIFSTATSTABLE_MAX_COL;

    /*
     * save users context
     */
    ipIfStatsTable_if_ctx.user_ctx = reg_ptr;

    /*
     * call data access initialization code
     */
    ipIfStatsTable_init_data(reg_ptr);

    /*
     * set up the container
     */
    _ipIfStatsTable_container_init(&ipIfStatsTable_if_ctx);
    if (NULL == ipIfStatsTable_if_ctx.container) {
        snmp_log(LOG_ERR,
                 "could not initialize container for ipIfStatsTable\n");
        return;
    }

    /*
     * access_multiplexer: REQUIRED wrapper for get request handling
     */
    access_multiplexer->object_lookup = _mfd_ipIfStatsTable_object_lookup;
    access_multiplexer->get_values = _mfd_ipIfStatsTable_get_values;

    /*
     * no wrappers yet
     */
    access_multiplexer->pre_request = _mfd_ipIfStatsTable_pre_request;
    access_multiplexer->post_request = _mfd_ipIfStatsTable_post_request;


    /*************************************************
     *
     * Create a registration, save our reg data, register table.
     */
    DEBUGMSGTL(("ipIfStatsTable:init_ipIfStatsTable",
                "Registering ipIfStatsTable as a mibs-for-dummies table.\n"));
    handler =
        netsnmp_baby_steps_access_multiplexer_get(access_multiplexer);
    reginfo =
        netsnmp_handler_registration_create("ipIfStatsTable", handler,
                                            ipIfStatsTable_oid,
                                            ipIfStatsTable_oid_size,
                                            HANDLER_CAN_BABY_STEP |
                                            HANDLER_CAN_RONLY);
    if (NULL == reginfo) {
        snmp_log(LOG_ERR, "error registering table ipIfStatsTable\n");
        return;
    }
    reginfo->my_reg_void = &ipIfStatsTable_if_ctx;

    /*************************************************
     *
     * set up baby steps handler, create it and inject it
     */
    if (access_multiplexer->object_lookup)
        mfd_modes |= BABY_STEP_OBJECT_LOOKUP;
    if (access_multiplexer->set_values)
        mfd_modes |= BABY_STEP_SET_VALUES;
    if (access_multiplexer->irreversible_commit)
        mfd_modes |= BABY_STEP_IRREVERSIBLE_COMMIT;
    if (access_multiplexer->object_syntax_checks)
        mfd_modes |= BABY_STEP_CHECK_OBJECT;

    if (access_multiplexer->pre_request)
        mfd_modes |= BABY_STEP_PRE_REQUEST;
    if (access_multiplexer->post_request)
        mfd_modes |= BABY_STEP_POST_REQUEST;

    if (access_multiplexer->undo_setup)
        mfd_modes |= BABY_STEP_UNDO_SETUP;
    if (access_multiplexer->undo_cleanup)
        mfd_modes |= BABY_STEP_UNDO_CLEANUP;
    if (access_multiplexer->undo_sets)
        mfd_modes |= BABY_STEP_UNDO_SETS;

    if (access_multiplexer->row_creation)
        mfd_modes |= BABY_STEP_ROW_CREATE;
    if (access_multiplexer->consistency_checks)
        mfd_modes |= BABY_STEP_CHECK_CONSISTENCY;
    if (access_multiplexer->commit)
        mfd_modes |= BABY_STEP_COMMIT;
    if (access_multiplexer->undo_commit)
        mfd_modes |= BABY_STEP_UNDO_COMMIT;

    handler = netsnmp_baby_steps_handler_get(mfd_modes);
    netsnmp_inject_handler(reginfo, handler);

    /*************************************************
     *
     * inject row_merge helper with prefix rootoid_len + 2 (entry.col)
     */
    handler = netsnmp_get_row_merge_handler(reginfo->rootoid_len + 2);
    netsnmp_inject_handler(reginfo, handler);

    /*************************************************
     *
     * inject container_table helper
     */
    handler =
        netsnmp_container_table_handler_get(tbl_info,
                                            ipIfStatsTable_if_ctx.
                                            container,
                                            TABLE_CONTAINER_KEY_NETSNMP_INDEX);
    netsnmp_inject_handler(reginfo, handler);

    /*************************************************
     *
     * inject cache helper
     */
    if (NULL != ipIfStatsTable_if_ctx.cache) {
        handler = netsnmp_cache_handler_get(ipIfStatsTable_if_ctx.cache);
        netsnmp_inject_handler(reginfo, handler);
    }

    /*
     * register table
     */
    netsnmp_register_table(reginfo, tbl_info);
    
    /*
     * register LastChanged
     */
    {
        oid     lc_oid[] = { IPIFSTATSTABLELASTCHANGE_OID };
        netsnmp_register_watched_scalar(netsnmp_create_handler_registration
                ("ipIfStatsTableLastChanged", NULL,
                 lc_oid, OID_LENGTH(lc_oid),
                 HANDLER_CAN_RONLY),
                netsnmp_create_watcher_info((void
                        *)
                    &ipIfStatsTable_if_ctx.
                    last_changed,
                    sizeof
                    (u_long),
                    ASN_TIMETICKS,
                    WATCHER_FIXED_SIZE));
    }
}                               /* _ipIfStatsTable_initialize_interface */

/**
 * @internal
 * Shutdown the table ipIfStatsTable
 */
void
_ipIfStatsTable_shutdown_interface(ipIfStatsTable_registration * reg_ptr)
{
    /*
     * shutdown the container
     */
    _ipIfStatsTable_container_shutdown(&ipIfStatsTable_if_ctx);
}

void
ipIfStatsTable_valid_columns_set(netsnmp_column_info *vc)
{
    ipIfStatsTable_if_ctx.tbl_info.valid_columns = vc;
}                               /* ipIfStatsTable_valid_columns_set */

/**
 * @internal
 * convert the index component stored in the context to an oid
 */
int
ipIfStatsTable_index_to_oid(netsnmp_index * oid_idx,
                            ipIfStatsTable_mib_index * mib_idx)
{
    int             err = SNMP_ERR_NOERROR;

    /*
     * temp storage for parsing indexes
     */
    /*
     * ipIfStatsIPVersion(1)/InetVersion/ASN_INTEGER/long(u_long)//l/a/w/E/r/d/h
     */
    netsnmp_variable_list var_ipIfStatsIPVersion;
    /*
     * ipIfStatsIfIndex(2)/InterfaceIndex/ASN_INTEGER/long(long)//l/a/w/e/R/d/H
     */
    netsnmp_variable_list var_ipIfStatsIfIndex;

    /*
     * set up varbinds
     */
    memset(&var_ipIfStatsIPVersion, 0x00, sizeof(var_ipIfStatsIPVersion));
    var_ipIfStatsIPVersion.type = ASN_INTEGER;
    memset(&var_ipIfStatsIfIndex, 0x00, sizeof(var_ipIfStatsIfIndex));
    var_ipIfStatsIfIndex.type = ASN_INTEGER;

    /*
     * chain temp index varbinds together
     */
    var_ipIfStatsIPVersion.next_variable = &var_ipIfStatsIfIndex;
    var_ipIfStatsIfIndex.next_variable = NULL;


    DEBUGMSGTL(("verbose:ipIfStatsTable:ipIfStatsTable_index_to_oid",
                "called\n"));

    /*
     * ipIfStatsIPVersion(1)/InetVersion/ASN_INTEGER/long(u_long)//l/a/w/E/r/d/h 
     */
    snmp_set_var_value(&var_ipIfStatsIPVersion,
                       (u_char *) & mib_idx->ipIfStatsIPVersion,
                       sizeof(mib_idx->ipIfStatsIPVersion));

    /*
     * ipIfStatsIfIndex(2)/InterfaceIndex/ASN_INTEGER/long(long)//l/a/w/e/R/d/H 
     */
    snmp_set_var_value(&var_ipIfStatsIfIndex,
                       (u_char *) & mib_idx->ipIfStatsIfIndex,
                       sizeof(mib_idx->ipIfStatsIfIndex));


    err = build_oid_noalloc(oid_idx->oids, oid_idx->len, &oid_idx->len,
                            NULL, 0, &var_ipIfStatsIPVersion);
    if (err)
        snmp_log(LOG_ERR, "error %d converting index to oid\n", err);

    /*
     * parsing may have allocated memory. free it.
     */
    snmp_reset_var_buffers(&var_ipIfStatsIPVersion);

    return err;
}                               /* ipIfStatsTable_index_to_oid */

/**
 * extract ipIfStatsTable indexes from a netsnmp_index
 *
 * @retval SNMP_ERR_NOERROR  : no error
 * @retval SNMP_ERR_GENERR   : error
 */
int
ipIfStatsTable_index_from_oid(netsnmp_index * oid_idx,
                              ipIfStatsTable_mib_index * mib_idx)
{
    int             err = SNMP_ERR_NOERROR;

    /*
     * temp storage for parsing indexes
     */
    /*
     * ipIfStatsIPVersion(1)/InetVersion/ASN_INTEGER/long(u_long)//l/a/w/E/r/d/h
     */
    netsnmp_variable_list var_ipIfStatsIPVersion;
    /*
     * ipIfStatsIfIndex(2)/InterfaceIndex/ASN_INTEGER/long(long)//l/a/w/e/R/d/H
     */
    netsnmp_variable_list var_ipIfStatsIfIndex;

    /*
     * set up varbinds
     */
    memset(&var_ipIfStatsIPVersion, 0x00, sizeof(var_ipIfStatsIPVersion));
    var_ipIfStatsIPVersion.type = ASN_INTEGER;
    memset(&var_ipIfStatsIfIndex, 0x00, sizeof(var_ipIfStatsIfIndex));
    var_ipIfStatsIfIndex.type = ASN_INTEGER;

    /*
     * chain temp index varbinds together
     */
    var_ipIfStatsIPVersion.next_variable = &var_ipIfStatsIfIndex;
    var_ipIfStatsIfIndex.next_variable = NULL;


    DEBUGMSGTL(("verbose:ipIfStatsTable:ipIfStatsTable_index_from_oid",
                "called\n"));

    /*
     * parse the oid into the individual index components
     */
    err = parse_oid_indexes(oid_idx->oids, oid_idx->len,
                            &var_ipIfStatsIPVersion);
    if (err == SNMP_ERR_NOERROR) {
        /*
         * copy out values
         */
        mib_idx->ipIfStatsIPVersion =
            *((u_long *) var_ipIfStatsIPVersion.val.string);
        mib_idx->ipIfStatsIfIndex =
            *((long *) var_ipIfStatsIfIndex.val.string);


    }

    /*
     * parsing may have allocated memory. free it.
     */
    snmp_reset_var_buffers(&var_ipIfStatsIPVersion);

    return err;
}                               /* ipIfStatsTable_index_from_oid */


/*
 *********************************************************************
 * @internal
 * allocate resources for a ipIfStatsTable_rowreq_ctx
 */
ipIfStatsTable_rowreq_ctx *
ipIfStatsTable_allocate_rowreq_ctx(ipIfStatsTable_data * data,
                                   void *user_init_ctx)
{
    ipIfStatsTable_rowreq_ctx *rowreq_ctx =
        SNMP_MALLOC_TYPEDEF(ipIfStatsTable_rowreq_ctx);

    DEBUGMSGTL(("internal:ipIfStatsTable:ipIfStatsTable_allocate_rowreq_ctx", "called\n"));

    if (NULL == rowreq_ctx) {
        snmp_log(LOG_ERR, "Couldn't allocate memory for a "
                 "ipIfStatsTable_rowreq_ctx.\n");
        return NULL;
    } else {
        if (NULL != data) {
            /*
             * track if we got data from user
             */
            rowreq_ctx->rowreq_flags |= MFD_ROW_DATA_FROM_USER;
            rowreq_ctx->data = data;
        } else if (NULL ==
                   (rowreq_ctx->data = ipIfStatsTable_allocate_data())) {
            SNMP_FREE(rowreq_ctx);
            return NULL;
        }
    }

    /*
     * undo context will be allocated when needed (in *_undo_setup)
     */

    rowreq_ctx->oid_idx.oids = rowreq_ctx->oid_tmp;

    rowreq_ctx->ipIfStatsTable_data_list = NULL;

    /*
     * if we allocated data, call init routine
     */
    if (!(rowreq_ctx->rowreq_flags & MFD_ROW_DATA_FROM_USER)) {
        if (SNMPERR_SUCCESS !=
            ipIfStatsTable_rowreq_ctx_init(rowreq_ctx, user_init_ctx)) {
            ipIfStatsTable_release_rowreq_ctx(rowreq_ctx);
            rowreq_ctx = NULL;
        }
    }

    return rowreq_ctx;
}                               /* ipIfStatsTable_allocate_rowreq_ctx */

/*
 * @internal
 * release resources for a ipIfStatsTable_rowreq_ctx
 */
void
ipIfStatsTable_release_rowreq_ctx(ipIfStatsTable_rowreq_ctx * rowreq_ctx)
{
    DEBUGMSGTL(("internal:ipIfStatsTable:ipIfStatsTable_release_rowreq_ctx", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    ipIfStatsTable_rowreq_ctx_cleanup(rowreq_ctx);

    /*
     * for non-transient data, don't free data we got from the user
     */
    if ((rowreq_ctx->data) &&
        !(rowreq_ctx->rowreq_flags & MFD_ROW_DATA_FROM_USER))
        ipIfStatsTable_release_data(rowreq_ctx->data);

    /*
     * free index oid pointer
     */
    if (rowreq_ctx->oid_idx.oids != rowreq_ctx->oid_tmp)
        free(rowreq_ctx->oid_idx.oids);

    SNMP_FREE(rowreq_ctx);
}                               /* ipIfStatsTable_release_rowreq_ctx */

/**
 * @internal
 * wrapper
 */
static int
_mfd_ipIfStatsTable_pre_request(netsnmp_mib_handler *handler,
                                netsnmp_handler_registration *reginfo,
                                netsnmp_agent_request_info *agtreq_info,
                                netsnmp_request_info *requests)
{
    int             rc;

    DEBUGMSGTL(("internal:ipIfStatsTable:_mfd_ipIfStatsTable_pre_request",
                "called\n"));

    if (1 != netsnmp_row_merge_status_first(reginfo, agtreq_info)) {
        DEBUGMSGTL(("internal:ipIfStatsTable",
                    "skipping additional pre_request\n"));
        return SNMP_ERR_NOERROR;
    }

    rc = ipIfStatsTable_pre_request(ipIfStatsTable_if_ctx.user_ctx);
    if (MFD_SUCCESS != rc) {
        /*
         * nothing we can do about it but log it
         */
        DEBUGMSGTL(("ipIfStatsTable", "error %d from "
                    "ipIfStatsTable_pre_request\n", rc));
        netsnmp_request_set_error_all(requests, SNMP_VALIDATE_ERR(rc));
    }

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ipIfStatsTable_pre_request */

/**
 * @internal
 * wrapper
 */
static int
_mfd_ipIfStatsTable_post_request(netsnmp_mib_handler *handler,
                                 netsnmp_handler_registration *reginfo,
                                 netsnmp_agent_request_info *agtreq_info,
                                 netsnmp_request_info *requests)
{
    ipIfStatsTable_rowreq_ctx *rowreq_ctx = (ipIfStatsTable_rowreq_ctx*)
        netsnmp_container_table_row_extract(requests);
    int             rc, packet_rc;

    DEBUGMSGTL(("internal:ipIfStatsTable:_mfd_ipIfStatsTable_post_request",
                "called\n"));

    /*
     * release row context, if deleted
     */
    if (rowreq_ctx && (rowreq_ctx->rowreq_flags & MFD_ROW_DELETED))
        ipIfStatsTable_release_rowreq_ctx(rowreq_ctx);

    /*
     * wait for last call before calling user
     */
    if (1 != netsnmp_row_merge_status_last(reginfo, agtreq_info)) {
        DEBUGMSGTL(("internal:ipIfStatsTable",
                    "waiting for last post_request\n"));
        return SNMP_ERR_NOERROR;
    }

    packet_rc = netsnmp_check_all_requests_error(agtreq_info->asp, 0);
    rc = ipIfStatsTable_post_request(ipIfStatsTable_if_ctx.user_ctx,
                                     packet_rc);
    if (MFD_SUCCESS != rc) {
        /*
         * nothing we can do about it but log it
         */
        DEBUGMSGTL(("ipIfStatsTable", "error %d from "
                    "ipIfStatsTable_post_request\n", rc));
    }

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ipIfStatsTable_post_request */

/**
 * @internal
 * wrapper
 */
static int
_mfd_ipIfStatsTable_object_lookup(netsnmp_mib_handler *handler,
                                  netsnmp_handler_registration *reginfo,
                                  netsnmp_agent_request_info *agtreq_info,
                                  netsnmp_request_info *requests)
{
    int             rc = SNMP_ERR_NOERROR;
    ipIfStatsTable_rowreq_ctx *rowreq_ctx = (ipIfStatsTable_rowreq_ctx*)
        netsnmp_container_table_row_extract(requests);

    DEBUGMSGTL(("internal:ipIfStatsTable:_mfd_ipIfStatsTable_object_lookup", "called\n"));

    /*
     * get our context from mfd
     * ipIfStatsTable_interface_ctx *if_ctx =
     *             (ipIfStatsTable_interface_ctx *)reginfo->my_reg_void;
     */

    if (NULL == rowreq_ctx) {
        rc = SNMP_ERR_NOCREATION;
    }

    if (MFD_SUCCESS != rc)
        netsnmp_request_set_error_all(requests, rc);
    else
        ipIfStatsTable_row_prep(rowreq_ctx);

    return SNMP_VALIDATE_ERR(rc);
}                               /* _mfd_ipIfStatsTable_object_lookup */

/***********************************************************************
 *
 * GET processing
 *
 ***********************************************************************/
/*
 * @internal
 * Retrieve the value for a particular column
 */
NETSNMP_STATIC_INLINE int
_ipIfStatsTable_get_column(ipIfStatsTable_rowreq_ctx * rowreq_ctx,
                           netsnmp_variable_list * var, int column)
{
    int             rc = SNMPERR_SUCCESS;

    DEBUGMSGTL(("internal:ipIfStatsTable:_mfd_ipIfStatsTable_get_column",
                "called for %d\n", column));


    netsnmp_assert(NULL != rowreq_ctx);

    switch (column) {

        /*
         * ipIfStatsInReceives(3)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSINRECEIVES:
        var->val_len = sizeof(u_long);
        var->type = ASN_COUNTER;
        rc = ipIfStatsInReceives_get(rowreq_ctx,
                                     (u_long *) var->val.string);
        break;

        /*
         * ipIfStatsHCInReceives(4)/COUNTER64/ASN_COUNTER64/U64(U64)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSHCINRECEIVES:
        var->val_len = sizeof(U64);
        var->type = ASN_COUNTER64;
        rc = ipIfStatsHCInReceives_get(rowreq_ctx,
                                       (U64 *) var->val.string);
        break;

        /*
         * ipIfStatsInOctets(5)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSINOCTETS:
        var->val_len = sizeof(u_long);
        var->type = ASN_COUNTER;
        rc = ipIfStatsInOctets_get(rowreq_ctx, (u_long *) var->val.string);
        break;

        /*
         * ipIfStatsHCInOctets(6)/COUNTER64/ASN_COUNTER64/U64(U64)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSHCINOCTETS:
        var->val_len = sizeof(U64);
        var->type = ASN_COUNTER64;
        rc = ipIfStatsHCInOctets_get(rowreq_ctx, (U64 *) var->val.string);
        break;

        /*
         * ipIfStatsInHdrErrors(7)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSINHDRERRORS:
        var->val_len = sizeof(u_long);
        var->type = ASN_COUNTER;
        rc = ipIfStatsInHdrErrors_get(rowreq_ctx,
                                      (u_long *) var->val.string);
        break;

        /*
         * ipIfStatsInNoRoutes(8)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSINNOROUTES:
        var->val_len = sizeof(u_long);
        var->type = ASN_COUNTER;
        rc = ipIfStatsInNoRoutes_get(rowreq_ctx,
                                     (u_long *) var->val.string);
        break;

        /*
         * ipIfStatsInAddrErrors(9)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSINADDRERRORS:
        var->val_len = sizeof(u_long);
        var->type = ASN_COUNTER;
        rc = ipIfStatsInAddrErrors_get(rowreq_ctx,
                                       (u_long *) var->val.string);
        break;

        /*
         * ipIfStatsInUnknownProtos(10)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSINUNKNOWNPROTOS:
        var->val_len = sizeof(u_long);
        var->type = ASN_COUNTER;
        rc = ipIfStatsInUnknownProtos_get(rowreq_ctx,
                                          (u_long *) var->val.string);
        break;

        /*
         * ipIfStatsInTruncatedPkts(11)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSINTRUNCATEDPKTS:
        var->val_len = sizeof(u_long);
        var->type = ASN_COUNTER;
        rc = ipIfStatsInTruncatedPkts_get(rowreq_ctx,
                                          (u_long *) var->val.string);
        break;

        /*
         * ipIfStatsInForwDatagrams(12)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSINFORWDATAGRAMS:
        var->val_len = sizeof(u_long);
        var->type = ASN_COUNTER;
        rc = ipIfStatsInForwDatagrams_get(rowreq_ctx,
                                          (u_long *) var->val.string);
        break;

        /*
         * ipIfStatsHCInForwDatagrams(13)/COUNTER64/ASN_COUNTER64/U64(U64)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSHCINFORWDATAGRAMS:
        var->val_len = sizeof(U64);
        var->type = ASN_COUNTER64;
        rc = ipIfStatsHCInForwDatagrams_get(rowreq_ctx,
                                            (U64 *) var->val.string);
        break;

        /*
         * ipIfStatsReasmReqds(14)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSREASMREQDS:
        var->val_len = sizeof(u_long);
        var->type = ASN_COUNTER;
        rc = ipIfStatsReasmReqds_get(rowreq_ctx,
                                     (u_long *) var->val.string);
        break;

        /*
         * ipIfStatsReasmOKs(15)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSREASMOKS:
        var->val_len = sizeof(u_long);
        var->type = ASN_COUNTER;
        rc = ipIfStatsReasmOKs_get(rowreq_ctx, (u_long *) var->val.string);
        break;

        /*
         * ipIfStatsReasmFails(16)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSREASMFAILS:
        var->val_len = sizeof(u_long);
        var->type = ASN_COUNTER;
        rc = ipIfStatsReasmFails_get(rowreq_ctx,
                                     (u_long *) var->val.string);
        break;

        /*
         * ipIfStatsInDiscards(17)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSINDISCARDS:
        var->val_len = sizeof(u_long);
        var->type = ASN_COUNTER;
        rc = ipIfStatsInDiscards_get(rowreq_ctx,
                                     (u_long *) var->val.string);
        break;

        /*
         * ipIfStatsInDelivers(18)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSINDELIVERS:
        var->val_len = sizeof(u_long);
        var->type = ASN_COUNTER;
        rc = ipIfStatsInDelivers_get(rowreq_ctx,
                                     (u_long *) var->val.string);
        break;

        /*
         * ipIfStatsHCInDelivers(19)/COUNTER64/ASN_COUNTER64/U64(U64)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSHCINDELIVERS:
        var->val_len = sizeof(U64);
        var->type = ASN_COUNTER64;
        rc = ipIfStatsHCInDelivers_get(rowreq_ctx,
                                       (U64 *) var->val.string);
        break;

        /*
         * ipIfStatsOutRequests(20)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSOUTREQUESTS:
        var->val_len = sizeof(u_long);
        var->type = ASN_COUNTER;
        rc = ipIfStatsOutRequests_get(rowreq_ctx,
                                      (u_long *) var->val.string);
        break;

        /*
         * ipIfStatsHCOutRequests(21)/COUNTER64/ASN_COUNTER64/U64(U64)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSHCOUTREQUESTS:
        var->val_len = sizeof(U64);
        var->type = ASN_COUNTER64;
        rc = ipIfStatsHCOutRequests_get(rowreq_ctx,
                                        (U64 *) var->val.string);
        break;

        /*
         * ipIfStatsOutForwDatagrams(23)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSOUTFORWDATAGRAMS:
        var->val_len = sizeof(u_long);
        var->type = ASN_COUNTER;
        rc = ipIfStatsOutForwDatagrams_get(rowreq_ctx,
                                           (u_long *) var->val.string);
        break;

        /*
         * ipIfStatsHCOutForwDatagrams(24)/COUNTER64/ASN_COUNTER64/U64(U64)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSHCOUTFORWDATAGRAMS:
        var->val_len = sizeof(U64);
        var->type = ASN_COUNTER64;
        rc = ipIfStatsHCOutForwDatagrams_get(rowreq_ctx,
                                             (U64 *) var->val.string);
        break;

        /*
         * ipIfStatsOutDiscards(25)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSOUTDISCARDS:
        var->val_len = sizeof(u_long);
        var->type = ASN_COUNTER;
        rc = ipIfStatsOutDiscards_get(rowreq_ctx,
                                      (u_long *) var->val.string);
        break;

        /*
         * ipIfStatsOutFragReqds(26)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSOUTFRAGREQDS:
        var->val_len = sizeof(u_long);
        var->type = ASN_COUNTER;
        rc = ipIfStatsOutFragReqds_get(rowreq_ctx,
                                       (u_long *) var->val.string);
        break;

        /*
         * ipIfStatsOutFragOKs(27)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSOUTFRAGOKS:
        var->val_len = sizeof(u_long);
        var->type = ASN_COUNTER;
        rc = ipIfStatsOutFragOKs_get(rowreq_ctx,
                                     (u_long *) var->val.string);
        break;

        /*
         * ipIfStatsOutFragFails(28)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSOUTFRAGFAILS:
        var->val_len = sizeof(u_long);
        var->type = ASN_COUNTER;
        rc = ipIfStatsOutFragFails_get(rowreq_ctx,
                                       (u_long *) var->val.string);
        break;

        /*
         * ipIfStatsOutFragCreates(29)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSOUTFRAGCREATES:
        var->val_len = sizeof(u_long);
        var->type = ASN_COUNTER;
        rc = ipIfStatsOutFragCreates_get(rowreq_ctx,
                                         (u_long *) var->val.string);
        break;

        /*
         * ipIfStatsOutTransmits(30)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSOUTTRANSMITS:
        var->val_len = sizeof(u_long);
        var->type = ASN_COUNTER;
        rc = ipIfStatsOutTransmits_get(rowreq_ctx,
                                       (u_long *) var->val.string);
        break;

        /*
         * ipIfStatsHCOutTransmits(31)/COUNTER64/ASN_COUNTER64/U64(U64)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSHCOUTTRANSMITS:
        var->val_len = sizeof(U64);
        var->type = ASN_COUNTER64;
        rc = ipIfStatsHCOutTransmits_get(rowreq_ctx,
                                         (U64 *) var->val.string);
        break;

        /*
         * ipIfStatsOutOctets(32)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSOUTOCTETS:
        var->val_len = sizeof(u_long);
        var->type = ASN_COUNTER;
        rc = ipIfStatsOutOctets_get(rowreq_ctx,
                                    (u_long *) var->val.string);
        break;

        /*
         * ipIfStatsHCOutOctets(33)/COUNTER64/ASN_COUNTER64/U64(U64)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSHCOUTOCTETS:
        var->val_len = sizeof(U64);
        var->type = ASN_COUNTER64;
        rc = ipIfStatsHCOutOctets_get(rowreq_ctx, (U64 *) var->val.string);
        break;

        /*
         * ipIfStatsInMcastPkts(34)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSINMCASTPKTS:
        var->val_len = sizeof(u_long);
        var->type = ASN_COUNTER;
        rc = ipIfStatsInMcastPkts_get(rowreq_ctx,
                                      (u_long *) var->val.string);
        break;

        /*
         * ipIfStatsHCInMcastPkts(35)/COUNTER64/ASN_COUNTER64/U64(U64)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSHCINMCASTPKTS:
        var->val_len = sizeof(U64);
        var->type = ASN_COUNTER64;
        rc = ipIfStatsHCInMcastPkts_get(rowreq_ctx,
                                        (U64 *) var->val.string);
        break;

        /*
         * ipIfStatsInMcastOctets(36)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSINMCASTOCTETS:
        var->val_len = sizeof(u_long);
        var->type = ASN_COUNTER;
        rc = ipIfStatsInMcastOctets_get(rowreq_ctx,
                                        (u_long *) var->val.string);
        break;

        /*
         * ipIfStatsHCInMcastOctets(37)/COUNTER64/ASN_COUNTER64/U64(U64)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSHCINMCASTOCTETS:
        var->val_len = sizeof(U64);
        var->type = ASN_COUNTER64;
        rc = ipIfStatsHCInMcastOctets_get(rowreq_ctx,
                                          (U64 *) var->val.string);
        break;

        /*
         * ipIfStatsOutMcastPkts(38)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSOUTMCASTPKTS:
        var->val_len = sizeof(u_long);
        var->type = ASN_COUNTER;
        rc = ipIfStatsOutMcastPkts_get(rowreq_ctx,
                                       (u_long *) var->val.string);
        break;

        /*
         * ipIfStatsHCOutMcastPkts(39)/COUNTER64/ASN_COUNTER64/U64(U64)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSHCOUTMCASTPKTS:
        var->val_len = sizeof(U64);
        var->type = ASN_COUNTER64;
        rc = ipIfStatsHCOutMcastPkts_get(rowreq_ctx,
                                         (U64 *) var->val.string);
        break;

        /*
         * ipIfStatsOutMcastOctets(40)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSOUTMCASTOCTETS:
        var->val_len = sizeof(u_long);
        var->type = ASN_COUNTER;
        rc = ipIfStatsOutMcastOctets_get(rowreq_ctx,
                                         (u_long *) var->val.string);
        break;

        /*
         * ipIfStatsHCOutMcastOctets(41)/COUNTER64/ASN_COUNTER64/U64(U64)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSHCOUTMCASTOCTETS:
        var->val_len = sizeof(U64);
        var->type = ASN_COUNTER64;
        rc = ipIfStatsHCOutMcastOctets_get(rowreq_ctx,
                                           (U64 *) var->val.string);
        break;

        /*
         * ipIfStatsInBcastPkts(42)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSINBCASTPKTS:
        var->val_len = sizeof(u_long);
        var->type = ASN_COUNTER;
        rc = ipIfStatsInBcastPkts_get(rowreq_ctx,
                                      (u_long *) var->val.string);
        break;

        /*
         * ipIfStatsHCInBcastPkts(43)/COUNTER64/ASN_COUNTER64/U64(U64)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSHCINBCASTPKTS:
        var->val_len = sizeof(U64);
        var->type = ASN_COUNTER64;
        rc = ipIfStatsHCInBcastPkts_get(rowreq_ctx,
                                        (U64 *) var->val.string);
        break;

        /*
         * ipIfStatsOutBcastPkts(44)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSOUTBCASTPKTS:
        var->val_len = sizeof(u_long);
        var->type = ASN_COUNTER;
        rc = ipIfStatsOutBcastPkts_get(rowreq_ctx,
                                       (u_long *) var->val.string);
        break;

        /*
         * ipIfStatsHCOutBcastPkts(45)/COUNTER64/ASN_COUNTER64/U64(U64)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSHCOUTBCASTPKTS:
        var->val_len = sizeof(U64);
        var->type = ASN_COUNTER64;
        rc = ipIfStatsHCOutBcastPkts_get(rowreq_ctx,
                                         (U64 *) var->val.string);
        break;

        /*
         * ipIfStatsDiscontinuityTime(46)/TimeStamp/ASN_TIMETICKS/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSDISCONTINUITYTIME:
        var->val_len = sizeof(u_long);
        var->type = ASN_TIMETICKS;
        rc = ipIfStatsDiscontinuityTime_get(rowreq_ctx,
                                            (u_long *) var->val.string);
        break;

        /*
         * ipIfStatsRefreshRate(47)/UNSIGNED32/ASN_UNSIGNED/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IPIFSTATSREFRESHRATE:
        var->val_len = sizeof(u_long);
        var->type = ASN_UNSIGNED;
        rc = ipIfStatsRefreshRate_get(rowreq_ctx,
                                      (u_long *) var->val.string);
        break;

    default:
        if (IPIFSTATSTABLE_MIN_COL <= column
            && column <= IPIFSTATSTABLE_MAX_COL) {
            DEBUGMSGTL(("internal:ipIfStatsTable:_mfd_ipIfStatsTable_get_column", "assume column %d is reserved\n", column));
            rc = MFD_SKIP;
        } else {
            snmp_log(LOG_ERR,
                     "unknown column %d in _ipIfStatsTable_get_column\n",
                     column);
        }
        break;
    }

    return rc;
}                               /* _ipIfStatsTable_get_column */

int
_mfd_ipIfStatsTable_get_values(netsnmp_mib_handler *handler,
                               netsnmp_handler_registration *reginfo,
                               netsnmp_agent_request_info *agtreq_info,
                               netsnmp_request_info *requests)
{
    ipIfStatsTable_rowreq_ctx *rowreq_ctx = (ipIfStatsTable_rowreq_ctx*)
        netsnmp_container_table_row_extract(requests);
    netsnmp_table_request_info *tri;
    u_char         *old_string;
    void            (*dataFreeHook) (void *);
    int             rc;

    DEBUGMSGTL(("internal:ipIfStatsTable:_mfd_ipIfStatsTable_get_values",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    for (; requests; requests = requests->next) {
        /*
         * save old pointer, so we can free it if replaced
         */
        old_string = requests->requestvb->val.string;
        dataFreeHook = requests->requestvb->dataFreeHook;
        if (NULL == requests->requestvb->val.string) {
            requests->requestvb->val.string = requests->requestvb->buf;
            requests->requestvb->val_len =
                sizeof(requests->requestvb->buf);
        } else if (requests->requestvb->buf ==
                   requests->requestvb->val.string) {
            if (requests->requestvb->val_len !=
                sizeof(requests->requestvb->buf))
                requests->requestvb->val_len =
                    sizeof(requests->requestvb->buf);
        }

        /*
         * get column data
         */
        tri = netsnmp_extract_table_info(requests);
        if (NULL == tri)
            continue;

        rc = _ipIfStatsTable_get_column(rowreq_ctx, requests->requestvb,
                                        tri->colnum);
        if (rc) {
            if (MFD_SKIP == rc) {
                requests->requestvb->type = SNMP_NOSUCHINSTANCE;
                rc = SNMP_ERR_NOERROR;
            }
        } else if (NULL == requests->requestvb->val.string) {
            snmp_log(LOG_ERR, "NULL varbind data pointer!\n");
            rc = SNMP_ERR_GENERR;
        }
        if (rc)
            netsnmp_request_set_error(requests, SNMP_VALIDATE_ERR(rc));

        /*
         * if the buffer wasn't used previously for the old data (i.e. it
         * was allcoated memory)  and the get routine replaced the pointer,
         * we need to free the previous pointer.
         */
        if (old_string && (old_string != requests->requestvb->buf) &&
            (requests->requestvb->val.string != old_string)) {
            if (dataFreeHook)
                (*dataFreeHook) (old_string);
            else
                free(old_string);
        }
    }                           /* for results */

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ipIfStatsTable_get_values */


/***********************************************************************
 *
 * SET processing
 *
 ***********************************************************************/

/*
 * SET PROCESSING NOT APPLICABLE (per MIB or user setting)
 */
/***********************************************************************
 *
 * DATA ACCESS
 *
 ***********************************************************************/
static void     _container_free(netsnmp_container * container);

/**
 * @internal
 */
static int
_cache_load(netsnmp_cache * cache, void *vmagic)
{
    DEBUGMSGTL(("internal:ipIfStatsTable:_cache_load", "called\n"));

    if ((NULL == cache) || (NULL == cache->magic)) {
        snmp_log(LOG_ERR, "invalid cache for ipIfStatsTable_cache_load\n");
        return -1;
    }

    /** should only be called for an invalid or expired cache */
    netsnmp_assert((0 == cache->valid) || (1 == cache->expired));

    /*
     * call user code
     */
    return ipIfStatsTable_container_load((netsnmp_container *) cache->
                                         magic);
}                               /* _cache_load */

/**
 * @internal
 */
static void
_cache_free(netsnmp_cache * cache, void *magic)
{
    netsnmp_container *container;

    DEBUGMSGTL(("internal:ipIfStatsTable:_cache_free", "called\n"));

    if ((NULL == cache) || (NULL == cache->magic)) {
        snmp_log(LOG_ERR, "invalid cache in ipIfStatsTable_cache_free\n");
        return;
    }

    container = (netsnmp_container *) cache->magic;

    _container_free(container);
}                               /* _cache_free */

/**
 * @internal
 */
static void
_container_item_free(ipIfStatsTable_rowreq_ctx * rowreq_ctx, void *context)
{
    DEBUGMSGTL(("internal:ipIfStatsTable:_container_item_free",
                "called\n"));

    if (NULL == rowreq_ctx)
        return;

    ipIfStatsTable_release_rowreq_ctx(rowreq_ctx);
}                               /* _container_item_free */

/**
 * @internal
 */
static void
_container_free(netsnmp_container * container)
{
    DEBUGMSGTL(("internal:ipIfStatsTable:_container_free", "called\n"));

    if (NULL == container) {
        snmp_log(LOG_ERR,
                 "invalid container in ipIfStatsTable_container_free\n");
        return;
    }

    /*
     * call user code
     */
    ipIfStatsTable_container_free(container);

    /*
     * free all items. inefficient, but easy.
     */
    CONTAINER_CLEAR(container,
                    (netsnmp_container_obj_func *) _container_item_free,
                    NULL);
}                               /* _container_free */

/**
 * @internal
 * initialize the container with functions or wrappers
 */
void
_ipIfStatsTable_container_init(ipIfStatsTable_interface_ctx * if_ctx)
{
    DEBUGMSGTL(("internal:ipIfStatsTable:_ipIfStatsTable_container_init",
                "called\n"));

    /*
     * cache init
     */
    if_ctx->cache = netsnmp_cache_create(30,    /* timeout in seconds */
                                         _cache_load, _cache_free,
                                         ipIfStatsTable_oid,
                                         ipIfStatsTable_oid_size);

    if (NULL == if_ctx->cache) {
        snmp_log(LOG_ERR, "error creating cache for ipIfStatsTable\n");
        return;
    }

    if_ctx->cache->flags = NETSNMP_CACHE_DONT_INVALIDATE_ON_SET;

    ipIfStatsTable_container_init(&if_ctx->container, if_ctx->cache);
    if (NULL == if_ctx->container)
        if_ctx->container =
            netsnmp_container_find("ipIfStatsTable:table_container");
    if (NULL == if_ctx->container) {
        snmp_log(LOG_ERR, "error creating container in "
                 "ipIfStatsTable_container_init\n");
        return;
    }

    if (NULL != if_ctx->cache)
        if_ctx->cache->magic = (void *) if_ctx->container;
}                               /* _ipIfStatsTable_container_init */

/**
 * @internal
 * shutdown the container with functions or wrappers
 */
void
_ipIfStatsTable_container_shutdown(ipIfStatsTable_interface_ctx * if_ctx)
{
    DEBUGMSGTL(("internal:ipIfStatsTable:_ipIfStatsTable_container_shutdown", "called\n"));

    ipIfStatsTable_container_shutdown(if_ctx->container);

    _container_free(if_ctx->container);

}                               /* _ipIfStatsTable_container_shutdown */


ipIfStatsTable_rowreq_ctx *
ipIfStatsTable_row_find_by_mib_index(ipIfStatsTable_mib_index * mib_idx)
{
    ipIfStatsTable_rowreq_ctx *rowreq_ctx;
    oid             oid_tmp[MAX_OID_LEN];
    netsnmp_index   oid_idx;
    int             rc;

    /*
     * set up storage for OID
     */
    oid_idx.oids = oid_tmp;
    oid_idx.len = sizeof(oid_tmp) / sizeof(oid);

    /*
     * convert
     */
    rc = ipIfStatsTable_index_to_oid(&oid_idx, mib_idx);
    if (MFD_SUCCESS != rc)
        return NULL;

    rowreq_ctx = (ipIfStatsTable_rowreq_ctx*)CONTAINER_FIND(ipIfStatsTable_if_ctx.container, &oid_idx);

    return rowreq_ctx;
}
