.TH "ZIP_GET_ARCHIVE_COMMENT" "3" "February 20, 2013" "NiH" "Library Functions Manual"
.SH "NAME"
\fBzip_get_archive_comment\fP
\- get zip archive comment
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
zip.h
const char *
zip_get_archive_comment zip_t *archive int *lenp zip_flags_t flags
.SH "DESCRIPTION"
The
zip_get_archive_comment
function returns the comment for the entire zip archive.
The name is in UTF-8 encoding unless
\fRZIP_FL_ENC_RAW\fP
was specified (see below).
This pointer should not be modified or
free(3)'d,
and becomes invalid when
\fIarchive\fP
is closed.
If
\fIlenp\fP
is not
\fRNULL\fP,
the integer to which it points will be set to the length of the
comment.
If
\fIflags\fP
is set to
\fRZIP_FL_UNCHANGED\fP,
the original unchanged comment is returned.
.PP
Additionally, the following
\fIflags\fP
are supported:
.TP ZIP_FL_ENC_STRICTXX
\fRZIP_FL_ENC_RAW\fP
Return the unmodified archive comment as it is in the ZIP archive.
.TP ZIP_FL_ENC_STRICTXX
\fRZIP_FL_ENC_GUESS\fP
(Default.)
Guess the encoding of the archive comment in the ZIP archive and convert it
to UTF-8, if necessary.
.TP ZIP_FL_ENC_STRICTXX
\fRZIP_FL_ENC_STRICT\fP
Follow the ZIP specification for file names and extend it to the
archive comment, thus also expecting it in CP-437 encoding.
Convert it to UTF-8.
\fINote\fP:
ASCII is a subset of both CP-437 and UTF-8.
.SH "RETURN VALUES"
Upon successful completion, a pointer to the comment is returned,
or
\fRNULL\fP
if there is no comment.
.SH "SEE ALSO"
libzip(3),
zip_get_file_comment(3)
.SH "AUTHORS"
Dieter Baron <dillo@nih.at>
and
Thomas Klausner <tk@giga.or.at>
