.\" Copyright (c) 1987-2020 UMD-CS, released under the X11 license;
.\" see README and source files.
.TH DVITODVI 1 "8 September 2020" "TeX Live"
.SH NAME
dvitodvi \- rearrange pages in a DVI file
.SH SYNOPSIS
.B dvitodvi
[
.B \-q
] [
.B \-i
.I infile
] [
.B \-o
.I outfile
]
[
.B \-w\fIwidth\fR
]
[
.B \-h\fIheight\fR
]
.I pagespecs
[
.I infile
[
.I outfile
] ]
.SH DESCRIPTION
.I Dvitodvi
rearranges pages from a DVI file, creating a new DVI file.
.I Dvitodvi
can be used to perform a large number of arbitrary re-arrangements of
Documents, including arranging for printing 2-up, 4-up, booklets, reversing,
selecting front or back sides of documents, scaling, etc.
.PP
.I pagespecs
follow the syntax:
.RS
.TP 12
.I pagespecs
.I = [modulo:][mag@]specs
.TP
.I specs
.I = spec[+specs][,specs]
.TP
.I spec
.I = [-]pageno[(xoff,yoff)]
.RE
.sp
.I modulo
is the number of pages in each block. The value of
.I modulo
should be greater than 0; the default value is 1.
The optional
.I mag
parameter adjusts the file's magnification by the magnification specified. The
magnification and modulo can be specified in reverse order if desired.
.I specs
are the page specifications for the pages in each block. The value of the
.I pageno
in each
.I spec
should be between 0 (for the first page in the block) and \fImodulo\fR-1
(for the last page in each block) inclusive.
The optional dimensions
.I xoff
and
.I yoff
shift the page by the specified (positive) amount.
.I xoff
and
.I yoff
are in PostScript's points, but may be followed by the units
.B "cm"
or
.B "in"
to convert to centimetres or inches, or the flag
.B "w"
or
.B "h"
to specify as a multiple of the width or height.
If the optional minus sign is specified, the page is relative to the end of
the document, instead of the start.

If page \fIspec\fRs are separated by
.B +
the pages will be merged into one page; if they are separated by
.B ,
they will be on separate pages.
If there is only one page specification, with
.I pageno
zero, the \fIpageno\fR may be omitted.
.PP
The
.I \-w
option gives the width which is used by the
.B "w"
dimension specifier, and the
.I \-h
option gives the height which is used by the
.B "h"
dimension specifier. These dimensions are also used (after scaling) to set the
clipping path for each page.
.PP
Dvitodvi normally prints the page numbers of the pages re-arranged; the
.I \-q
option suppresses this.
.SH EXAMPLES
This section contains some sample re-arrangements. To put two pages on one
sheet (of landscaped A3 paper), the pagespec to use is:
.sp
.RS
2:0+1(21cm,0)
.RE
.sp
To reduce an A3 page to A4 size, the pagespec to use is:
.sp
.RS
700@(-.3in,-.3in)
.RE
.sp
To select all of the odd pages in reverse order, use:
.sp
.RS
2:-0
.RE
.sp
.SH AUTHOR
Angus Duggan, from dviselect(1), by
Chris Torek, University of Maryland. Currently maintained as part
of TeX Live (https://tug.org/texlive).
.SH "SEE ALSO"
dvibook(1), dviconcat(1), dviselect(1), latex(1), tex(1)
.br
.I "MC-TeX User's Guide"
.SH BUGS
.I Dvitodvi
does not adjust some of the parameters in the postamble. This may be a problem
if these values are used to size certain structures in the output
conversion programs.
