#
# $Id: makefile.atari 3.38.2.21 1992/11/24 16:22:20 woo Exp $
#

#
# GNUPLOT makefile for GCC-ST 1.x and 2.x
# in a cross development environment (unix) or a native TOS environment
# (see configuration section)
#
# Modified from the BorlandC makefile by Alexander Lehmann
#

# -------------------- begin of configuration section -----------------------

# CC is name of compiler producing TOS executables
# HOSTCC is the name of the native compiler
# SL is the path separator (/ for unix or UNIXMODE, \ for standard TOS)

# settings for crosscompiling:
CC = cgcc
#HOSTCC = gcc
HOSTCC = cc
SL=/

# settings for native compiling:
#CC = gcc
#HOSTCC = $(CC)
#SL=\ 

# -O means optimisation in general
#  o-f-p avoids link-unlink instructions
#  s-r	 optimisation of loops and elimination of iterations variables
#  c-r	 improve register movement
# if you have GCC 2.x (and time), you can choose the -O2 option

# first line for GCC 1.x, second and third for GCC 2.x

#OPTFLAGS = -O -fomit-frame-pointer -fstrength-reduce -fcombine-regs
OPTFLAGS = -O -fomit-frame-pointer -fstrength-reduce
#OPTFLAGS = -O2 -fomit-frame-pointer

# -c means don't link
# -DREADLINE to use the history/line editing capability. If you want this 
#    capability add -DREADLINE to CFLAGS (currently on)

CFLAGS = -c $(OPTFLAGS) -DATARI -DREADLINE -DPIPES
TERMFLAGS =

# where to place gnuplot.gih helpfile
# if this is an absolute pathname, shel_find will not be used.
HELPFILE=gnuplot.gih

# -------------------- end of configuration section -------------------------

OBJS = 	bitmap.o command.o contour.o eval.o graphics.o graph3d.o gnubin.o\
	help.o internal.o misc.o parse.o plot.o readline.o scanner.o\
	setshow.o specfun.o standard.o term.o util.o version.o binary.o

# path prefix for the term subdirectory
TERM=term$(SL)

TERMS = $(TERM)atari.trm $(TERM)dumb.trm $(TERM)eepic.trm $(TERM)epson.trm \
	$(TERM)hpgl.trm $(TERM)hpljii.trm $(TERM)hppj.trm $(TERM)latex.trm \
	$(TERM)pbm.trm $(TERM)post.trm $(TERM)texdraw.trm

all: gnuplot.ttp $(HELPFILE) demo$(SL)bf_test.tos

gnuplot.ttp: $(OBJS)
	$(CC) -o $@ $(OBJS) -lpml -lgem
	fixstk 80k $@
#	strip -k $@		# you might want to add strip here

# to run the bivariat demo ca. 75k stack is needed, all others work with ca. 32k

# default rules

%.o: %.c
	$(CC) -o $@ $(CFLAGS) $<

# dependencies

bitmap.o: bitmap.c bitmap.h plot.h

binary.o: binary.c plot.h

command.o: command.c plot.h setshow.h help.h
	$(CC) -o $@ $(CFLAGS) -DHELPFILE=\"$(HELPFILE)\" $<

contour.o: contour.c plot.h

eval.o: eval.c plot.h

graphics.o: graphics.c plot.h setshow.h

graph3d.o: graph3d.c plot.h setshow.h

gnubin.o: gnubin.c plot.h setshow.h

help.o: help.c help.h

internal.o: internal.c plot.h

misc.o: misc.c plot.h setshow.h help.h

parse.o: parse.c plot.h

plot.o: plot.c plot.h setshow.h
 
readline.o: readline.c

scanner.o: scanner.c plot.h

setshow.o: setshow.c plot.h setshow.h

specfun.o: plot.h specfun.c

standard.o: standard.c plot.h

term.o: term.c term.h plot.h setshow.c bitmap.h $(TERMS)
	$(CC) -o $@ $(CFLAGS) $(TERMFLAGS) -Iterm term.c

util.o: util.c plot.h

version.o: version.c

# convert gnuplot.doc to gnuplot.gih
$(HELPFILE): doc2gih docs$(SL)gnuplot.doc
	doc2gih docs$(SL)gnuplot.doc $(HELPFILE)

doc2gih: docs$(SL)doc2gih.c
	$(HOSTCC) -o doc2gih docs$(SL)doc2gih.c

demo$(SL)bf_test.tos: bf_test.o binary.o
	$(CC) -s -o $@ bf_test.o binary.o -lpml

clean:			# remove temporary files, but leave executable intact
	rm -f $(OBJS) bf_test.o doc2gih

realclean: clean	# remove all files generated by make
	rm -f gnuplot.ttp gnuplot.gih demo$(SL)binary1 demo$(SL)binary2
	rm -f demo$(SL)binary3 demo$(SL)bf_test.tos

# empty rules for file extensions (some makes might need this)
%.trm:

%.doc:

