/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.ietf.jgss.GSSException;
import sun.security.jgss.krb5.InitialToken;
import sun.security.jgss.krb5.Krb5Context;
import sun.security.jgss.krb5.Krb5CredElement;
import sun.security.jgss.krb5.Krb5InitCredential;
import sun.security.jgss.krb5.Krb5NameElement;
import sun.security.jgss.krb5.Krb5Token;
import sun.security.krb5.Checksum;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbApReq;
import sun.security.krb5.KrbException;
import sun.security.util.DerValue;

class InitSecContextToken
extends InitialToken {
    private KrbApReq apReq = null;

    public InitSecContextToken(Krb5Context krb5Context, Credentials credentials, Credentials credentials2) throws KrbException, IOException, GSSException {
        boolean bl2 = krb5Context.getMutualAuthState();
        boolean bl3 = true;
        boolean bl4 = true;
        InitialToken.OverloadedChecksum overloadedChecksum = new InitialToken.OverloadedChecksum((InitialToken)this, krb5Context, credentials, credentials2);
        Checksum checksum = overloadedChecksum.getChecksum();
        this.apReq = new KrbApReq(credentials2, bl2, bl3, bl4, checksum);
        krb5Context.resetMySequenceNumber(this.apReq.getSeqNumber());
        EncryptionKey encryptionKey = this.apReq.getSubKey();
        if (encryptionKey != null) {
            krb5Context.setKey(encryptionKey);
        } else {
            krb5Context.setKey(credentials2.getSessionKey());
        }
        if (!bl2) {
            krb5Context.resetPeerSequenceNumber(0);
        }
    }

    public InitSecContextToken(Krb5Context krb5Context, EncryptionKey encryptionKey, InputStream inputStream) throws IOException, GSSException, KrbException {
        Serializable serializable;
        int n2 = inputStream.read() << 8 | inputStream.read();
        if (n2 != 256) {
            throw new GSSException(10, -1, "AP_REQ token id does not match!");
        }
        byte[] byArray = new DerValue(inputStream).toByteArray();
        this.apReq = new KrbApReq(byArray, encryptionKey);
        EncryptionKey encryptionKey2 = this.apReq.getCreds().getSessionKey();
        EncryptionKey encryptionKey3 = this.apReq.getSubKey();
        if (encryptionKey3 != null) {
            krb5Context.setKey(encryptionKey3);
        } else {
            krb5Context.setKey(encryptionKey2);
        }
        InitialToken.OverloadedChecksum overloadedChecksum = new InitialToken.OverloadedChecksum((InitialToken)this, krb5Context, this.apReq.getChecksum(), encryptionKey2);
        overloadedChecksum.setContextFlags(krb5Context);
        Credentials credentials = overloadedChecksum.getDelegatedCreds();
        if (credentials != null) {
            serializable = Krb5InitCredential.getInstance((Krb5NameElement)krb5Context.getSrcName(), credentials);
            krb5Context.setDelegCred((Krb5CredElement)((Object)serializable));
        }
        int n3 = (serializable = this.apReq.getSeqNumber()) != null ? (Integer)serializable : 0;
        krb5Context.resetPeerSequenceNumber(n3);
        if (!krb5Context.getMutualAuthState()) {
            krb5Context.resetMySequenceNumber(n3);
        }
    }

    public InitSecContextToken(Krb5Context krb5Context, EncryptionKey encryptionKey, byte[] byArray, int n2, int n3) throws IOException, GSSException, KrbException {
        this(krb5Context, encryptionKey, new ByteArrayInputStream(byArray, n2, n3));
    }

    public final KrbApReq getKrbApReq() {
        return this.apReq;
    }

    public final byte[] encode() throws IOException {
        byte[] byArray = this.apReq.getMessage();
        byte[] byArray2 = new byte[2 + byArray.length];
        Krb5Token.writeInt(256, byArray2, 0);
        System.arraycopy(byArray, 0, byArray2, 2, byArray.length);
        return byArray2;
    }
}

