/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.GeneralNameInterface;

public class EDIPartyName
implements GeneralNameInterface {
    private static final byte TAG_ASSIGNER = 0;
    private static final byte TAG_PARTYNAME = 1;
    private String assigner = null;
    private String party = null;

    public EDIPartyName(String string, String string2) {
        this.assigner = string;
        this.party = string2;
    }

    public EDIPartyName(String string) {
        this.party = string;
    }

    public EDIPartyName(DerValue derValue) throws IOException {
        DerInputStream derInputStream = new DerInputStream(derValue.toByteArray());
        DerValue[] derValueArray = derInputStream.getSequence(2);
        int n2 = derValueArray.length;
        if (n2 < 1 || n2 > 2) {
            throw new IOException("Invalid encoding of EDIPartyName");
        }
        int n3 = 0;
        while (n3 < n2) {
            DerValue derValue2 = derValueArray[n3];
            if (derValue2.isContextSpecific((byte)0) && !derValue2.isConstructed()) {
                if (this.assigner != null) {
                    throw new IOException("Duplicate nameAssigner found in EDIPartyName");
                }
                derValue2 = derValue2.data.getDerValue();
                this.assigner = derValue2.getAsString();
            }
            if (derValue2.isContextSpecific((byte)1) && !derValue2.isConstructed()) {
                if (this.party != null) {
                    throw new IOException("Duplicate partyName found in EDIPartyName");
                }
                derValue2 = derValue2.data.getDerValue();
                this.party = derValue2.getAsString();
            }
            ++n3;
        }
    }

    public int getType() {
        return 5;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerOutputStream derOutputStream3 = new DerOutputStream();
        if (this.assigner != null) {
            DerOutputStream derOutputStream4 = new DerOutputStream();
            derOutputStream4.putPrintableString(this.assigner);
            derOutputStream2.write(DerValue.createTag((byte)-128, false, (byte)0), derOutputStream4);
        }
        if (this.party == null) {
            throw new IOException("Cannot have null partyName");
        }
        derOutputStream3.putPrintableString(this.party);
        derOutputStream2.write(DerValue.createTag((byte)-128, false, (byte)1), derOutputStream3);
        derOutputStream.write((byte)48, derOutputStream2);
    }

    public String getAssignerName() {
        return this.assigner;
    }

    public String getPartyName() {
        return this.party;
    }

    public boolean equals(Object object) {
        if (!(object instanceof EDIPartyName)) {
            return false;
        }
        String string = ((EDIPartyName)object).assigner;
        if (this.assigner == null ? string != null : !this.assigner.equals(string)) {
            return false;
        }
        String string2 = ((EDIPartyName)object).party;
        return !(this.party == null ? string2 != null : !this.party.equals(string2));
    }

    public String toString() {
        return "EDIPartyName: " + (this.assigner == null ? "" : "  nameAssigner = " + this.assigner + ",") + "  partyName = " + this.party;
    }

    public int constrains(GeneralNameInterface generalNameInterface) throws UnsupportedOperationException {
        int n2;
        if (generalNameInterface == null) {
            n2 = -1;
        } else if (generalNameInterface.getType() != 5) {
            n2 = -1;
        } else {
            throw new UnsupportedOperationException("Narrowing, widening, and matching of names not supported for EDIPartyName");
        }
        return n2;
    }

    public int subtreeDepth() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("subtreeDepth() not supported for EDIPartyName");
    }
}

