.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.\" $XFree86: xc/doc/man/X11/XIcWin.man,v 1.3 2001/02/09 03:47:45 tsi Exp $
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH XIconifyWindow 3X11 __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XIconifyWindow, XWithdrawWindow, XReconfigureWMWindow \- manipulate top-level windows
.SH SYNTAX
Status XIconifyWindow\^(\^\fIdisplay\fP, \fIw\fP, \fIscreen_number\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Window \fIw\fP;
.br
      int \fIscreen_number\fP\^;
.LP
Status XWithdrawWindow\^(\^\fIdisplay\fP, \fIw\fP, \fIscreen_number\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Window \fIw\fP\^;
.br
      int \fIscreen_number\fP\^;
.LP
Status XReconfigureWMWindow\^(\^\fIdisplay\fP, \fIw\fP, \fIscreen_number\fP,
\fIvalue_mask\fP, \fIvalues\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Window \fIw\fP\^;
.br
      int \fIscreen_number\fP\^;
.br
      unsigned int \fIvalue_mask\fP\^;
.br
      XWindowChanges *\fIvalues\fP;
.SH ARGUMENTS
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIscreen_number\fP 1i
Specifies the appropriate screen number on the host server.
.IP \fIvalue_mask\fP 1i
Specifies which values are to be set using information in
the values structure.
This mask is the bitwise inclusive OR of the valid configure window values bits.
.IP \fIvalues\fP 1i
Specifies the 
.ZN XWindowChanges 
structure.
.IP \fIw\fP 1i
Specifies the window.
.SH DESCRIPTION
The 
.ZN XIconifyWindow 
function sends a WM_CHANGE_STATE 
.ZN ClientMessage 
event with a format of 32 and a first data element of 
.ZN IconicState 
(as described in section 4.1.4 of the 
\fIInter-Client Communication Conventions Manual\fP)
and a window of w
to the root window of the specified screen
with an event mask set to
.ZN SubstructureNotifyMask |
.ZN SubstructureRedirectMask .
Window managers may elect to receive this message and
if the window is in its normal state, 
may treat it as a request to change the window's state from normal to iconic.
If the WM_CHANGE_STATE property cannot be interned, 
.ZN XIconifyWindow
does not send a message and returns a zero status.
It returns a nonzero status if the client message is sent successfully;
otherwise, it returns a zero status.
.LP
The 
.ZN XWithdrawWindow 
function unmaps the specified window 
and sends a synthetic 
.ZN UnmapNotify 
event to the root window of the specified screen.
Window managers may elect to receive this message 
and may treat it as a request to change the window's state to withdrawn.
When a window is in the withdrawn state, 
neither its normal nor its iconic representations is visible.
It returns a nonzero status if the 
.ZN UnmapNotify 
event is successfully sent; 
otherwise, it returns a zero status.
.LP
.ZN XWithdrawWindow
can generate a
.ZN BadWindow
error.
.LP
The 
.ZN XReconfigureWMWindow 
function issues a 
.ZN ConfigureWindow 
request on the specified top-level window.
If the stacking mode is changed and the request fails with a 
.ZN BadMatch 
error, 
the error is trapped by Xlib and a synthetic 
.ZN ConfigureRequestEvent 
containing the same configuration parameters is sent to the root 
of the specified window.
Window managers may elect to receive this event 
and treat it as a request to reconfigure the indicated window.
It returns a nonzero status if the request or event is successfully sent;
otherwise, it returns a zero status.
.LP
.ZN XReconfigureWMWindow
can generate
.ZN BadValue
and
.ZN BadWindow
errors.
.SH DIAGNOSTICS
.TP 1i
.ZN BadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.  Any argument defined as a set of
alternatives can generate this error.
.TP 1i
.ZN BadWindow
A value for a Window argument does not name a defined Window.
.SH "SEE ALSO"
XChangeWindowAttributes(3X11),
XConfigureWindow(3X11),
XCreateWindow(3X11),
XDestroyWindow(3X11),
XRaiseWindow(3X11),
XMapWindow(3X11),
XUnmapWindow(3X11)
.br
\fI\*(xL\fP
