/* vi:set ts=8 sts=0 sw=8:
 * $Id: prefs.c,v 1.91 2001/01/01 20:18:09 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <ctype.h>
#ifdef HAVE_LOCALE_H
#include <locale.h>
#endif
#include <glib.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#ifndef GTK_HAVE_FEATURES_1_1_0
#include "gtkfontsel.h"
#endif
#include "main.h"
#include "menu.h"
#include "file.h"
#include "dialog.h"
#include "win.h"
#include "msgbar.h"
#include "msgbox.h"
#include "toolbar.h"
#ifdef WANT_PROJECT
#include "prjbar.h"
#endif
#include "misc.h"
#include "randomtips.h"
#include "srcctrl.h"
#include "prefs.h"
#include "prefs_private.h"
#ifndef USE_LIBGLADE
# include "prefs_noglade.h"
#endif
#ifndef USE_GNOME
# include "prefs_nognome.h"
#endif

#include "gnpintl.h"


/*** global variables ***/
app_prefs_t prefs;


/*** local definitions ***/
#define GLADE_FILE	"gnotepad+.glade"
#define PREFS_NAME_LEN	32		/* max len for pref name in rc file */
#define PREFS_DIR	".gnp"		/* should be in $HOME */
#define APPRC		"apprc"		/* stores app-specific prefs */
#define APPGTKRC	"appgtkrc"	/* stores app-specific GTK prefs */
#define GTKRC		"gtkrc"		/* stores gtk-related prefs */
#define SESSIONRC	"sessionrc"	/* stores files open in last session */
#define MAX_FONT_LEN	MAXPATH
#define DEFAULT_FONT	"-adobe-courier-medium-r-normal-*-*-120-*-*-m-*-iso8859-1"
#ifdef HAVE_SETLOCALE
#define DEFAULT_FONTSET	"-*-*-medium-r-normal-*-14-*-*-*-*-*-*-*,*"
#endif

typedef enum {
	PrefBool,	/* its boolean, but the variable must be a "long" */
	PrefString,	/* (char *) */
	PrefInt		/* int or uint */
} ptype_t;

/*
 * f: callback used when updating prefs (typically, win_foreach()).
 * c: callback data function passed to f().
 */
typedef struct {
	char *	name;	/* pref name */
	ptype_t	type;	/* pref type */
	void * 	addr;	/* address of data value */
	long	min;	/* min size/len/value */
	long	max;	/* max size/length/value */
	gulong	val;	/* multi-purpose value.  currently used for */
			/* max string len and boolean bit flags */
	void	(*f)(void (*g)(void *));
	void 	(*c)(void *);
} prefs_t;


/*** local variables ***/
static bool_t		pre102 = FALSE;	/* using gnp+ before v1.0.2 */

char *			appgtkrc = NULL;	/* app specific gtk rc */


#ifdef USE_SOURCE_CTRL

#define SCC_CCASE_CI_L		"scc_ccase_ci_l"
#define SCC_CCASE_CI_U		"scc_ccase_ci_u"
#define SCC_CCASE_CI_I		"scc_ccase_ci_i"
#define SCC_CCASE_CO_U		"scc_ccase_co_u"
#define SCC_CCASE_CO_L		"scc_ccase_co_l"
#define SCC_CCASE_UNDO		"scc_ccase_undo"
#define SCC_CCASE_REV		"scc_ccase_rev"
#define SCC_PFORCE_CI_L		"scc_pforce_ci_l"
#define SCC_PFORCE_CI_U		"scc_pforce_ci_u"
#define SCC_PFORCE_CI_I		"scc_pforce_ci_i"
#define SCC_PFORCE_CO_U		"scc_pforce_co_u"
#define SCC_PFORCE_CO_L		"scc_pforce_co_l"
#define SCC_PFORCE_UNDO		"scc_pforce_undo"
#define SCC_PFORCE_REV		"scc_pforce_rev"
#define SCC_PVCS_CI_L		"scc_pvcs_ci_l"
#define SCC_PVCS_CI_U		"scc_pvcs_ci_u"
#define SCC_PVCS_CI_I		"scc_pvcs_ci_i"
#define SCC_PVCS_CO_U		"scc_pvcs_co_u"
#define SCC_PVCS_CO_L		"scc_pvcs_co_l"
#define SCC_PVCS_UNDO		"scc_pvcs_undo"
#define SCC_PVCS_REV		"scc_pvcs_rev"
#define SCC_RCS_CI_L		"scc_rcs_ci_l"
#define SCC_RCS_CI_U		"scc_rcs_ci_u"
#define SCC_RCS_CI_I		"scc_rcs_ci_i"
#define SCC_RCS_CO_U		"scc_rcs_co_u"
#define SCC_RCS_CO_L		"scc_rcs_co_l"
#define SCC_RCS_UNDO		"scc_rcs_undo"
#define SCC_RCS_REV		"scc_rcs_rev"
#define SCC_SCCS_CI_L		"scc_sccs_ci_l"
#define SCC_SCCS_CI_U		"scc_sccs_ci_u"
#define SCC_SCCS_CI_I		"scc_sccs_ci_i"
#define SCC_SCCS_CO_U		"scc_sccs_co_u"
#define SCC_SCCS_CO_L		"scc_sccs_co_l"
#define SCC_SCCS_UNDO		"scc_sccs_undo"
#define SCC_SCCS_REV		"scc_sccs_rev"
#define SCC_TLIB_CI_L		"scc_tlib_ci_l"
#define SCC_TLIB_CI_U		"scc_tlib_ci_u"
#define SCC_TLIB_CI_I		"scc_tlib_ci_i"
#define SCC_TLIB_CO_U		"scc_tlib_co_u"
#define SCC_TLIB_CO_L		"scc_tlib_co_l"
#define SCC_TLIB_UNDO		"scc_tlib_undo"
#define SCC_TLIB_REV		"scc_tlib_rev"
#define SCC_USER_CI_L		"scc_user_ci_l"
#define SCC_USER_CI_U		"scc_user_ci_u"
#define SCC_USER_CI_I		"scc_user_ci_i"
#define SCC_USER_CO_U		"scc_user_co_u"
#define SCC_USER_CO_L		"scc_user_co_l"
#define SCC_USER_UNDO		"scc_user_undo"
#define SCC_USER_REV		"scc_user_rev"

scc_info_t scc_tbl[SCC_NUM_TYPES] = {
	{	/* SCC_RCS */
		"RCS",
		{
			{ SCC_RCS_CI_L, "ci -q -l -m$s $F" },
			{ SCC_RCS_CI_U, "ci -q -m$s $F" },
			{ SCC_RCS_CI_I, "ci -q -l -t- -m$s $F" },
			{ SCC_RCS_CO_U, "co -q $F" },
			{ SCC_RCS_CO_L, "co -q -l $F" },
			{ SCC_RCS_UNDO, "rcs -q -u $F" },
			{ SCC_RCS_REV,  "rlog $F" }
		}
	},
	{	/* SCC_SCCS */
		"SCCS",
		{
			{ SCC_SCCS_CI_L, "sccs deledit -y$s $F" },
			{ SCC_SCCS_CI_U, "sccs delget -y$s $F" },
			{ SCC_SCCS_CI_I, "sccs create -y$s $F" },
			{ SCC_SCCS_CO_U, "sccs get $F" },
			{ SCC_SCCS_CO_L, "sccs edit $F" },
			{ SCC_SCCS_UNDO, "sccs unedit $F" },
			{ SCC_SCCS_REV,  "sccs prs $F" }
		}
	},
	{	/* SCC_CCASE */
		N_("Clear Case"),
		{
			{ SCC_CCASE_CI_L, "cleartool checkin -c $s $F" },
			{ SCC_CCASE_CI_U, "cleartool checkin -c $s $F" },
			{ SCC_CCASE_CI_I, "cleartool mkelem -c $F" },
			{ SCC_CCASE_CO_U, "cleartool checkout -nc $F" },
			{ SCC_CCASE_CO_L, "cleartool checkout -nc $F" },
			{ SCC_CCASE_UNDO, "cleartool uncheckout -rm $F" },
			{ SCC_CCASE_REV,
			  "cleartool lshistory -fmt \"%Sd %u %Nc\\n\" $F" }
		}
	},
	{	/* SCC_PFORCE */
		N_("Perforce"),
		{
			{ SCC_PFORCE_CI_L, "p4 submit $F" },
			{ SCC_PFORCE_CI_U, "p4 submit $F" },
			{ SCC_PFORCE_CI_I, "p4 add $F" },
			{ SCC_PFORCE_CO_U, "p4 edit $F" },
			{ SCC_PFORCE_CO_L, "p4 edit $F" },
			{ SCC_PFORCE_UNDO, "p4 revert $F" },
			{ SCC_PFORCE_REV,  "p4 filelog $F" }
		}
	},
	{	/* SCC_PVCS */
		"PVCS",
		{
			{ SCC_PVCS_CI_L, "put -n -l$F" },
			{ SCC_PVCS_CI_U, "put -n $F" },
			{ SCC_PVCS_CI_I, "put -n $F" },
			{ SCC_PVCS_CO_U, "put -y $F" },
			{ SCC_PVCS_CO_L, "put -y -l$F" },
			{ SCC_PVCS_UNDO, "vcs -u $F" },
			{ SCC_PVCS_REV,  "vlog -b $F" }
		}
	},
	{	/* SCC_TLIB */
		"TLIB",
		{
			{ SCC_TLIB_CI_L, "tlib U $F" },
			{ SCC_TLIB_CI_U, "tlib K $F" },
			{ SCC_TLIB_CI_I, "tlib K $F" },
			{ SCC_TLIB_CO_U, "tlib B $F" },
			{ SCC_TLIB_CO_L, "tlib E $F" },
			{ SCC_TLIB_UNDO, NULL },
			{ SCC_TLIB_REV,  "tlib L $F" }
		}
	},
	{	/* SCC_USER */
		N_("User Defined"),
		{
			{ SCC_USER_CI_L, NULL },
			{ SCC_USER_CI_U, NULL },
			{ SCC_USER_CI_I, NULL },
			{ SCC_USER_CO_U, NULL },
			{ SCC_USER_CO_L, NULL },
			{ SCC_USER_UNDO, NULL },
			{ SCC_USER_REV,  NULL }
		}
	}
}; /* scc_tbl */
#endif	/* USE_SOURCE_CTRL */


/*
 * to add a new configurable preference option:
 *
 * 1. declare a global variable up in the "global variables" section.  make
 * sure that it's one of the following types: int, bool, float, short, or
 * "char *".
 *
 * 2. add a corresponding entry below into the variable 'app_prefs'.  your best
 * bet is to just cut and paste an existing entry and see how it works.  keep
 * the entries in alphabetical order.
 *
 * 3. create and add the necessary widgets into the Preferences window popup
 * dialog.  the most commonly used ones are a button and a text entry.  be sure
 * to add these widgets into the wgtopt_list.  see one of the existing routines
 * as an example (e.g., prefs_frame_toolbar_create()).
 *
 *
 * i know this setup may not be easiest way for another developer to use.  for
 * example, ideally one would like to do something such as the following:
 *
 *	prefs_set_data("doc_tab_position", "top");
 *	prefs_get_data("print_command", buf);
 *
 * however, the big downside to this is that when getting data, you need
 * routines to translate the values *ANYWAY*.  in other words, every time you
 * successfully get data, you still have to determing *what* that data is and
 * *how* it affects preferences.  for instance, if data is supposed to
 * represent an integer, you'd have to then convert it to an integer and
 * determine what to do.
 *
 * so although the prefs_set_data() and prefs_get_data() looks nice on the
 * outside, you still have to write a whole bunch of code to figure out what do
 * with it once you've gotten it.  the tabular method that i'm using
 * effectively puts the "what", "how", and "where" into the table itself.  so
 * all you have to do is specify it ONCE, and the routines that manipulate the
 * table will take care of it so you don't have to.
 *
 * the prefs_set_data() and prefs_get_data() technique may work well if it were
 * provided as a library (e.g., Gnome does this), but since this part of the
 * code is not intended to be a library, (i think) the tabular method is
 * better.
 */
/*
 * XXX - we can probably get rid of the callback function (and its callback
 * data function) since most of the prefs don't use them.  Instead, for the
 * ones that do, it should set a static flag (within this file) to indicate
 * the action it wants to take.  The flags should represent these actions:
 *
 *	win_autosave_reset
 *	random_tips_reset
 *	win_redraw_doc_tab
 *	prjbar_redraw
 *	msgbar_redraw
 *	tb_redraw
 *
 *	doc_tab_stop_set,
 *	doc_redraw
 *
 * When the preferences are going to be applied, win_foreach (or in the last
 * two cases, win_doc_foreach) will be called, passing the common function as
 * the callback data function.  That common function will check each individual
 * flag, and if the flag is set, invoke the corresponding function.
 */
static prefs_t		app_prefs[] = {
#if defined(USE_TOOLBARS) && defined(USE_HTMLTAGS)
	{ "advanced_html_tb",
		PrefBool,
		&prefs.options1,
		0, 1, ADVANCED_HTML_TB,
		NULL_CALLBACK, NULL,
	},
#endif
#ifdef USE_AUTO_INDENT
	{ "auto_indent",
		PrefBool,
		&prefs.options1,
		0, 1, AUTO_INDENT,
		NULL_CALLBACK, NULL,
	},
#endif
#ifdef USE_AUTOSAVE
	{ "autosave_timeout",
		PrefInt,
		&prefs.autosave,
		0, 1440, 0,
		win_foreach,
		win_autosave_reset,
	},
#endif	/* USE_AUTOSAVE */
#ifdef USE_BACKUP
	{ "backupdir",
		PrefString,
		&prefs.backupdir,
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ "backupsuffix",
		PrefString,
		&prefs.backupsuffix,
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ "do_backup",
		PrefBool,
		&prefs.options1,
		0, 1, DO_BACKUP,
		NULL_CALLBACK, NULL,
	},
#endif	/* USE_BACKUP */
	{ "doc_tab_position",
		PrefInt,
		&prefs.tabpos,
		0, 3, 0,
		NULL_CALLBACK, NULL,
	},
	/*
	 * the next four settings (doc_tabs_{bottom,left,right,top}) are for
	 * doc tabs.  however, they should NOT appear in the prefs dialog
	 * because the doc tab positioning is handled by the previous prefs
	 * setting (doc_tab_position).  these are bit fields/options, and are
	 * needed to determine what state the menu toggle/radio buttons are
	 * currently in and what new settings they will take on.
	 */
	{ "doc_tabs_bottom",
		PrefBool,
		&prefs.options1,
		0, 1, DOC_TABS_BOTTOM,
		NULL_CALLBACK, NULL,
	},
	{ "doc_tabs_left",
		PrefBool,
		&prefs.options1,
		0, 1, DOC_TABS_LEFT,
		NULL_CALLBACK, NULL,
	},
	{ "doc_tabs_right",
		PrefBool,
		&prefs.options1,
		0, 1, DOC_TABS_RIGHT,
		NULL_CALLBACK, NULL,
	},
	{ "doc_tabs_top",
		PrefBool,
		&prefs.options1,
		0, 1, DOC_TABS_TOP,
		NULL_CALLBACK, NULL,
	},
#ifdef WANT_SESSION
	{ "enable_session",
		PrefBool,
		&prefs.options1,
		0, 1, ENABLE_SESSION,
		NULL_CALLBACK, NULL,
	},
#endif
#ifdef USE_TOOLBARS
# ifdef USE_HTMLTAGS
	/*
	 * Start of the options for the HTML Font toolbar
	 */
	{ HTML_FONT_TB_STR_BIG,
		PrefBool,
		&prefs.html_font_tb_opt1,
		0, 1, SHOW_HTML_FONT_BIG,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FONT_TB_STR_BOLD,
		PrefBool,
		&prefs.html_font_tb_opt1,
		0, 1, SHOW_HTML_FONT_BOLD,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FONT_TB_STR_EMPH,
		PrefBool,
		&prefs.html_font_tb_opt1,
		0, 1, SHOW_HTML_FONT_EMPH,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FONT_TB_STR_FONTM1,
		PrefBool,
		&prefs.html_font_tb_opt1,
		0, 1, SHOW_HTML_FONT_FONTM1,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FONT_TB_STR_FONTP1,
		PrefBool,
		&prefs.html_font_tb_opt1,
		0, 1, SHOW_HTML_FONT_FONTP1,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FONT_TB_STR_H1,
		PrefBool,
		&prefs.html_font_tb_opt1,
		0, 1, SHOW_HTML_FONT_H1,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FONT_TB_STR_H2,
		PrefBool,
		&prefs.html_font_tb_opt1,
		0, 1, SHOW_HTML_FONT_H2,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FONT_TB_STR_H3,
		PrefBool,
		&prefs.html_font_tb_opt1,
		0, 1, SHOW_HTML_FONT_H3,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FONT_TB_STR_H4,
		PrefBool,
		&prefs.html_font_tb_opt1,
		0, 1, SHOW_HTML_FONT_H4,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FONT_TB_STR_H5,
		PrefBool,
		&prefs.html_font_tb_opt1,
		0, 1, SHOW_HTML_FONT_H5,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FONT_TB_STR_H6,
		PrefBool,
		&prefs.html_font_tb_opt1,
		0, 1, SHOW_HTML_FONT_H6,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FONT_TB_STR_ITAL,
		PrefBool,
		&prefs.html_font_tb_opt1,
		0, 1, SHOW_HTML_FONT_ITAL,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FONT_TB_STR_PRE,
		PrefBool,
		&prefs.html_font_tb_opt1,
		0, 1, SHOW_HTML_FONT_PRE,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FONT_TB_STR_SMLL,
		PrefBool,
		&prefs.html_font_tb_opt1,
		0, 1, SHOW_HTML_FONT_SMLL,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FONT_TB_STR_STRG,
		PrefBool,
		&prefs.html_font_tb_opt1,
		0, 1, SHOW_HTML_FONT_STRG,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FONT_TB_STR_STRK,
		PrefBool,
		&prefs.html_font_tb_opt1,
		0, 1, SHOW_HTML_FONT_STRK,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FONT_TB_STR_SUB,
		PrefBool,
		&prefs.html_font_tb_opt1,
		0, 1, SHOW_HTML_FONT_SUB,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FONT_TB_STR_SUP,
		PrefBool,
		&prefs.html_font_tb_opt1,
		0, 1, SHOW_HTML_FONT_SUP,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FONT_TB_STR_TTY,
		PrefBool,
		&prefs.html_font_tb_opt1,
		0, 1, SHOW_HTML_FONT_TTY,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FONT_TB_STR_ULNE,
		PrefBool,
		&prefs.html_font_tb_opt1,
		0, 1, SHOW_HTML_FONT_ULNE,
		NULL_CALLBACK, NULL,
	},
	/*
	 * Start of the options for the HTML Forms toolbar
	 */
	{ HTML_FORM_STR_BUTTON,
		PrefBool,
		&prefs.html_form_tb_opt1,
		0, 1, SHOW_HTML_FORM_BUTTON,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FORM_STR_CHECK,
		PrefBool,
		&prefs.html_form_tb_opt1,
		0, 1, SHOW_HTML_FORM_CHECK,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FORM_STR_IMAGE,
		PrefBool,
		&prefs.html_form_tb_opt1,
		0, 1, SHOW_HTML_FORM_IMAGE,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FORM_STR_NEW,
		PrefBool,
		&prefs.html_form_tb_opt1,
		0, 1, SHOW_HTML_FORM_NEW,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FORM_STR_OPT,
		PrefBool,
		&prefs.html_form_tb_opt1,
		0, 1, SHOW_HTML_FORM_OPT,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FORM_STR_PASS,
		PrefBool,
		&prefs.html_form_tb_opt1,
		0, 1, SHOW_HTML_FORM_PASS,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FORM_STR_RADIO,
		PrefBool,
		&prefs.html_form_tb_opt1,
		0, 1, SHOW_HTML_FORM_RADIO,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FORM_STR_RESET,
		PrefBool,
		&prefs.html_form_tb_opt1,
		0, 1, SHOW_HTML_FORM_RESET,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FORM_STR_SEL,
		PrefBool,
		&prefs.html_form_tb_opt1,
		0, 1, SHOW_HTML_FORM_SEL,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FORM_STR_SUBMIT,
		PrefBool,
		&prefs.html_form_tb_opt1,
		0, 1, SHOW_HTML_FORM_SUBMIT,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FORM_STR_TAREA,
		PrefBool,
		&prefs.html_form_tb_opt1,
		0, 1, SHOW_HTML_FORM_TAREA,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FORM_STR_TFIELD,
		PrefBool,
		&prefs.html_form_tb_opt1,
		0, 1, SHOW_HTML_FORM_TFIELD,
		NULL_CALLBACK, NULL,
	},
	/*
	 * Start of the options for the HTML Frame toolbar
	 */
	{ HTML_FRAME_STR_BASE,
		PrefBool,
		&prefs.html_frame_tb_opt1,
		0, 1, SHOW_HTML_FRAME_BASE,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FRAME_STR_NEW,
		PrefBool,
		&prefs.html_frame_tb_opt1,
		0, 1, SHOW_HTML_FRAME_NEW,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FRAME_STR_NEW2,
		PrefBool,
		&prefs.html_frame_tb_opt1,
		0, 1, SHOW_HTML_FRAME_NEW2,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FRAME_STR_NO,
		PrefBool,
		&prefs.html_frame_tb_opt1,
		0, 1, SHOW_HTML_FRAME_NO,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FRAME_STR_SET,
		PrefBool,
		&prefs.html_frame_tb_opt1,
		0, 1, SHOW_HTML_FRAME_SET,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FRAME_STR_SET2,
		PrefBool,
		&prefs.html_frame_tb_opt1,
		0, 1, SHOW_HTML_FRAME_SET2,
		NULL_CALLBACK, NULL,
	},
	{ HTML_FRAME_STR_WIZ,
		PrefBool,
		&prefs.html_frame_tb_opt1,
		0, 1, SHOW_HTML_FRAME_WIZ,
		NULL_CALLBACK, NULL,
	},
	/*
	 * Start of the options for the HTML List toolbar
	 */
	{ HTML_LIST_TB_STR_DEF,
		PrefBool,
		&prefs.html_list_tb_opt1,
		0, 1, SHOW_HTML_LIST_DEF,
		NULL_CALLBACK, NULL,
	},
	{ HTML_LIST_TB_STR_DLIST,
		PrefBool,
		&prefs.html_list_tb_opt1,
		0, 1, SHOW_HTML_LIST_DLIST,
		NULL_CALLBACK, NULL,
	},
	{ HTML_LIST_TB_STR_DTERM,
		PrefBool,
		&prefs.html_list_tb_opt1,
		0, 1, SHOW_HTML_LIST_DTERM,
		NULL_CALLBACK, NULL,
	},
	{ HTML_LIST_TB_STR_LITM,
		PrefBool,
		&prefs.html_list_tb_opt1,
		0, 1, SHOW_HTML_LIST_LITM,
		NULL_CALLBACK, NULL,
	},
	{ HTML_LIST_TB_STR_MENU,
		PrefBool,
		&prefs.html_list_tb_opt1,
		0, 1, SHOW_HTML_LIST_MENU,
		NULL_CALLBACK, NULL,
	},
	{ HTML_LIST_TB_STR_ORDR,
		PrefBool,
		&prefs.html_list_tb_opt1,
		0, 1, SHOW_HTML_LIST_ORDR,
		NULL_CALLBACK, NULL,
	},
	{ HTML_LIST_TB_STR_UORD,
		PrefBool,
		&prefs.html_list_tb_opt1,
		0, 1, SHOW_HTML_LIST_UORD,
		NULL_CALLBACK, NULL,
	},

	{ "html_tag_lower",
		PrefBool,
		&prefs.options1,
		0, 1, HTML_TAG_LOWER,
		NULL_CALLBACK, NULL,
	},
	{ "html_tag_upper",
		PrefBool,
		&prefs.options1,
		0, 1, HTML_TAG_UPPER,
		NULL_CALLBACK, NULL,
	},

	/*
	 * Start of the options for the HTML Main toolbar
	 */
	{ HTML_TB_STR_BIG,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_BIG,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_BOLD,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_BOLD,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_CENT,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_CENT,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_CMNT,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_CMNT,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_DEF,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_DEF,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_DLIST,
		PrefBool,
		&prefs.html_tb_opt2,
		0, 1, SHOW_HTML_DLIST,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_DTERM,
		PrefBool,
		&prefs.html_tb_opt2,
		0, 1, SHOW_HTML_DTERM,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_EMPH,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_EMPH,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_FONTM1,
		PrefBool,
		&prefs.html_tb_opt2,
		0, 1, SHOW_HTML_FONTM1,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_FONTP1,
		PrefBool,
		&prefs.html_tb_opt2,
		0, 1, SHOW_HTML_FONTP1,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_H1,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_H1,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_H2,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_H2,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_H3,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_H3,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_H4,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_H4,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_H5,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_H5,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_H6,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_H6,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_IMG,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_IMG,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_ITAL,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_ITAL,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_LBRK,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_LBRK,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_LEFT,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_LEFT,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_LINK,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_LINK,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_LITM,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_LITM,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_MENU,
		PrefBool,
		&prefs.html_tb_opt2,
		0, 1, SHOW_HTML_MENU,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_ORDR,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_ORDR,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_PARA,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_PARA,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_PRE,
		PrefBool,
		&prefs.html_tb_opt2,
		0, 1, SHOW_HTML_PRE,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_RGHT,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_RGHT,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_SEP,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_SEP,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_SMLL,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_SMLL,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_STRG,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_STRG,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_STRK,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_STRK,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_SUB,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_SUB,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_SUP,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_SUP,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_TARG,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_TARG,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_TTL,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_TTL,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_TTY,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_TTY,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_ULNE,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_ULNE,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TB_STR_UORD,
		PrefBool,
		&prefs.html_tb_opt1,
		0, 1, SHOW_HTML_UORD,
		NULL_CALLBACK, NULL,
	},
	/*
	 * Start of the options for the HTML Table toolbar
	 */
	{ HTML_TBL_TB_STR_DATA,
		PrefBool,
		&prefs.html_tbl_tb_opt1,
		0, 1, SHOW_HTML_TBL_DATA,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TBL_TB_STR_DATA2,
		PrefBool,
		&prefs.html_tbl_tb_opt1,
		0, 1, SHOW_HTML_TBL_DATA2,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TBL_TB_STR_HDR,
		PrefBool,
		&prefs.html_tbl_tb_opt1,
		0, 1, SHOW_HTML_TBL_HDR,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TBL_TB_STR_HDR2,
		PrefBool,
		&prefs.html_tbl_tb_opt1,
		0, 1, SHOW_HTML_TBL_HDR2,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TBL_TB_STR_NEW,
		PrefBool,
		&prefs.html_tbl_tb_opt1,
		0, 1, SHOW_HTML_TBL_NEW,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TBL_TB_STR_NEW2,
		PrefBool,
		&prefs.html_tbl_tb_opt1,
		0, 1, SHOW_HTML_TBL_NEW2,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TBL_TB_STR_ROW,
		PrefBool,
		&prefs.html_tbl_tb_opt1,
		0, 1, SHOW_HTML_TBL_ROW,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TBL_TB_STR_ROW2,
		PrefBool,
		&prefs.html_tbl_tb_opt1,
		0, 1, SHOW_HTML_TBL_ROW2,
		NULL_CALLBACK, NULL,
	},
	{ HTML_TBL_TB_STR_WIZ,
		PrefBool,
		&prefs.html_tbl_tb_opt1,
		0, 1, SHOW_HTML_TBL_WIZ,
		NULL_CALLBACK, NULL,
	},
# endif	/* USE_HTMLTAGS */
#if defined(USE_GTKXMHTML) || defined(USE_GTKHTML)
	{ "html_view_win_height",
		PrefInt,
		&prefs.html_view_h,
		0, 2048, 0,
		NULL_CALLBACK, NULL,
	},
	{ "html_view_win_width",
		PrefInt,
		&prefs.html_view_w,
		0, 2048, 0,
		NULL_CALLBACK, NULL,
	},
#endif
	/*
	 * Start of the options for the MAIN toolbar for the app
	 */
	{ MAIN_TB_STR_CLOSE,
		PrefBool,
		&prefs.main_tb_opt,
		0, 1, SHOW_MAIN_CLOSE,
		NULL_CALLBACK, NULL,
	},
	{ MAIN_TB_STR_COPY,
		PrefBool,
		&prefs.main_tb_opt,
		0, 1, SHOW_MAIN_COPY,
		NULL_CALLBACK, NULL,
	},
	{ MAIN_TB_STR_CUT,
		PrefBool,
		&prefs.main_tb_opt,
		0, 1, SHOW_MAIN_CUT,
		NULL_CALLBACK, NULL,
	},
	{ MAIN_TB_STR_EXIT,
		PrefBool,
		&prefs.main_tb_opt,
		0, 1, SHOW_MAIN_EXIT,
		NULL_CALLBACK, NULL,
	},
	{ MAIN_TB_STR_FIND,
		PrefBool,
		&prefs.main_tb_opt,
		0, 1, SHOW_MAIN_FIND,
		NULL_CALLBACK, NULL,
	},
	{ MAIN_TB_STR_FNEXT,
		PrefBool,
		&prefs.main_tb_opt,
		0, 1, SHOW_MAIN_FIND_NEXT,
		NULL_CALLBACK, NULL,
	},
	{ MAIN_TB_STR_NEW,
		PrefBool,
		&prefs.main_tb_opt,
		0, 1, SHOW_MAIN_NEW,
		NULL_CALLBACK, NULL,
	},
	{ MAIN_TB_STR_OPEN,
		PrefBool,
		&prefs.main_tb_opt,
		0, 1, SHOW_MAIN_OPEN,
		NULL_CALLBACK, NULL,
	},
	{ MAIN_TB_STR_PASTE,
		PrefBool,
		&prefs.main_tb_opt,
		0, 1, SHOW_MAIN_PASTE,
		NULL_CALLBACK, NULL,
	},
	{ MAIN_TB_STR_PREFS,
		PrefBool,
		&prefs.main_tb_opt,
		0, 1, SHOW_MAIN_PREFS,
		NULL_CALLBACK, NULL,
	},
	{ MAIN_TB_STR_PRINT,
		PrefBool,
		&prefs.main_tb_opt,
		0, 1, SHOW_MAIN_PRINT,
		NULL_CALLBACK, NULL,
	},
#ifdef GTK_HAVE_FEATURES_1_1_0
	{ MAIN_TB_STR_REDO,
		PrefBool,
		&prefs.main_tb_opt,
		0, 1, SHOW_MAIN_REDO,
		NULL_CALLBACK, NULL,
	},
#endif
	{ MAIN_TB_STR_REPLACE,
		PrefBool,
		&prefs.main_tb_opt,
		0, 1, SHOW_MAIN_REPLACE,
		NULL_CALLBACK, NULL,
	},
	{ MAIN_TB_STR_SAVE,
		PrefBool,
		&prefs.main_tb_opt,
		0, 1, SHOW_MAIN_SAVE,
		NULL_CALLBACK, NULL,
	},
#ifdef GTK_HAVE_FEATURES_1_1_0
	{ MAIN_TB_STR_UNDO,
		PrefBool,
		&prefs.main_tb_opt,
		0, 1, SHOW_MAIN_UNDO,
		NULL_CALLBACK, NULL,
	},
#endif
	{ MAIN_TB_STR_WINNEW,
		PrefBool,
		&prefs.main_tb_opt,
		0, 1, SHOW_MAIN_WINNEW,
		NULL_CALLBACK, NULL,
	},
	{ MAIN_TB_STR_WINCLOSE,
		PrefBool,
		&prefs.main_tb_opt,
		0, 1, SHOW_MAIN_WINCLOSE,
		NULL_CALLBACK, NULL,
	},
#endif	/* USE_TOOLBARS */
#ifdef USE_RECENT
	{ "max_num_recent",
		PrefInt,
		&prefs.maxrecent,
		0, 255, 0,
		NULL_CALLBACK, NULL,
	},
#endif	/* USE_RECENT */
#if defined(USE_UNDOREDO) && defined(GTK_HAVE_FEATURES_1_1_0)
	{ "max_undo",
		PrefInt,
		&prefs.maxundo,
		-1, 32768, 0,
		NULL_CALLBACK, NULL,
	},
#endif
#ifdef WANT_MSGBOX
	{ "msgbox_max_msg",
		PrefInt,
		&prefs.msgbox_max_msg,
		0, 32768, 0,
		NULL_CALLBACK, NULL,
	},
	{ "msgbox_per_del",
		PrefInt,
		&prefs.msgbox_per_del,
		0, 100, 0,
		NULL_CALLBACK, NULL,
	},
#endif  /* #ifdef WANT_MSGBOX */
	{ "print_command",
		PrefString,
		&prefs.printcmd,
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
#ifdef WANT_PROJECT
	{ "prj_list_height",
		PrefInt,
		&prefs.prjlist_h,
		0, 2048, 0,
		NULL_CALLBACK, NULL,
	},
	{ "prj_list_width",
		PrefInt,
		&prefs.prjlist_w,
		0, 2048, 0,
		NULL_CALLBACK, NULL,
	},
#endif
#ifdef USE_RANDOMTIPS
	{ "random_tips_delay",
		PrefInt,
		&prefs.random_tips,
		0, 86400, 0,
		win_foreach,
		random_tips_reset,
	},
#endif	/* USE_RANDOMTIPS */
	{ "read_buf_size",
		PrefInt,
		&prefs.read_size,
		0, 65536, 0,
		NULL_CALLBACK, NULL,
	},
	{ "save_win_height",
		PrefBool,
		&prefs.options1,
		0, 1, SAVE_WIN_HEIGHT,
		NULL_CALLBACK, NULL,
	},
	{ "save_win_pos",
		PrefBool,
		&prefs.options1,
		0, 1, SAVE_WIN_POS,
		NULL_CALLBACK, NULL,
	},
	{ "save_win_width",
		PrefBool,
		&prefs.options1,
		0, 1, SAVE_WIN_WIDTH,
		NULL_CALLBACK, NULL,
	},
#ifdef USE_SOURCE_CTRL
	/* Clear Case */
	{ SCC_CCASE_CI_L,
		PrefString,
		&prefs.scc[SCC_CCASE][SCC_CI_LOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_CCASE_CI_U,
		PrefString,
		&prefs.scc[SCC_CCASE][SCC_CI_UNLOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_CCASE_CI_I,
		PrefString,
		&prefs.scc[SCC_CCASE][SCC_CI_INIT],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_CCASE_CO_U,
		PrefString,
		&prefs.scc[SCC_CCASE][SCC_CO_UNLOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_CCASE_CO_L,
		PrefString,
		&prefs.scc[SCC_CCASE][SCC_CO_LOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_CCASE_UNDO,
		PrefString,
		&prefs.scc[SCC_CCASE][SCC_CO_UNDO],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_CCASE_REV,
		PrefString,
		&prefs.scc[SCC_CCASE][SCC_REVHIST],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	/* Perforce */
	{ SCC_PFORCE_CI_L, 
		PrefString,
		&prefs.scc[SCC_PFORCE][SCC_CI_LOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{  SCC_PFORCE_CI_U,
		PrefString,
		&prefs.scc[SCC_PFORCE][SCC_CI_UNLOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{  SCC_PFORCE_CI_I,
		PrefString,
		&prefs.scc[SCC_PFORCE][SCC_CI_INIT],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{  SCC_PFORCE_CO_U,
		PrefString,
		&prefs.scc[SCC_PFORCE][SCC_CO_UNLOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{  SCC_PFORCE_CO_L,
		PrefString,
		&prefs.scc[SCC_PFORCE][SCC_CO_LOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{  SCC_PFORCE_UNDO,
		PrefString,
		&prefs.scc[SCC_PFORCE][SCC_CO_UNDO],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{  SCC_PFORCE_REV,
		PrefString,
		&prefs.scc[SCC_PFORCE][SCC_REVHIST],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	/* PVCS */
	{ SCC_PVCS_CI_L, 
		PrefString,
		&prefs.scc[SCC_PVCS][SCC_CI_LOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{  SCC_PVCS_CI_U,
		PrefString,
		&prefs.scc[SCC_PVCS][SCC_CI_UNLOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{  SCC_PVCS_CI_I,
		PrefString,
		&prefs.scc[SCC_PVCS][SCC_CI_INIT],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{  SCC_PVCS_CO_U,
		PrefString,
		&prefs.scc[SCC_PVCS][SCC_CO_UNLOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{  SCC_PVCS_CO_L,
		PrefString,
		&prefs.scc[SCC_PVCS][SCC_CO_LOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{  SCC_PVCS_UNDO,
		PrefString,
		&prefs.scc[SCC_PVCS][SCC_CO_UNDO],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{  SCC_PVCS_REV,
		PrefString,
		&prefs.scc[SCC_PVCS][SCC_REVHIST],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	/* RCS */
	{  SCC_RCS_CI_L,
		PrefString,
		&prefs.scc[SCC_RCS][SCC_CI_LOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{  SCC_RCS_CI_U,
		PrefString,
		&prefs.scc[SCC_RCS][SCC_CI_UNLOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{  SCC_RCS_CI_I,
		PrefString,
		&prefs.scc[SCC_RCS][SCC_CI_INIT],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{  SCC_RCS_CO_U,
		PrefString,
		&prefs.scc[SCC_RCS][SCC_CO_UNLOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{  SCC_RCS_CO_L,
		PrefString,
		&prefs.scc[SCC_RCS][SCC_CO_LOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{  SCC_RCS_UNDO,
		PrefString,
		&prefs.scc[SCC_RCS][SCC_CO_UNDO],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{  SCC_RCS_REV,
		PrefString,
		&prefs.scc[SCC_RCS][SCC_REVHIST],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	/* SCCS */
	{ SCC_SCCS_CI_L,
		PrefString,
		&prefs.scc[SCC_SCCS][SCC_CI_LOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_SCCS_CI_U,
		PrefString,
		&prefs.scc[SCC_SCCS][SCC_CI_UNLOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_SCCS_CI_I,
		PrefString,
		&prefs.scc[SCC_SCCS][SCC_CI_INIT],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_SCCS_CO_U,
		PrefString,
		&prefs.scc[SCC_SCCS][SCC_CO_UNLOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_SCCS_CO_L,
		PrefString,
		&prefs.scc[SCC_SCCS][SCC_CO_LOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_SCCS_UNDO,
		PrefString,
		&prefs.scc[SCC_SCCS][SCC_CO_UNDO],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_SCCS_REV,
		PrefString,
		&prefs.scc[SCC_SCCS][SCC_REVHIST],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ "scc_selected",
		PrefInt,
		&prefs.scc_selected,
		0, SCC_NUM_TYPES-1, 0,
		NULL_CALLBACK, NULL,
	},
	/* TLIB */
	{ SCC_TLIB_CI_L,
		PrefString,
		&prefs.scc[SCC_TLIB][SCC_CI_LOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_TLIB_CI_U,
		PrefString,
		&prefs.scc[SCC_TLIB][SCC_CI_UNLOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_TLIB_CI_I,
		PrefString,
		&prefs.scc[SCC_TLIB][SCC_CI_INIT],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_TLIB_CO_U,
		PrefString,
		&prefs.scc[SCC_TLIB][SCC_CO_UNLOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_TLIB_CO_L,
		PrefString,
		&prefs.scc[SCC_TLIB][SCC_CO_LOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_TLIB_UNDO,
		PrefString,
		&prefs.scc[SCC_TLIB][SCC_CO_UNDO],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_TLIB_REV,
		PrefString,
		&prefs.scc[SCC_TLIB][SCC_REVHIST],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	/* User Defined */
	{ SCC_USER_CI_L,
		PrefString,
		&prefs.scc[SCC_USER][SCC_CI_LOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_USER_CI_U,
		PrefString,
		&prefs.scc[SCC_USER][SCC_CI_UNLOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_USER_CI_I,
		PrefString,
		&prefs.scc[SCC_USER][SCC_CI_INIT],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_USER_CO_U,
		PrefString,
		&prefs.scc[SCC_USER][SCC_CO_UNLOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_USER_CO_L,
		PrefString,
		&prefs.scc[SCC_USER][SCC_CO_LOCK],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_USER_UNDO,
		PrefString,
		&prefs.scc[SCC_USER][SCC_CO_UNDO],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
	{ SCC_USER_REV,
		PrefString,
		&prefs.scc[SCC_USER][SCC_REVHIST],
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
#endif	/* USE_SOURCE_CTRL */
#ifdef USE_SHELL_INSERT
	{ "shell",
		PrefString,
		&prefs.shell,
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
#endif	/* USE_SHELL_INSERT */
	{ "show_doc_tabs",
		PrefBool,
		&prefs.options1,
		0, 1, SHOW_TABS,
		win_foreach,
		win_redraw_doc_tab,
	},
#ifdef USE_TOOLBARS
# ifdef USE_HTMLTAGS
	{ "show_html_toolbar",
		PrefBool,
		&prefs.options1,
		0, 1, SHOW_HTML_TOOLBAR,
		NULL_CALLBACK, NULL,
	},
# endif	/* USE_HTMLTAGS */
#endif	/* USE_TOOLBARS */
#ifdef WANT_PROJECT
	{ "show_project_bar",
		PrefBool,
		&prefs.options1,
		0, 1, SHOW_PRJBAR,
		win_foreach, prjbar_redraw,
	},
#endif	/* WANT_PROJECT */
	{ "show_message_bar",
		PrefBool,
		&prefs.options1,
		0, 1, SHOW_MSGBAR,
		win_foreach, msgbar_redraw,
	},
#ifdef WANT_SPLASH
	{ "show_splash",
		PrefBool,
		&prefs.options1,
		0, 1, SHOW_SPLASH,
		NULL_CALLBACK, NULL,
	},
#endif
#ifdef USE_TOOLBARS
	{ "show_toolbar",
		PrefBool,
		&prefs.options1,
		0, 1, SHOW_TOOLBAR,
		NULL_CALLBACK, NULL,
	},
	{ "show_tooltips",
		PrefBool,
		&prefs.options1,
		0, 1, SHOW_TOOLTIPS,
		NULL_CALLBACK, NULL,
	},
#endif	/* USE_TOOLBARS */
	{ "tab_stop",
		PrefInt,
		&prefs.tab_stop,
		1, 128, 0,
		win_doc_foreach, doc_tab_stop_set,
	},
#ifdef USE_HTMLTAGS
	{ "tagchooser_h",
		PrefInt,
		&prefs.tagchooser_h,
		0, 2048, 0,
		NULL_CALLBACK, NULL,
	},
	{ "tagchooser_w",
		PrefInt,
		&prefs.tagchooser_w,
		0, 2048, 0,
		NULL_CALLBACK, NULL,
	},
#endif
	{ "text_bg_color",
		PrefString,
		&prefs.text_bg_str,
		0, 1, MAX_RGB_STR,
		NULL_CALLBACK, NULL,
	},
	{ "text_fg_color",
		PrefString,
		&prefs.text_fg_str,
		0, 0, MAX_RGB_STR,
		NULL_CALLBACK, NULL,
	},
	{ "text_font",
		PrefString,
		&prefs.text_font_str,
		0, 0, MAX_FONT_LEN,
		NULL_CALLBACK, NULL,
	},
	{ "text_hlbg_color",
		PrefString,
		&prefs.text_hlbg_str,
		0, 1, MAX_RGB_STR,
		NULL_CALLBACK, NULL,
	},
	{ "text_hlfg_color",
		PrefString,
		&prefs.text_hlfg_str,
		0, 0, MAX_RGB_STR,
		NULL_CALLBACK, NULL,
	},
	{ "tmp_directory",
		PrefString,
		&prefs.tmpdir,
		0, 0, MAXPATH,
		NULL_CALLBACK, NULL,
	},
#ifdef USE_TOOLBARS
	{ "toolbar_piconly",
		PrefBool,
		&prefs.options1,
		0, 1, PIC_ONLY_TOOLBAR,
		NULL_CALLBACK, NULL,
	},
	{ "toolbar_pictext",
		PrefBool,
		&prefs.options1,
		0, 1, PIC_TEXT_TOOLBAR,
		NULL_CALLBACK, NULL,
	},
# ifdef GTK_HAVE_FEATURES_1_1_0
	{ "toolbar_raised",
		PrefBool,
		&prefs.options1,
		0, 1, TOOLBAR_RAISED,
		NULL_CALLBACK, NULL,
	},
# endif
	{ "toolbar_textonly",		/* make sure tb_redraw() only appears */
		PrefBool,		/* once in this table */
		&prefs.options1,
		0, 1, TEXT_ONLY_TOOLBAR,
		win_foreach, tb_redraw,
	},
#endif	/* USE_TOOLBARS */
#ifdef WANT_MSGBOX
	{ "use_msgbox",
		PrefBool,
		&prefs.options1,
		0, 1, USE_MSGBOX,
		NULL_CALLBACK, NULL,
	},
#endif  /* #ifdef WANT_MSGBOX */
	{ "use_fontset",
		PrefBool,
		&prefs.options1,
		0, 1, USE_FONTSET,
		NULL_CALLBACK, NULL,
	},
#ifdef GTK_HAVE_FEATURES_1_1_0
	{ "use_theme_settings",			/* make sure this comes after */
		PrefBool,			/* font/color settings so the */
		&prefs.options1,		/* doc_redraw will kick in */
		0, 1, USE_GTK_THEME_FONTS,	/* after all font/color */
		win_doc_foreach, doc_redraw,	/* changes have been made */
	},
#endif
	{ "use_wordwrap",
		PrefBool,
		&prefs.options1,
		0, 1, USE_WORDWRAP,
		NULL_CALLBACK, NULL,
	},
	{ "win_height",
		PrefInt,
		&prefs.win_height,
		-1, 8191, 0,
		NULL_CALLBACK, NULL,
	},
#ifdef USE_WINLIST
	{ "win_list_height",
		PrefInt,
		&prefs.winlist_h,
		0, 2048, 0,
		NULL_CALLBACK, NULL,
	},
	{ "win_list_width",
		PrefInt,
		&prefs.winlist_w,
		0, 2048, 0,
		NULL_CALLBACK, NULL,
	},
#endif
	{ "win_host_in_title",
		PrefBool,
		&prefs.options1,
		0, 1, HOST_NAME_IN_TITLE,
		NULL_CALLBACK, NULL,
	},
	{ "win_user_in_title",
		PrefBool,
		&prefs.options1,
		0, 1, USER_NAME_IN_TITLE,
		NULL_CALLBACK, NULL,
	},
	{ "win_width",
		PrefInt,
		&prefs.win_width,
		-1, 8191, 0,
		NULL_CALLBACK, NULL,
	},
	{ "win_xpos",
		PrefInt,
		&prefs.win_xpos,
		-1, 8191, 0,
		NULL_CALLBACK, NULL,
	},
	{ "win_ypos",
		PrefInt,
		&prefs.win_ypos,
		-1, 8191, 0,
		NULL_CALLBACK, NULL,
	},
	{ NULL }
}; /* app_prefs[] */


/*
 * in order for the preferences to take effect and be saved *after* the user
 * clicked "Ok" (as opposed to the preferences taking effect immediately each
 * time the user selects an option in the prefs window), we build a list of
 * items.  each item contains the following:
 *
 *	1. a pointer into the correct entry into the app_prefs table.  since
 *	once the user selects "Ok", we're effectively saving the new options
 *	anyway, so let's just reuse the code used for saving the prefs.
 *
 *	2. the widget representing the options (e.g., a check box).  this is
 *	used so we know what state it's in.  or rather, what the user has
 *	selected.  the widget is implied by what the preference is.  if it's
 *	PrefBool, it must be a button widget.  all others are most likely a
 *	text entry type.
 *
 * once the user hits the "Save Preferences" button, we then scan this list,
 * and depending on the state of the widget/button/etc, we can look in the
 * app_prefs table to see what to set and to what value.
 */
typedef struct {
	prefs_t *pap;		/* pointer into app_prefs table */
	GtkWidget *wgt;		/* the widget */
	wgttype_t type;		/* type of widget */
	void *data;		/* NULL, or GList if ComboType, else GSList */
} wgtopt_t;
static wgtopt_t *wgtopt_list = NULL;
static guint wgtopt_list_cnt = 0;

/* other global variables within this file */
static char *	apprc     = NULL;	/* full path to apprc */
GtkWidget *	prefs_win = NULL;	/* preferences popup window */
#ifdef GTK_HAVE_FEATURES_1_1_0
GtkWidget *	prefs_txt = NULL;	/* preferences text window */
#endif


/*** local function prototypes ***/
static void		prefs_apply_cb(GtkWidget *wgt, gpointer cbdata);
static char *		prefs_tf(long opts, long mask);
static void		prefs_read(FILE *fp);
static void		prefs_bool_set(prefs_t *pap, char *data);
static void		prefs_int_set(prefs_t *pap, char *data);
static void		prefs_string_set(prefs_t *pap, char *data);
static void		prefs_dialog_create(win_t *w);
static void		prefs_win_destroy(GtkWidget *wgt, gpointer cbdata);
static void		prefs_wgtopt_list_init(void);
#ifdef USE_GNOME
static void		prefs_modified(GtkWidget *wgt, gpointer cbdata);
static void		prefs_wgtopt_list_modified(void);
#endif


/*** global function definitions ***/
/*
 * PUBLIC: prefs_cb
 *
 * callback invoked from menu to bring up preferences window.
 */
void
prefs_cb(GtkWidget *wtg, gpointer cbdata)
{
	win_t *w = (win_t *)cbdata;

	if (misc_show_and_raise(prefs_win))
		return;

	prefs_dialog_create(w);
} /* prefs_cb */


/*
 * PUBLIC: prefs_init
 *
 * initializes application wide preferences.
 *
 * TODO: specify/use system-wide app-defaults file
 */
void
prefs_init(void)
{
#ifdef USE_LIBGLADE
	extern char *pkgdatadir;
#endif
	char *homedir, *buf, *gtkrc;
	FILE *fp;
	int num, i, j;
#ifdef HAVE_SETLOCALE
	char *lang;
#endif

	if ((homedir = getenv("HOME")) == NULL) {
		g_error("$HOME is not set!");
		exit(0);
	}

	prefs.appdir = my_concat_dir_and_file(homedir, PREFS_DIR);
	num = mkdir(prefs.appdir, 0777);
	if (num == -1 && errno != ESUCCESS && errno != EEXIST) {
#ifdef GTK_HAVE_FEATURES_1_1_0
		buf = g_strdup_printf("prefs_init: could not create '%s'",
				      prefs.appdir);
#else
		buf = g_new(char, strlen(prefs.appdir) + 32);
		sprintf(buf, "prefs_init: could not create '%s'", prefs.appdir);
#endif
		perror(buf);
		exit(0);
	}

#ifdef USE_LIBGLADE
	g_assert(prefs.gladerc == NULL);
	prefs.gladerc = my_concat_dir_and_file(pkgdatadir, GLADE_FILE);
	if (!file_exist(prefs.gladerc)) {
		g_free(prefs.gladerc);
		prefs.gladerc = my_concat_dir_and_file(".", GLADE_FILE);
		if (!file_exist(prefs.gladerc)) {
			g_error("Could not find %s (not in %s nor .)\n",
				GLADE_FILE, pkgdatadir);
			exit(0);
		}
	}
#endif

	/* initialize to default values */
	prefs.read_size      = BUFSIZ;
	prefs.tmpdir         = g_strdup("/var/tmp");
	prefs.tabpos         = GTK_POS_TOP;
	prefs.options1       = DEFAULT_OPTIONS;
	prefs.tab_stop	     = 8;
#ifdef USE_TOOLBARS
	prefs.main_tb_opt    = DEFAULT_MAIN_TB_OPT;
# ifdef USE_HTMLTAGS
	prefs.html_tb_opt1   = DEFAULT_HTML_TB_OPT1;
	prefs.html_tb_opt2   = DEFAULT_HTML_TB_OPT2;
	prefs.html_font_tb_opt1 = DEFAULT_HTML_FONT_TB_OPT1;
	prefs.html_list_tb_opt1 = DEFAULT_HTML_LIST_TB_OPT1;
	prefs.html_tbl_tb_opt1  = DEFAULT_HTML_TBL_TB_OPT1;
	prefs.html_form_tb_opt1 = DEFAULT_HTML_FORM_TB_OPT1;
	prefs.html_frame_tb_opt1= DEFAULT_HTML_FRAME_TB_OPT1;
# endif	/* USE_HTMLTAGS */
#endif	/* USE_TOOLBARS */
#ifdef USE_RECENT
	prefs.maxrecent      = 4;
#endif	/* USE_RECENT */
#if defined(USE_UNDOREDO) && defined(GTK_HAVE_FEATURES_1_1_0)
	prefs.maxundo        = -1;
#endif
#ifdef WANT_MSGBOX
	prefs.msgbox_max_msg = 200;
	prefs.msgbox_per_del = 50;
#endif  /* #ifdef WANT_MSGBOX */
	prefs.win_height     = 470;
	prefs.win_width      = -1;
	prefs.win_xpos       = -1;
	prefs.win_ypos       = -1;
#if defined(USE_GTKXMHTML) || defined(USE_GTKHTML)
	prefs.html_view_w    = 600;
	prefs.html_view_h    = 400;
#endif
#ifdef USE_WINLIST
	prefs.winlist_w      = 400;
	prefs.winlist_h      = 200;
#endif
#ifdef WANT_PROJECT
	prefs.prjlist_w      = 300;
	prefs.prjlist_h      = 200;
#endif
#ifdef USE_RANDOMTIPS
	prefs.random_tips    = 15;
#endif	/* USE_RANDOMTIPS */
	prefs.printcmd       = g_strdup("lpr %s");
#ifdef USE_BACKUP
	prefs.backupdir      = NULL;
	prefs.backupsuffix   = g_strdup("~");
#endif	/* USE_BACKUP */
#ifdef USE_AUTOSAVE
	prefs.autosave       = 5;
#endif
#ifdef USE_HTMLTAGS
	prefs.tagchooser_w   = 480;
	prefs.tagchooser_h   = 565;
#endif
	prefs.text_fg_str    = g_strdup("0 0 0");	/* always black */
	prefs.text_bg_str    = g_strdup("65535 65535 65535");	/* 16-bit */
	prefs.text_hlfg_str  = g_strdup("65535 65535 65535");	/* 16-bit */
	prefs.text_hlbg_str  = g_strdup("0 65535 0");	/* blue */
	prefs.text_font_str  = g_strdup(DEFAULT_FONT);
	prefs.text_font      = NULL;
#ifdef HAVE_SETLOCALE
	lang = setlocale(LC_MESSAGES, "");
	if (lang) {
		if (!strncmp(lang, "zh", 2) || !strncmp(lang, "ja", 2) ||
		    !strncmp(lang, "ko", 2)) {
			prefs.options1 |= USE_FONTSET;
			if (prefs.text_font_str)
				g_free(prefs.text_font_str);
			prefs.text_font_str = g_strdup(DEFAULT_FONTSET);
		}
	}
#endif
#ifdef USE_SHELL_INSERT
	buf = getenv("SHELL");
	prefs.shell = (buf) ? g_strdup(buf) : g_strdup("/bin/sh");
#endif	/* USE_SHELL_INSERT */

#ifdef USE_SOURCE_CTRL
	for (i = 0; i < SCC_NUM_TYPES; i++) {
		GNPDBG_PREFS(("prefs_init (%s): ", scc_tbl[i].scc_desc_name));
		for (j = 0; j < SCC_NUM_CMDS; j++) {
			prefs.scc[i][j] = 
				(scc_tbl[i].scc_cmds[j].cmd) ?
				g_strdup(scc_tbl[i].scc_cmds[j].cmd) : NULL;
			GNPDBG_PREFS(("'%s'\n", prefs.scc[i][j]));
		}
	}
	prefs.scc_selected = SCC_RCS;
#endif	/* USE_SOURCE_CTRL */
#ifdef WANT_SESSION
	g_assert(prefs.sessionrc == NULL);
	prefs.sessionrc = my_concat_dir_and_file(prefs.appdir, SESSIONRC);
#endif

	/* read apprc to get application specific stuff */
	g_assert(apprc == NULL);
	apprc = my_concat_dir_and_file(prefs.appdir, APPRC);

	fp = file_open_fp(apprc, "r", OPEN_NO_ERROR, "prefs_init");
	if (fp == NULL && errno == ENOENT)
		/* apprc doesn't exist, so create it using default values */
		prefs_save();

	prefs_read(fp);


	gtkrc = my_concat_dir_and_file(prefs.appdir, GTKRC);
	gtk_rc_parse(gtkrc);
	g_free(gtkrc);

	prefs_text_color_update();
        if (!IS_USE_FONTSET()) {
		prefs.text_font = (prefs.text_font_str) ?
				gdk_font_load(prefs.text_font_str) : NULL;
        } else {
		prefs.text_font = (prefs.text_font_str) ?
				gdk_fontset_load(prefs.text_font_str) : NULL;
        }

	/* avoid nonsense */
	if (prefs.read_size < 1)
		prefs.read_size = BUFSIZ;

	/*
	 * now that we have the application specific stuff, create a gtk
	 * formattted rc file which contains app settings that may override
	 * anything in gtkrc, and finally, use the settings specified in this
	 * new file.
	 */
	g_assert(appgtkrc == NULL);
	appgtkrc = my_concat_dir_and_file(prefs.appdir, APPGTKRC);
	appgtk_rc_update(appgtkrc);
} /* prefs_init */


/*
 * PUBLIC: prefs_save
 *
 * save application-wide preferences.  basically, scan the app_prefs table and
 * write out the values corresponding to each entry.
 */
void
prefs_save(void)
{
	FILE *fp;
	char buf[PREFS_NAME_LEN + MAXPATH + 1];
	prefs_t *pap;

	if ((fp = file_open_fp(apprc, "w", OPEN_EXCL, "prefs_save")) == NULL)
		return;

	fprintf(fp,
		"# %s %s initialization file.  "
		"This file is automatically generated.\n"
		"# Data in this file is in no particular order.\n"
		"# Although you could edit this by hand, "
		"it is NOT recommended!\n",
		APP_NAME, APP_VERSION);

	buf[0] = '\0';
	pap = app_prefs;
	while (pap->name) {
		if (pap->addr == NULL) {
			printf("prefs_save: '%s' has NULL addr\n", pap->name);
			pap++;
			continue;
		}

		switch (pap->type) {
		case PrefBool:
			g_snprintf(buf, PREFS_NAME_LEN + MAXPATH,
				"%s = %s",
				pap->name,
				prefs_tf(*(long *)(pap->addr), pap->val));
			break;
		case PrefString:
			g_snprintf(buf, PREFS_NAME_LEN + MAXPATH,
				"%s = %s",
				pap->name,
				handle_null_string(*(char **)(pap->addr)));
			break;
		case PrefInt:
			g_snprintf(buf, PREFS_NAME_LEN + MAXPATH,
				"%s = %d",
				pap->name, *(int *)(pap->addr));
			break;
		default:
			printf("prefs_save: ignoring '%s' (unknown type=%d)\n",
				pap->name, pap->type);
			break;
		} /* switch pap->type */

		if (buf[0] != '\0') {
			fprintf(fp, "%s\n", buf);
			GNPDBG_PREFS(("prefs_save: wrote = '%s'\n", buf));
			buf[0] = '\0';
		}

		pap++;
	} /* while pap->name */

	file_close_fp(apprc, fp);
} /* prefs_save */


/*
 * PUBLIC: prefs_update_text_widget_style
 *
 * this needs to be called *AFTER* the main prefs window has been drawn and
 * show.  this is because at the time when the text widget was created, nothing
 * was realized, so we cannot muck with the text widget.
 */
#ifdef GTK_HAVE_FEATURES_1_1_0
void
prefs_update_text_widget_style(GtkWidget *wgt)
{
	GtkStyle *style;

	/* we always set the style for the text widget in the prefs dialog */
	if (IS_USE_GTK_THEME_FONTS() && wgt != prefs_txt)
		return;

	style = gtk_style_copy(wgt->style);

	sscanf(prefs.text_fg_str, "%hd %hd %hd", &prefs.text_fg_color.red,
		&prefs.text_fg_color.blue, &prefs.text_fg_color.green);
	style->fg[GTK_STATE_NORMAL].red     = prefs.text_fg_color.red;
	style->fg[GTK_STATE_NORMAL].blue    = prefs.text_fg_color.blue;
	style->fg[GTK_STATE_NORMAL].green   = prefs.text_fg_color.green;
	style->text[GTK_STATE_NORMAL].red   = prefs.text_fg_color.red;
	style->text[GTK_STATE_NORMAL].blue  = prefs.text_fg_color.blue;
	style->text[GTK_STATE_NORMAL].green = prefs.text_fg_color.green;

	sscanf(prefs.text_bg_str, "%hd %hd %hd", &prefs.text_bg_color.red,
		&prefs.text_bg_color.blue, &prefs.text_bg_color.green);
	style->bg[GTK_STATE_NORMAL].red     = prefs.text_bg_color.red;
	style->bg[GTK_STATE_NORMAL].blue    = prefs.text_bg_color.blue;
	style->bg[GTK_STATE_NORMAL].green   = prefs.text_bg_color.green;
	style->base[GTK_STATE_NORMAL].red   = prefs.text_bg_color.red;
	style->base[GTK_STATE_NORMAL].blue  = prefs.text_bg_color.blue;
	style->base[GTK_STATE_NORMAL].green = prefs.text_bg_color.green;

	sscanf(prefs.text_hlfg_str, "%hd %hd %hd", &prefs.text_hlfg_color.red,
		&prefs.text_hlfg_color.blue, &prefs.text_hlfg_color.green);
	style->fg[GTK_STATE_SELECTED].red     = prefs.text_hlfg_color.red;
	style->fg[GTK_STATE_SELECTED].blue    = prefs.text_hlfg_color.blue;
	style->fg[GTK_STATE_SELECTED].green   = prefs.text_hlfg_color.green;
	style->text[GTK_STATE_SELECTED].red   = prefs.text_hlfg_color.red;
	style->text[GTK_STATE_SELECTED].blue  = prefs.text_hlfg_color.blue;
	style->text[GTK_STATE_SELECTED].green = prefs.text_hlfg_color.green;

	sscanf(prefs.text_hlbg_str, "%hd %hd %hd", &prefs.text_hlbg_color.red,
		&prefs.text_hlbg_color.blue, &prefs.text_hlbg_color.green);
	style->bg[GTK_STATE_SELECTED].red     = prefs.text_hlbg_color.red;
	style->bg[GTK_STATE_SELECTED].blue    = prefs.text_hlbg_color.blue;
	style->bg[GTK_STATE_SELECTED].green   = prefs.text_hlbg_color.green;
	style->base[GTK_STATE_SELECTED].red   = prefs.text_hlbg_color.red;
	style->base[GTK_STATE_SELECTED].blue  = prefs.text_hlbg_color.blue;
	style->base[GTK_STATE_SELECTED].green = prefs.text_hlbg_color.green;

	gtk_widget_push_style(style);
	if (!IS_USE_FONTSET()) {
		if ((style->font = gdk_font_load(prefs.text_font_str)) == NULL)
			style->font = gdk_font_load("7x13");
	} else {
		style->font = gdk_fontset_load(prefs.text_font_str);
		if (style->font == NULL)
			style->font = gdk_fontset_load("7x13,*");
	}
	prefs.text_font = style->font;
	gtk_widget_set_style(wgt, style);
	gtk_widget_pop_style();
} /* prefs_update_text_widget_style */
#endif	/* GTK_HAVE_FEATURES_1_1_0 */


/*
 * PUBLIC: prefs_bool_by_name
 *
 * returns pref's bool value by it's prefname
 */
bool_t
prefs_bool_by_name(char *prefname)
{
	prefs_t *pap;
	long *val;

	for (pap = app_prefs; pap->name; pap++) {
		if (strcmp(pap->name, prefname) == 0) {
			if (pap->type != PrefBool) {
				GNPDBG_PREFS(("prefs_bool_by_name: '%s' "
					      "not a PrefBool!\n", pap->name));
				return FALSE;
			}

			val = (long *)(pap->addr);
			if (*val & pap->val) {
				return TRUE;
			}
			return FALSE;
		}
	}

	GNPDBG_PREFS(("prefs_bool_by_name: '%s' not found\n", pap->name));
	return FALSE;
} /* prefs_bool_by_name */


/*** local function definitions ***/
/*
 * PRIVATE: prefs_read
 *
 * actually read the prefs file.  each line's first token is looked up in the
 * app_prefs table.  if it's not in there, then that line is ignored.
 */
static void
prefs_read(FILE *fp)
{
	char *buf, *data, *tok;
	prefs_t *pap;
	bool_t done;

	if (fp == NULL) {
		fp = file_open_fp(apprc, "r", 0, "prefs_read");
		if (fp == NULL)
			return;
	}

	buf = g_new(char, PREFS_NAME_LEN + MAXPATH);
	if (fgets(buf, PREFS_NAME_LEN + MAXPATH, fp)) {
		char *p;
		/* XXX - horrible hack for versioning */
		if ((p = strstr(buf, "gnotepad+ 1.0"))) {
			p += strlen("gnotepad+ 1.0") + 1;
			if (!isdigit((int)(*(p+1))))
				*(p+1) = '\0';
			else
				*(p+2) = '\0';
			if (atoi(p) < 2)
				pre102 = TRUE;
		}
	}

	while (fgets(buf, PREFS_NAME_LEN + MAXPATH, fp)) {
		buf[strlen(buf) - 1] = '\0';	/* remove \n */
		if ((tok = strtok(buf, "=")) == NULL)
			continue;

		/* trim any trailing spaces */
		while (isspace((int)tok[strlen(tok) - 1]))
			tok[strlen(tok) - 1] = '\0';

		data = tok + strlen(tok) + 2;
		while (isspace((int)(*data)))	/* skip to actual value */
			data++;

		GNPDBG_PREFS(("prefs_read: tok  = '%s'\n", tok));
		GNPDBG_PREFS(("prefs_read: data = '%s'\n", data));

		/*
		 * TODO - eventually, if app_prefs gets big, this should be a
		 * binary search instead of a linear traversal.
		 */
		done = FALSE;
		pap = app_prefs;
		while (pap->name) {
			if (pap->addr == NULL) {
				printf("prefs_read: '%s' has NULL addr\n",
					pap->name);
				pap++;
				continue;
			}

			if (strncmp(tok, pap->name, strlen(pap->name)) == 0) {
				switch (pap->type) {
				case PrefBool:
					prefs_bool_set(pap, data);
					break;
				case PrefString:
					prefs_string_set(pap, data);
					break;
				case PrefInt:
					prefs_int_set(pap, data);
					break;
				default:
					printf("prefs_read: ignoring '%s' "
						"(unknown type=%d)\n",
						pap->name, pap->type);
					break;
				}
				done = TRUE;
			} /* if attr match */

			pap++;

		} /* while pap->name */
	} /* while fgets */

	file_close_fp(apprc, fp);
	g_free(buf);
} /* prefs_read */


/*
 * PRIVATE: appgtk_rc_update
 *
 * creates an application specific rc file in gtk format.
 */
void
appgtk_rc_update(gpointer data)
{
	char *rcfile = (char *)data;
	FILE *fp;
#ifdef HAVE_SETLOCALE
	char *locale;
#endif

	fp = file_open_fp(rcfile, "w", OPEN_EXCL, "appgtk_rc_update");
	if (fp == NULL)
		return;

#ifdef HAVE_SETLOCALE
	locale = setlocale(LC_NUMERIC, NULL);
	GNPDBG_PREFS(("appgtk_rc_update: %s <- LOCALE\n", locale));
	(void)setlocale(LC_NUMERIC, "C");
#endif

	fprintf(fp, "style \"text\"\n{\n\tfont = \"%s\"\n",
		prefs.text_font_str);
	fprintf(fp, "\tbase[NORMAL]   = { %0.1f, %0.1f, %0.1f }\n", 
		prefs.text_bg_color.red   / COL_VAL_GDK,
		prefs.text_bg_color.green / COL_VAL_GDK,
		prefs.text_bg_color.blue  / COL_VAL_GDK);
	fprintf(fp, "\tbg[NORMAL]     = { %0.1f, %0.1f, %0.1f }\n", 
		prefs.text_bg_color.red   / COL_VAL_GDK,
		prefs.text_bg_color.green / COL_VAL_GDK,
		prefs.text_bg_color.blue  / COL_VAL_GDK);
	fprintf(fp, "\ttext[NORMAL]   = { %0.1f, %0.1f, %0.1f }\n", 
		prefs.text_fg_color.red   / COL_VAL_GDK,
		prefs.text_fg_color.green / COL_VAL_GDK,
		prefs.text_fg_color.blue  / COL_VAL_GDK);
	fprintf(fp, "\tfg[NORMAL]     = { %0.1f, %0.1f, %0.1f }\n", 
		prefs.text_fg_color.red   / COL_VAL_GDK,
		prefs.text_fg_color.green / COL_VAL_GDK,
		prefs.text_fg_color.blue  / COL_VAL_GDK);
	fprintf(fp, "\tbase[SELECTED] = { %0.1f, %0.1f, %0.1f }\n", 
		prefs.text_hlbg_color.red   / COL_VAL_GDK,
		prefs.text_hlbg_color.green / COL_VAL_GDK,
		prefs.text_hlbg_color.blue  / COL_VAL_GDK);
	fprintf(fp, "\tbg[SELECTED]   = { %0.1f, %0.1f, %0.1f }\n", 
		prefs.text_hlbg_color.red   / COL_VAL_GDK,
		prefs.text_hlbg_color.green / COL_VAL_GDK,
		prefs.text_hlbg_color.blue  / COL_VAL_GDK);
	fprintf(fp, "\ttext[SELECTED] = { %0.1f, %0.1f, %0.1f }\n", 
		prefs.text_hlfg_color.red   / COL_VAL_GDK,
		prefs.text_hlfg_color.green / COL_VAL_GDK,
		prefs.text_hlfg_color.blue  / COL_VAL_GDK);
	fprintf(fp, "\tfg[SELECTED]   = { %0.1f, %0.1f, %0.1f }\n", 
		prefs.text_hlfg_color.red   / COL_VAL_GDK,
		prefs.text_hlfg_color.green / COL_VAL_GDK,
		prefs.text_hlfg_color.blue  / COL_VAL_GDK);
	fprintf(fp, "}\nwidget_class \"*GtkText\" style \"text\"\n");

#ifdef HAVE_SETLOCALE
	locale = setlocale(LC_NUMERIC, locale);
	GNPDBG_PREFS(("appgtk_rc_update: %s -> LOCALE\n", locale));
#endif

	file_close_fp(rcfile, fp);

	if (!IS_USE_GTK_THEME_FONTS())
		gtk_rc_parse(rcfile);
} /* appgtk_rc_update */


/*
 * PRIVATE: prefs_string_set
 *
 * set a preference whose setting/value is a "string"
 */
static void
prefs_string_set(prefs_t *pap, char *data)
{
	int len;
	char **string = (char **)(pap->addr);

	if (*string)
		g_free(*string);
	*string = NULL;

	if (data == NULL || data[0] == '\0' || strcmp(data, "(null)") == 0)
		return;

	len = MIN(strlen(data), pap->val);
	*string = g_new(char, len + 1);
	strncpy(*string, data, len);
	(*string)[len] = '\0';
} /* prefs_string_set */


/*
 * PRIVATE: prefs_int_set
 *
 * set a preference whose setting/value is an integer
 */
static void
prefs_int_set(prefs_t *pap, char *data)
{
	int *num = (int *)(pap->addr);

	*num = atoi(data);
	if (*num > pap->max)
		*num = (int)(pap->max);
	if (*num < pap->min)
		*num = (int)(pap->min);
} /* prefs_int_set */


/*
 * PRIVATE: prefs_bool_set
 *
 * set a preference whose setting/value is a boolean.  NOTE!!  the convention
 * here is that booleans use bitmasks to toggle their settings.  the variable
 * itself must be stored in a "long".
 */
static void
prefs_bool_set(prefs_t *pap, char *data)
{
	long *opts;

	opts = (long *)(pap->addr);

	if (tolower((int)data[0]) == 't' || data[0] == '1') {
		*opts |= pap->val;
	} else if (tolower((int)data[0]) == 'f' || data[0] == '0') {
		*opts &= ~pap->val;
	}
} /* prefs_bool_set */


/*
 * PRIVATE: prefs_tf
 *
 * returns the string 'true' or 'false'
 */
static char *
prefs_tf(long opts, long mask)
{
	return (opts & mask) ? "true" : "false";
} /* prefs_tf */


static void
prefs_apply_cb(GtkWidget *wgt, gpointer cbdata)
{
	GNPDBG_PREFS(("prefs_apply_cb() entered\n"));
	prefs_update();
	prefs_save();
	appgtk_rc_update(appgtkrc);
} /* prefs_apply_cb */


#if defined(USE_GNOME) && defined(USE_LIBGLADE)
/*
 * Handles the "special" case widgets in the prefs dialog, where we can't help
 * but check for them specifically (in order to do something) instead of just
 * using the prefs_t table.
 *
 * Returns TRUE if handled, FALSE if not.
 */
extern void gnome_font_picker_update_font_info(GnomeFontPicker *);
static bool_t
prefs_glade_handle_special(GladeXML *xml, prefs_t *pap, GtkWidget *wgt)
{
	GtkWidget *tmp;

	if (strcmp(pap->name, "use_theme_settings") == 0) {
		GSList *senslist = NULL;
		tmp = my_glade_widget_get(xml, "fonts_colors_hbox", 0);
		g_assert(tmp);
		senslist = g_slist_prepend(senslist, tmp);
		(void)gtk_signal_connect(GTK_OBJECT(wgt), "clicked",
					 GTK_SIGNAL_FUNC(fonts_colors_sens_cb),
					 senslist);
		prefs_wgtopt_list_add(wgt, ButtonType, senslist,
				      "use_theme_settings");
		return TRUE;
	}
	
	if (strcmp(pap->name, "scc_selected") == 0) {
		GList *scc_list = NULL; /* freed in prefs_wgtopt_list_free() */
		int i;

		for (i = 0; i < SCC_NUM_TYPES; i++)
			scc_list = g_list_append(scc_list,
					gettext(scc_tbl[i].scc_desc_name));
		gtk_combo_set_popdown_strings(GTK_COMBO(wgt), scc_list);
		gtk_entry_set_text(
			GTK_ENTRY(GTK_COMBO(wgt)->entry),
			(char *)g_list_nth_data(scc_list, prefs.scc_selected));
		prefs_wgtopt_list_add(
				GTK_WIDGET(GTK_EDITABLE(GTK_COMBO(wgt)->entry)),
				ComboType, scc_list, pap->name);

		return TRUE;
	}
	
	if (strcmp(pap->name, "doc_tab_position") == 0) {
		GList *tab_list = NULL; /* freed in prefs_wgtopt_list_free() */

		tab_list = g_list_prepend(tab_list, _("Bottom"));
		tab_list = g_list_prepend(tab_list, _("Top"));
		tab_list = g_list_prepend(tab_list, _("Right"));
		tab_list = g_list_prepend(tab_list, _("Left"));
		gtk_combo_set_popdown_strings(GTK_COMBO(wgt), tab_list);
		gtk_entry_set_text(
			GTK_ENTRY(GTK_COMBO(wgt)->entry),
			(char *)g_list_nth_data(tab_list, prefs.tabpos));
		prefs_wgtopt_list_add(
				GTK_WIDGET(GTK_EDITABLE(GTK_COMBO(wgt)->entry)),
				ComboType, tab_list, pap->name);
		return TRUE;
	}

	if (strcmp(pap->name, "text_font") == 0) {
		gtk_signal_connect(GTK_OBJECT(wgt), "font_set",
				   GTK_SIGNAL_FUNC(prefs_font_sel_cb), NULL);
		/* XXX - no effect?! */
		gnome_font_picker_set_title(GNOME_FONT_PICKER(wgt),
					    _("Font Selection..."));
		gnome_font_picker_set_mode(GNOME_FONT_PICKER(wgt),
					   GNOME_FONT_PICKER_MODE_FONT_INFO);
		gnome_font_picker_set_font_name(GNOME_FONT_PICKER(wgt),
						prefs.text_font_str);

		/*
		 * look at the name of this next gnome function.  why the hell
		 * is it so long?  someone has a serious
		 * function-naming-growth-hormone-problem.
		 */
		gnome_font_picker_fi_set_use_font_in_label(
					GNOME_FONT_PICKER(wgt), TRUE, 14);
		/* don't show the size; something is screwed up with
		 * the gnome font picker */
		gnome_font_picker_fi_set_show_size(GNOME_FONT_PICKER(wgt),
						   FALSE);

		/*
		 * This is retarded.  This is a "public" function, but its
		 * prototype isn't available in any header file.  Yet, we need
		 * this because without it, the initial font name in the font
		 * picker button will NOT be set to the current font.  We make
		 * this call to force it to update its contents correctly.
		 */
		gnome_font_picker_update_font_info(GNOME_FONT_PICKER(wgt));

		prefs_wgtopt_list_add(wgt, GenericType, NULL, pap->name);
		return TRUE;
	}

	if (strcmp(pap->name, "text_hlfg_color") == 0) {
		gtk_signal_connect(GTK_OBJECT(wgt), "color_set",
				   GTK_SIGNAL_FUNC(prefs_text_color_cb),
				   GINT_TO_POINTER(HighlightFg));
		gnome_color_picker_set_i16(GNOME_COLOR_PICKER(wgt),
					   prefs.text_hlfg_color.red,
					   prefs.text_hlfg_color.green,
					   prefs.text_hlfg_color.blue,
					   0);
		prefs_wgtopt_list_add(wgt, GenericType, NULL, pap->name);
		return TRUE;
	}

	if (strcmp(pap->name, "text_hlbg_color") == 0) {
		gtk_signal_connect(GTK_OBJECT(wgt), "color_set",
				   GTK_SIGNAL_FUNC(prefs_text_color_cb),
				   GINT_TO_POINTER(HighlightBg));
		gnome_color_picker_set_i16(GNOME_COLOR_PICKER(wgt),
					   prefs.text_hlbg_color.red,
					   prefs.text_hlbg_color.green,
					   prefs.text_hlbg_color.blue,
					   0);
		prefs_wgtopt_list_add(wgt, GenericType, NULL, pap->name);
		return TRUE;
	}

	if (strcmp(pap->name, "text_fg_color") == 0) {
		gtk_signal_connect(GTK_OBJECT(wgt), "color_set",
				   GTK_SIGNAL_FUNC(prefs_text_color_cb),
				   GINT_TO_POINTER(Foreground));
		gnome_color_picker_set_i16(GNOME_COLOR_PICKER(wgt),
					   prefs.text_fg_color.red,
					   prefs.text_fg_color.green,
					   prefs.text_fg_color.blue,
					   0);
		prefs_wgtopt_list_add(wgt, GenericType, NULL, pap->name);
		return TRUE;
	}

	if (strcmp(pap->name, "text_bg_color") == 0) {
		gtk_signal_connect(GTK_OBJECT(wgt), "color_set",
				   GTK_SIGNAL_FUNC(prefs_text_color_cb),
				   GINT_TO_POINTER(Background));
		gnome_color_picker_set_i16(GNOME_COLOR_PICKER(wgt),
					   prefs.text_bg_color.red,
					   prefs.text_bg_color.green,
					   prefs.text_bg_color.blue,
					   0);
		prefs_wgtopt_list_add(wgt, GenericType, NULL, pap->name);
		return TRUE;
	}

	return FALSE;
} /* prefs_glade_handle_special */


static void
prefs_glade_wgtopt_list_add(GladeXML *xml)
{
	GtkWidget *wgt;
	prefs_t *pap;
	char *s;
	long opts;
	int inum;

	for (pap = app_prefs; pap->name; pap++) {
		if ((wgt = my_glade_widget_get(xml, pap->name, 0)) == NULL) {
			GNPDBG_PREFS((
				"prefs_glade_wgtopt_list_add: '%s' not found\n",
				pap->name));
			continue;
		}

		if (prefs_glade_handle_special(xml, pap, wgt))
			continue;

		if (GTK_IS_COMBO(wgt)) {
			prefs_wgtopt_list_add(wgt, ComboType, NULL, pap->name);
		} else if (GTK_IS_ENTRY(wgt)) {
			prefs_wgtopt_list_add(wgt, EntryType, NULL, pap->name);
		} else if (GTK_IS_BUTTON(wgt)) {
			prefs_wgtopt_list_add(wgt, ButtonType, NULL, pap->name);
		} else {
			prefs_wgtopt_list_add(wgt, GenericType, NULL,pap->name);
		}

		switch (pap->type) {
		case PrefBool:
			g_assert(GTK_IS_TOGGLE_BUTTON(wgt));
			opts = *(long *)(pap->addr);
			gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(wgt),
						    (opts & pap->val));
			break;
		case PrefString:
			g_assert(GTK_IS_ENTRY(wgt));
			if ((s = *(char **)(pap->addr)))
				gtk_entry_set_text(GTK_ENTRY(wgt), s);
			break;
		case PrefInt:
			g_assert(GTK_IS_SPIN_BUTTON(wgt));
			inum = *(int *)(pap->addr);
			gtk_spin_button_set_value(GTK_SPIN_BUTTON(wgt),
						  (float)inum);
			break;
		default:
			break;
		}
	}
} /* prefs_glade_wgtopt_list_add */
#endif


/*
 * PRIVATE: prefs_dialog_create
 *
 * creates the preferences window.
 *
 * 1. Appearance
 * 2. Document
 * 3. Window
 * 4. Fonts and Colors
 * 5. Main Toolbar
 * 6. Html Toolbar
 * 7. Misc
 */
static void
prefs_dialog_create(win_t *w)
{
	GtkWidget *prefs_nb;
#ifdef USE_GNOME
	static GnomeHelpMenuEntry helpentry = { NULL, "prefs" };
# ifdef USE_LIBGLADE
	GladeXML *xml;
# endif
#else
	GtkWidget *vbox, *hbox;
#endif

	if (prefs_win)
		return;

	prefs_wgtopt_list_init();

	/* create top level */
#ifdef USE_GNOME
# ifdef USE_LIBGLADE
	xml = my_glade_xml_get("Prefs");
	prefs_win = my_glade_widget_get(xml, "Prefs", GLADE_POS_MOUSE);
	prefs_nb = GNOME_PROPERTY_BOX(prefs_win)->notebook;
	prefs_txt = my_glade_widget_get(xml, "prefs_txt", 0);
# else
	prefs_win = gnome_property_box_new();
	gtk_window_set_position(GTK_WINDOW(prefs_win), GTK_WIN_POS_MOUSE);
	prefs_nb = GNOME_PROPERTY_BOX(prefs_win)->notebook;
# endif
#else
	prefs_win = gtk_dialog_new();
	gtk_container_border_width(GTK_CONTAINER(prefs_win), 5);

	/* create vbox to hold everything */
	vbox = GTK_DIALOG(prefs_win)->vbox;
	gtk_container_border_width(GTK_CONTAINER(vbox), 5);

	/* create notebook */
	prefs_nb = gtk_notebook_new();
	gtk_notebook_set_scrollable(GTK_NOTEBOOK(prefs_nb), TRUE);
	gtk_notebook_popup_enable(GTK_NOTEBOOK(prefs_nb));
	gtk_box_pack_start(GTK_BOX(vbox), prefs_nb, TRUE, TRUE, 0);
#endif
	gtk_notebook_set_tab_pos(GTK_NOTEBOOK(prefs_nb), GTK_POS_LEFT);
	gtk_window_set_title(GTK_WINDOW(prefs_win), _("gnotepad+ Preferences"));
	(void)gtk_signal_connect(GTK_OBJECT(prefs_win), "destroy",
				 GTK_SIGNAL_FUNC(prefs_win_destroy), NULL);

	/* create various pages of the notebook */
	gtk_widget_show(prefs_nb);
#if defined(USE_GNOME) && defined(USE_LIBGLADE)
	/* suck widgets out of the dialog and place in wgtopt_list */
	prefs_glade_wgtopt_list_add(xml);
#else
	prefs_page_appearance_create(prefs_nb);
	prefs_page_document_create(prefs_nb);
	prefs_page_window_create(prefs_nb);
	prefs_page_fonts_colors(prefs_nb);
	prefs_page_main_tb(prefs_nb);
	prefs_page_html_tb(prefs_nb);
	prefs_page_scc_create(prefs_nb);
	prefs_page_misc_create(prefs_nb);
#endif
	/* lastly, the buttons */
#ifdef USE_GNOME
	helpentry.name = gnome_app_id;
	gtk_signal_connect(GTK_OBJECT(prefs_win), "delete_event",
			   GTK_SIGNAL_FUNC(gtk_false), NULL);
	gtk_signal_connect(GTK_OBJECT(prefs_win), "apply",
			   GTK_SIGNAL_FUNC(prefs_apply_cb), w);
	gtk_signal_connect(GTK_OBJECT(prefs_win), "help",
			   GTK_SIGNAL_FUNC(gnome_help_pbox_display),
			   &helpentry);
# ifdef USE_GLADE
	gtk_signal_connect_object(GTK_OBJECT(prefs_win), "destroy",
				  GTK_SIGNAL_FUNC(gtk_object_destroy),
				  GTK_OBJECT(xml));
# endif
	/*
	 * Note that we *could* attach to the "close" signal, but we don't have
	 * to since without it, the "apply" signal is done first, followed by
	 * the "destroy".  Together, they apply changes and clean things up
	 * anyway, which is exactly what we want on "close".
	 *
	gtk_signal_connect(GTK_OBJECT(prefs_win), "close",
			   GTK_SIGNAL_FUNC(prefs_close_cb), w);
	*/
	prefs_wgtopt_list_modified();
#else
	hbox = GTK_DIALOG(prefs_win)->action_area;
	(void)misc_button_new_w_label(_("Ok"), GNOME_STOCK_BUTTON_OK,
				      GTK_SIGNAL_FUNC(prefs_save_cb),
				      w, hbox, PACK_START | PACK_EXPAND |
				      PACK_FILL | CANCEL_DEFAULT, 0);
	(void)misc_button_new_w_label(_("Apply"), GNOME_STOCK_BUTTON_APPLY,
				      GTK_SIGNAL_FUNC(prefs_apply_cb),
				      w, hbox, PACK_START | PACK_EXPAND |
				      PACK_FILL | CANCEL_DEFAULT, 0);
	(void)misc_button_new_w_label(_("Close"), GNOME_STOCK_BUTTON_CLOSE,
				      GTK_SIGNAL_FUNC(prefs_win_cancel),
				      NULL, hbox, 
				      PACK_START | PACK_EXPAND | PACK_FILL |
				      CANCEL_DEFAULT | GRAB_DEFAULT, 0);
#endif	/* USE_GNOME */

#if defined(GTK_HAVE_FEATURES_1_1_0) && !defined(USE_LIBGLADE)
	/* update the prefs window's text widget and insert sample text */
	prefs_update_text_widget_style(prefs_txt);
	gtk_text_set_editable(GTK_TEXT(prefs_txt), FALSE);
	gtk_text_set_word_wrap(GTK_TEXT(prefs_txt), TRUE);
	gtk_widget_realize(prefs_txt);
	gtk_text_insert(GTK_TEXT(prefs_txt),
		NULL, NULL, NULL,
		"This is some sample text.  Note that color changes only take "
		"immediate effect if you are using gtk versions 1.1.x or "
		"1.2.x, but not 1.0.x.",
		-1);
#endif
	gtk_widget_show_all(prefs_win);
	gtk_events_flush();

} /* prefs_dialog_create */


#ifdef GTK_HAVE_FEATURES_1_1_0
void
fonts_colors_sens_cb(GtkWidget *sensitive, gpointer cbdata)
{
	GSList *senslist = (GSList *)cbdata;

	/* senslist is freed in prefs_wgtopt_list_free() */
	while (senslist) {
		gtk_widget_set_sensitive(GTK_WIDGET(senslist->data),
					 !GTK_TOGGLE_BUTTON(sensitive)->active);
		senslist = senslist->next;
	}
} /* fonts_colors_sens_cb */
#endif


void
color_sel_ok_common(which_text_t which, char *buf)
{
	switch (which) {
	case Foreground:
		if (prefs.text_fg_str)
			g_free(prefs.text_fg_str);
		prefs.text_fg_str = g_strdup(buf);
		GNPDBG_PREFS(("color_sel_ok_common: text_fg_color = '%s'\n",
			      prefs.text_fg_str));
		break;
	case Background:
		if (prefs.text_bg_str)
			g_free(prefs.text_bg_str);
		prefs.text_bg_str = g_strdup(buf);
		GNPDBG_PREFS(("color_sel_ok_common: text_bg_color = '%s'\n",
			      prefs.text_bg_str));
		break;
	case HighlightFg:
		if (prefs.text_hlfg_str)
			g_free(prefs.text_hlfg_str);
		prefs.text_hlfg_str = g_strdup(buf);
		GNPDBG_PREFS(("color_sel_ok_common: text_hlfg_color = '%s'\n",
			      prefs.text_hlfg_str));
		break;
	case HighlightBg:
		if (prefs.text_hlbg_str)
			g_free(prefs.text_hlbg_str);
		prefs.text_hlbg_str = g_strdup(buf);
		GNPDBG_PREFS(("color_sel_ok_common: text_hlbg_color = '%s'\n",
			      prefs.text_hlbg_str));
		break;
	} /* switch which */

	prefs_update_text_widget_style(prefs_txt);
} /* color_sel_ok_common */


#ifdef USE_GNOME
/*
 * Note that the order of the parameters is r-b-g, but it's really r-g-b
 */
void
prefs_text_color_cb(GtkWidget *wgt, guint r, guint b, guint g, guint a,
		    gpointer cbdata)
{
	int which = GPOINTER_TO_INT(cbdata);
	char buf[MAX_RGB_STR];

	g_snprintf(buf, MAX_RGB_STR, "%u %u %u", r, g, b);

	color_sel_ok_common(which, buf);
} /* prefs_text_color_cb */
#endif	/* USE_GNOME */


/*
 * PRIVATE: prefs_text_color_update
 *
 * reads the RGB string values and converts them into what GDK expects.
 */
void
prefs_text_color_update(void)
{
	GdkColormap *gdkcmap;

	gdkcmap = gdk_colormap_get_system();

	sscanf(prefs.text_fg_str, "%hu %hu %hu", &prefs.text_fg_color.red,
						 &prefs.text_fg_color.blue,
						 &prefs.text_fg_color.green);
	GNPDBG_PREFS(("prefs_text_color_update: FG pixel %lu, "
		      "red %u, blue %u, green %u\n",
		      prefs.text_fg_color.pixel, prefs.text_fg_color.red,
		      prefs.text_fg_color.blue, prefs.text_fg_color.green));

	if (pre102) {
		g_free(prefs.text_bg_str);
		prefs.text_bg_str = g_strdup("65535 65535 65535");
	}
	sscanf(prefs.text_bg_str, "%hu %hu %hu", &prefs.text_bg_color.red,
						 &prefs.text_bg_color.blue,
						 &prefs.text_bg_color.green);
	GNPDBG_PREFS(("prefs_text_color_update: BG pixel %lu, "
		      "red %u, blue %u, green %u\n",
		      prefs.text_bg_color.pixel, prefs.text_bg_color.red,
		      prefs.text_bg_color.blue, prefs.text_bg_color.green));

	sscanf(prefs.text_hlfg_str, "%hu %hu %hu",&prefs.text_hlfg_color.red,
						  &prefs.text_hlfg_color.blue,
						  &prefs.text_hlfg_color.green);
	sscanf(prefs.text_hlbg_str, "%hu %hu %hu",&prefs.text_hlbg_color.red,
						  &prefs.text_hlbg_color.blue,
						  &prefs.text_hlbg_color.green);

	if (!gdk_color_alloc(gdkcmap, &prefs.text_fg_color))
		g_error("prefs_text_color_update: couldn't alloc fg color");
	if (!gdk_color_alloc(gdkcmap, &prefs.text_bg_color))
		g_error("prefs_text_color_update: couldn't alloc bg color");
	if (!gdk_color_alloc(gdkcmap, &prefs.text_hlfg_color))
		g_error("prefs_text_color_update: couldn't alloc hlfg color");
	if (!gdk_color_alloc(gdkcmap, &prefs.text_hlbg_color))
		g_error("prefs_text_color_update: couldn't alloc hlbg color");
} /* prefs_text_color_update */


void
font_sel_ok_common(char *newfont)
{
	if (prefs.text_font_str)
		g_free(prefs.text_font_str);
	prefs.text_font_str = g_strdup(newfont);
	GNPDBG_PREFS(("font_sel_ok_common: text_font_str '%s'\n",
		       prefs.text_font_str));

	if (IS_USE_FONTSET()) {
		prefs.text_font = gdk_fontset_load(prefs.text_font_str);
                if (prefs.text_font == NULL) {
                        prefs.text_font = gdk_fontset_load("DEFAULT_FONT,*");
                        if (prefs.text_font == NULL)  
                		prefs.text_font = gdk_fontset_load("7x13,*");  
		}
        } else {
		prefs.text_font = gdk_font_load(prefs.text_font_str);
		if (prefs.text_font == NULL) {
			prefs.text_font = gdk_font_load(DEFAULT_FONT);
			if (prefs.text_font == NULL)
				prefs.text_font = gdk_font_load("7x13");
		}
	}
	prefs_update_text_widget_style(prefs_txt);
}


#ifdef USE_GNOME
void
prefs_font_sel_cb(GnomeFontPicker *gfp, char *newfont, gpointer cbdata)
{
	if (!newfont)
		return;

	font_sel_ok_common(newfont);
}
#endif	/* USE_GNOME */

/*
 * PRIVATE: prefs_wgtopt_list_init
 *
 * initializes the wgtopt_list by counting how many entries are in the prefs
 * table.
 */
static void
prefs_wgtopt_list_init(void)
{
	int cnt;

	for (cnt = 0; app_prefs[cnt].name; cnt++)
		;
	wgtopt_list = g_new(wgtopt_t, cnt);
} /* prefs_wgtopt_list_init */


/*
 * PRIVATE: prefs_wgtopt_list_add
 *
 * adds a widget and its corresponding information into the wgtopt_list.
 */
void
prefs_wgtopt_list_add(GtkWidget *wgt, wgttype_t type, void *data,
	char *prefname)
{
	prefs_t *pap;

	for (pap = app_prefs; pap->name; pap++) {
		if (strncmp(prefname, pap->name, strlen(pap->name)) == 0) {
			wgtopt_list[wgtopt_list_cnt].pap = pap;
			wgtopt_list[wgtopt_list_cnt].wgt = wgt;
			wgtopt_list[wgtopt_list_cnt].type = type;
			wgtopt_list[wgtopt_list_cnt].data = data;
			wgtopt_list_cnt++;
			GNPDBG_PREFS(("prefs_wgtopt_list_add: added '%s'\n",
				      prefname));
			break;
		}
	}
} /* prefs_wgtopt_list_add */


/*
 * PRIVATE: prefs_update
 *
 * reads from wgtopt_list and updates in-memory preferences.  invoked just
 * before calling prefs_save() to save the new changes.
 */
void
prefs_update(void)
{
	GSList *dp;
	wgtopt_t *wdata;
	char buf[8], *data;
	int num;
	guint i;

	for (i = 0; i < wgtopt_list_cnt; i++) {
		wdata = &wgtopt_list[i];

		GNPDBG_PREFS(("prefs_update: updating '%s'\n",
			       wdata->pap->name));
		switch (wdata->pap->type) {
		case PrefBool:
			if (GTK_TOGGLE_BUTTON(GTK_BUTTON(wdata->wgt))->active)
				prefs_bool_set(wdata->pap, "true");
			else
				prefs_bool_set(wdata->pap, "false");
			break;
		case PrefString:
			if (wdata->type != GenericType)
				prefs_string_set(wdata->pap,
						 gtk_entry_get_text(
						 	GTK_ENTRY(wdata->wgt)));
			break;
		case PrefInt:
			/*
			 * ugh this is awful.  if the preference variable
			 * stores an integer, we have to allow at least a
			 * couple of ways to represent it in the prefs window.
			 * the obvious way is the text entry method, where we
			 * can simply use atoi() on the text entry.  however,
			 * in the case of document tab positioning, the value
			 * is an integer, but we want to present it as text to
			 * the user (e.g., "Left", "Right", "Top", "Bottom").
			 * to do this, we need some special case code to handle
			 * it.  i will probably rethink this in the future to
			 * see if there's a better way to do this.
			 */
			data = gtk_entry_get_text(GTK_ENTRY(wdata->wgt));

			if (wdata->type == EntryType) {
				prefs_int_set(wdata->pap, data);
			} else if (wdata->type == ComboType) {
				dp = (GSList *)(wdata->data);
				/* NOTE: prefs_wgtopt_list_free frees dp */
				num = 0;
				while (dp) {
					if (strcmp((char *)(dp->data),
						   data) == 0) {
						g_snprintf(buf, 8, "%d", num);
						prefs_int_set(wdata->pap, buf);
						break;
					}
					num++;
					dp = dp->next;
				}
			}

			break;
		default:
			printf("prefs_update: ignoring '%s' (unknown type=%d)"
			       "\n", wdata->pap->name, wdata->pap->type);
			break;
		} /* switch */

		if (wdata->pap->f) {
			GNPDBG_PREFS(("prefs_update: invoking callback for "
				      "'%s'\n", wdata->pap->name));
			(wdata->pap->f)(wdata->pap->c);
		}
	} /* while wolp */
} /* prefs_update */


/*
 * PRIVATE: prefs_wgtopt_list_free
 *
 * cleans up and frees the wgtopt_list
 */
void
prefs_wgtopt_list_free(void)
{
	int i;

	for (i = 0; i < wgtopt_list_cnt; i++) {
		if (wgtopt_list[i].type == ComboType)
			g_list_free((GList *)wgtopt_list[i].data);
		else
			g_slist_free((GSList *)wgtopt_list[i].data);
	}

	g_free(wgtopt_list);
	wgtopt_list = NULL;
	wgtopt_list_cnt = 0;
} /* prefs_wgtopt_list_free */


#ifdef USE_GNOME
static void
prefs_modified(GtkWidget *wgt, gpointer cbdata)
{
	gnome_property_box_changed(GNOME_PROPERTY_BOX(prefs_win));
} /* prefs_modified */


/*
 * scan the wgtopt_list and connect each widget's signal to the prefs_modified
 * callback, so that the gnome helper dialog knows when something has been
 * changed.
 */
static void
prefs_wgtopt_list_modified(void)
{
	int i;

	for (i = 0; i < wgtopt_list_cnt; i++) {
		if (GTK_IS_ENTRY(wgtopt_list[i].wgt)) {
			gtk_signal_connect(GTK_OBJECT(wgtopt_list[i].wgt),
					   "changed",
					   GTK_SIGNAL_FUNC(prefs_modified),
					   NULL);
		} else if (GTK_IS_BUTTON(wgtopt_list[i].wgt)) {
			gtk_signal_connect(GTK_OBJECT(wgtopt_list[i].wgt),
					   "clicked",
					   GTK_SIGNAL_FUNC(prefs_modified),
					   NULL);
		} else
			g_warning("unknown button type\n");
	}
} /* prefs_wgtopt_list_modified */
#endif	/* USE_GNOME */


/*
 * PRIVATE: prefs_win_destroy
 *
 * destroys the prefs window and cleans up the wgtopt_list
 */
static void
prefs_win_destroy(GtkWidget *wgt, gpointer cbdata)
{
	GNPDBG_PREFS(("prefs_win_destroy() entered\n"));
	prefs_wgtopt_list_free();
	prefs_win = NULL;
} /* prefs_win_destroy */


/* the end */
