/***************************************************************************
                            kde_CharacterData.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_CHARACTERDATA
#define KDE_CHARACTERDATA

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 The <code> CharacterData </code> interface extends Node with a set
 of attributes and methods for accessing character data in the DOM.
 For clarity this set is defined here rather than on each object
 that uses these attributes and methods. No DOM objects correspond
 directly to <code> CharacterData </code> , though <code> Text
 </code> and others do inherit the interface from it. All <code>
 offset</code>s in this interface start from 0.

 
 @short 
 The <code> CharacterData </code> interface extends Node with a set
 of attributes and methods for accessing character data in the DOM.
*/
kde_CharacterData * kde_new_CharacterData();
kde_CharacterData * kde_new_CharacterData1(kde_CharacterData* other);
kde_CharacterData * kde_new_CharacterData2(kde_DOMNode* other);
void kde_del_CharacterData( kde_CharacterData* p );

/** 
 The character data of the node that implements this interface.
 The DOM implementation may not put arbitrary limits on the
 amount of data that may be stored in a <code> CharacterData
 </code> node. However, implementation limits may mean that the
 entirety of a node's data may not fit into a single <code>
 DOMString </code> . In such cases, the user may call <code>
 substringData </code> to retrieve the data in appropriately
 sized pieces.

     
*/
kde_DOMString* kde_CharacterData_data(kde_CharacterData* instPointer);

/** 
 see @ref data

     
*/
void kde_CharacterData_setData(kde_CharacterData* instPointer,kde_DOMString* arg1);

/** 
 The number of characters that are available through <code> data
 </code> and the <code> substringData </code> method below. This
 may have the value zero, i.e., <code> CharacterData </code>
 nodes may be empty.

     
*/
unsigned long kde_CharacterData_length(kde_CharacterData* instPointer);

/** 
 Extracts a range of data from the node.

  DOMSTRING_SIZE_ERR: Raised if the specified range of text does
 not fit into a <code> DOMString </code> .

     
*/
kde_DOMString* kde_CharacterData_substringData(kde_CharacterData* instPointer,unsigned long offset, unsigned long count);

/** 
 Append the string to the end of the character data of the node.
 Upon success, <code> data </code> provides access to the
 concatenation of <code> data </code> and the <code> DOMString
 </code> specified.

     
*/
void kde_CharacterData_appendData(kde_CharacterData* instPointer,kde_DOMString* arg);

/** 
 Insert a string at the specified character offset.

  NO_MODIFICATION_ALLOWED_ERR: Raised if this node is readonly.

     
*/
void kde_CharacterData_insertData(kde_CharacterData* instPointer,unsigned long offset, kde_DOMString* arg);

/** 
 Remove a range of characters from the node. Upon success,
 <code> data </code> and <code> length </code> reflect the
 change.

  NO_MODIFICATION_ALLOWED_ERR: Raised if this node is readonly.

     
*/
void kde_CharacterData_deleteData(kde_CharacterData* instPointer,unsigned long offset, unsigned long count);

/** 
 Replace the characters starting at the specified character
 offset with the specified string.

  NO_MODIFICATION_ALLOWED_ERR: Raised if this node is readonly.

     
*/
void kde_CharacterData_replaceData(kde_CharacterData* instPointer,unsigned long offset, unsigned long count, kde_DOMString* arg);

#endif
