/***************************************************************************
                            kde_KIconDialog.h -  description
                             -------------------
    begin                : Tue Mar 19 20:11:49 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Tue Mar 19 20:11:49 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KICONDIALOG
#define KDE_KICONDIALOG

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 Dialog for interactive selection of icons. Use the function
 getIcon() let the user select an icon.

 @short An icon selection dialog.
 
*/

/** 
 Constructs an icon selection dialog using the global iconloader.
     
*/
kde_KIconDialog * kde_new_KIconDialog(qt_QWidget * parent, char* name);

/** 
 Constructs an icon selection dialog using a specific iconloader.
     
*/
kde_KIconDialog * kde_new_KIconDialog1(kde_KIconLoader* loader, qt_QWidget * parent, char* name);

/** 
 Destructs the dialog.
     
*/
void kde_del_KIconDialog( kde_KIconDialog* p );

/** 
 Sets a strict icon size policy for allowed icons. When true,
 only icons of the specified group's size in @ref getIcon() are shown.
 When false, icons not available at the desired group's size will
 also be selectable.
     
*/
void kde_KIconDialog_setStrictIconSize(kde_KIconDialog* instPointer,int b);

/** 
 Returns true if a strict icon size policy is set.
     
*/
int kde_KIconDialog_strictIconSize(kde_KIconDialog* instPointer);

/** 
 Sets the size of the icons to be shown / selected.

*/
void kde_KIconDialog_setIconSize(kde_KIconDialog* instPointer,int size);

/** 
 Returns the iconsize set via @ref setIconSize() or 0, if the default
 iconsize will be used.
     
*/
int kde_KIconDialog_iconSize(kde_KIconDialog* instPointer);

/** 

     
*/
qt_QString * kde_KIconDialog_selectIcon(kde_KIconDialog* instPointer,int group, int context, int user);

/** 
 Allows you to set the same parameters as in the class method
 @ref getIcon().
     
*/
void kde_KIconDialog_setup(kde_KIconDialog* instPointer,int group, int context, int strictIconSize, int iconSize, int user);

/** 
 exec()utes this modal dialog and returns the name of the selected icon,
 or QString::null if the dialog was aborted.

*/
qt_QString * kde_KIconDialog_openDialog(kde_KIconDialog* instPointer);

/** 
 Pops up the dialog an lets the user select an icon.

*/
qt_QString * kde_KIconDialog_getIcon( int group, int context, int strictIconSize, int iconSize, int user, qt_QWidget * parent, qt_QString * caption);
void kde_KIconDialog_virtual_hook(kde_KIconDialog* instPointer,int identifier, void* data);

#endif
