/***************************************************************************
                            kde_KRootPixmap.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KROOTPIXMAP
#define KDE_KROOTPIXMAP

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 Creates pseudo-transparent widgets.

 A pseudo-transparent widget is a widget with its background pixmap set to
 that part of the desktop background that it is currently obscuring. This
 gives a transparency effect.

 To create a transparent widget, construct a KRootPixmap and pass it a
 pointer to your widget. That's it! Moving, resizing and background changes
 are handled automatically.

 Instead of using the default behaviour, you can ask KRootPixmap
 to emit a @ref backgroundUpdated(const QPixmap &) signal whenever
 the background needs updating by using @ref setCustomPainting(bool).
 Alternatively by reimplementing @ref updateBackground(KSharedPixmap*)
 you can take complete control of the behaviour.

 @author Geert Jansen <jansen@kde.org>

 @version $Id: kde_KRootPixmap.h,v 1.3 2002/02/21 00:43:13 rdale Exp $
 
 @short 
 Creates pseudo-transparent widgets.
*/

/** 
 Constructs a KRootPixmap. The KRootPixmap will be created as a child
 of the target widget so it will be deleted automatically when the
 widget is destroyed.

*/
kde_KRootPixmap * kde_new_KRootPixmap(qt_QWidget * target, char* name);

/** 
 Constructs a KRootPixmap where the parent QObject and target QWidget are
 different.
     
*/
kde_KRootPixmap * kde_new_KRootPixmap1(qt_QWidget * target, qt_QObject * parent, char* name);

/** 
 Destructs the object.
     
*/
void kde_del_KRootPixmap( kde_KRootPixmap* p );

/** 
 Checks if pseudo-transparency is available.

*/
int kde_KRootPixmap_isAvailable(kde_KRootPixmap* instPointer);

/** 
 Returns true if the KRootPixmap is active.
     
*/
int kde_KRootPixmap_isActive(kde_KRootPixmap* instPointer);

/** 
 Returns the number of the current desktop.
     
*/
int kde_KRootPixmap_currentDesktop(kde_KRootPixmap* instPointer);

/** 
 Returns true if custom painting is enabled, false otherwise.

*/
int kde_KRootPixmap_customPainting(kde_KRootPixmap* instPointer);

/** 
 Deprecated, use @ref isAvailable() instead.

     
*/
int kde_KRootPixmap_checkAvailable(kde_KRootPixmap* instPointer,int arg1);

/** 
 Starts background handling.
     
*/
void kde_KRootPixmap_start(kde_KRootPixmap* instPointer);

/** 
 Stops background handling.
     
*/
void kde_KRootPixmap_stop(kde_KRootPixmap* instPointer);

/** 
 Sets the fade effect.

 This effect will fade the background to the
 specified color.

*/
void kde_KRootPixmap_setFadeEffect(kde_KRootPixmap* instPointer,double strength, qt_QColor * color);

/** 
 Repaints the widget background. Normally, you shouldn't need this
 as it is handled automatically.

*/
void kde_KRootPixmap_repaint(kde_KRootPixmap* instPointer,int force);

/** 
 Repaints the widget background. Normally, you shouldn't need this
 as it is handled automatically. This is equivalent to calling
 repaint( false ).
     
*/
void kde_KRootPixmap_repaint1(kde_KRootPixmap* instPointer);

/** 
 Enables custom handling of the background painting. If custom
 painting is enabled then KRootPixmap will emit a
 @ref backgroundUpdated() signal when the background for the
 target widget changes, instead of applying the new background.
     
*/
void kde_KRootPixmap_setCustomPainting(kde_KRootPixmap* instPointer,int enable);

/** 
 Asks KDesktop to export the desktop background as a KSharedPixmap.
 This method uses DCOP to call KBackgroundIface/setExport(int).
     
*/
void kde_KRootPixmap_enableExports(kde_KRootPixmap* instPointer);

/** 
 Reimplemented to filter the events from the target widget and
 track its movements.
     
*/
int kde_KRootPixmap_eventFilter(kde_KRootPixmap* instPointer,qt_QObject * arg1, qt_QEvent * arg2);

/** 
 Called when the pixmap has been updated. The default implementation
 applies the fade effect, then sets the target's background, or emits
 @ref backgroundUpdated(const QPixmap &) depending on the painting mode.
     
*/
void kde_KRootPixmap_updateBackground(kde_KRootPixmap* instPointer,kde_KSharedPixmap* arg1);

#endif
