/***************************************************************************
                            kde_KServerSocket.h -  description
                             -------------------
    begin                : Tue Mar 19 20:11:49 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Tue Mar 19 20:11:49 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KSERVERSOCKET
#define KDE_KSERVERSOCKET

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**


 Please use the more powerful KExtendedSocket class.

 You can use a KServerSocket to listen on a port for incoming
 connections. When a connection arrived in the port, a KSocket
 is created and the signal accepted is raised. Make sure you
 always connect to this signal. If you don't the ServerSocket will
 create new KSocket's and no one will delete them!

 If socket() is -1 or less the socket was not created properly.

 @author Torben Weis <weis@stud.uni-frankfurt.de>

 @version $Id: kde_KServerSocket.h,v 1.4 2002/03/19 22:28:04 rdale Exp $

 @short Monitors a port for incoming TCP/IP connections.

*/

/** 
 Constructor.

*/
kde_KServerSocket * kde_new_KServerSocket(unsigned short _port, int _bind);

/** 
 Creates a UNIX domain server socket.

*/
kde_KServerSocket * kde_new_KServerSocket1(char* _path, int _bind);

/**  
 Destructor. Closes the socket if it was not already closed.
     
*/
void kde_del_KServerSocket( kde_KServerSocket* p );

/** 
 Binds the socket and start listening. This should only be called
 once when the constructor was called with _bind false.

*/
int kde_KServerSocket_bindAndListen(kde_KServerSocket* instPointer);

/**  
 Returns the file descriptor associated with the socket.
 Returns -1 when an error occured during construction or
 @ref bindAndListen
     
*/
int kde_KServerSocket_socket(kde_KServerSocket* instPointer);

/**  
 Returns the port number which is being monitored.
     
*/
unsigned short kde_KServerSocket_port(kde_KServerSocket* instPointer);

/**  
 The address.
 This is dumb. Don't use it
 Refer to @ref KExtendedSocket::localAddress(int)

     
*/
unsigned long kde_KServerSocket_ipv4_addr(kde_KServerSocket* instPointer);

/**  
 Called when someone connected to our port.
     
*/
void kde_KServerSocket_slotAccept(kde_KServerSocket* instPointer,int arg1);
int kde_KServerSocket_init(kde_KServerSocket* instPointer,short int);
int kde_KServerSocket_init1(kde_KServerSocket* instPointer,char* _path);

#endif
