/***************************************************************************
                            KCodecs.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A wrapper class for the most commonly used encoding and
 decoding algorithms.  Currently there is support for encoding
 and decoding input using base64, uu and the quoted-printable
 specifications.

 <PRE>
 QCString input = "Aladdin:open sesame";
 QCString result = KCodecs.base64Encode(input);
 cout << "Result: " << result.data() << endl;

 Output should be
 Result: QWxhZGRpbjpvcGVuIHNlc2FtZQ==
 </PRE>

 The above example makes use of the convenience functions
 (ones that accept/return null-terminated strings) to encode/decode
 a string.  If what you need is to encode or decode binary data, then
 it is highly recommended that you use the functions that take an input
 and output byte[] as arguments.  These functions are specifically
 tailored for encoding and decoding binary data.

 @author Rik Hemsley <rik@kde.org>
 
 @short A collection of commonly used encoding and decoding algorithms.

*/
public class  KCodecs implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KCodecs(Class dummy){}


/** 
 Encodes the given data using the quoted-printable algorithm.

*/
	public static native String quotedPrintableEncode( byte[] in, boolean useCRLF);

/** 
 @overload

 Same as above except it accepts a null terminated
 string instead an array.

*/
	public static native String quotedPrintableEncode( String str, boolean useCRLF);

/** 
 Encodes the given data using the quoted-printable algorithm.

 Use this function if you want the result of the encoding
 to be placed in another array which cuts down the number
 of copy operation that have to be performed in the process.
 This is also the preferred method for encoding binary data.

 NOTE: the output array is first reset and then resized
 appropriately before use, hence, all data stored in the
 output array will be lost.

*/
	public static native void quotedPrintableEncode( byte[] in, byte[] out, boolean useCRLF);

/** 
 Decodes a quoted-printable encoded string.

 Accepts data with CRLF or standard unix line breaks.

*/
	public static native String quotedPrintableDecode( byte[] in);

/** 
 @overload

 Same as above except it accepts a null terminated
 string instead an array.

*/
	public static native String quotedPrintableDecode( String str);

/** 
 Decodes a quoted-printable encoded data.

 Accepts data with CRLF or standard unix line breaks.
 Use this function if you want the result of the decoding
 to be placed in another array which cuts down the number
 of copy operation that have to be performed in the process.
 This is also the preferred method for decoding an encoded
 binary data.

 NOTE: the output array is first reset and then resized
 appropriately before use, hence, all data stored in the
 output array will be lost.

*/
	public static native void quotedPrintableDecode( byte[] in, byte[] out);

/** 
 Encodes the given data using the uuencode algorithm.

 The output is split into lines starting with the number of
 encoded octets in the line and ending with a newline.  No
 line is longer than 45 octets (60 characters), excluding the
 line terminator.

*/
	public static native String uuencode( byte[] in);

/** 
 @overload

 Same as the above functions except it accepts
 a null terminated string instead an array.

*/
	public static native String uuencode( String str);

/** 
 Encodes the given data using the uuencode algorithm.

 Use this function if you want the result of the encoding
 to be placed in another array and cut down the number of
 copy operation that have to be performed in the process.
 This is the preffered method for encoding binary data.

 NOTE: the output array is first reset and then resized
 appropriately before use, hence, all data stored in the
 output array will be lost.

*/
	public static native void uuencode( byte[] in, byte[] out);

/** 
 Decodes the given data using the uuencode algorithm.

 Any 'begin' and 'end' lines like those generated by
 the utilities in unix and unix-like OS will be
 automatically ignored.

*/
	public static native String uudecode( byte[] in);

/** 
 @overload

 Same as the above functions except it accepts
 a null terminated string instead an array.

*/
	public static native String uudecode( String str);

/** 
 Decodes the given data using the uudecode algorithm.

 Use this function if you want the result of the decoding
 to be placed in another array which cuts down the number
 of copy operation that have to be performed in the process.
 This is the preferred method for decoding binary data.

 Any 'begin' and 'end' lines like those generated by
 the utilities in unix and unix-like OS will be
 automatically ignored.

 NOTE: the output array is first reset and then resized
 appropriately before use, hence, all data stored in the
 output array will be lost.

*/
	public static native void uudecode( byte[] in, byte[] out);

/** 
 Encodes the given data using the base64 algorithm.

 The boolean argument determines if the encoded data is
 going to be restricted to 76 characters or less per line
 as specified by RFC 2045.  If <code>insertLFs</code> is true, then
 there will be 76 characters or less per line.

*/
	public static native String base64Encode( byte[] in, boolean insertLFs);

/** 
 @overload

 Same as the above functions except it accepts
 a null terminated string instead an array.

*/
	public static native String base64Encode( String str, boolean insertLFs);

/** 
 Encodes the given data using the base64 algorithm.

 Use this function if you want the result of the encoding
 to be placed in another array which cuts down the number
 of copy operation that have to be performed in the process.
 This is also the preferred method for encoding binary data.

 The boolean argument determines if the encoded data is going
 to be restricted to 76 characters or less per line as specified
 by RFC 2045.  If <code>insertLFs</code> is true, then there will be 76
 characters or less per line.

 NOTE: the output array is first reset and then resized
 appropriately before use, hence, all data stored in the
 output array will be lost.

*/
	public static native void base64Encode( byte[] in, byte[] out, boolean insertLFs);
	public static native void base64Encode( byte[] in, byte[] out);

/** 
 Decodes the given data that was encoded using the
 base64 algorithm.

*/
	public static native String base64Decode( byte[] in);

/** 
 @overload

 Same as the above functions except it accepts
 a null terminated string instead an array.

*/
	public static native String base64Decode( String str);

/** 
 Decodes the given data that was encoded with the base64
 algorithm.

 Use this function if you want the result of the decoding
 to be placed in another array which cuts down the number
 of copy operation that have to be performed in the process.
 This is also the preferred method for decoding an encoded
 binary data.

 NOTE: the output array is first reset and then resized
 appropriately before use, hence, all data stored in the
 output array will be lost.

*/
	public static native void base64Decode( byte[] in, byte[] out);
}
