/***************************************************************************
                            KDockMainWindow.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A special kind of {@link KMainWindow} that is able to have dockwidget child widgets (and member of the dockwidget class set).

 The main widget should be a {@link KDockWidget} where other {@link KDockWidget} can be docked to
 the left, right, top, bottom or to the middle.
 Note: dock to the middle means to drop on a dockwidget and to unite them to a new widget, a tab control.

 Furthermore, the KDockMainWindow has got the {@link KDockManager} and some data about the dock states.

 If you've got some dockwidgets, you can dock them to the dockmainwindow to initialize a start scene:
 Here an example:
 <PRE>
 DockApplication.DockApplication( String name) : KDockMainWindow( name)
 {
   ...
   KDockWidget mainDock;
   mainDock = createDockWidget( "Falk's MainDockWidget", mainPixmap, null, "main_dock_widget");
   AnyContentsWidget cw = new AnyContentsWidget( mainDock);
   mainDock.setWidget( cw);
   // allow others to dock to the 4 sides
   mainDock.setDockSite(KDockWidget.DockCorner);
   // forbit docking abilities of mainDock itself
   mainDock.setEnableDocking(KDockWidget.DockNone);
   setView( mainDock); // central widget in a KDE mainwindow
   setMainDockWidget( mainDock); // master dockwidget
   ...
   KDockWidget dockLeft;
   dockLeft = createDockWidget( "Intially left one", anyOtherPixmap, null, i18n("The left dockwidget"));
   AnotherWidget aw = new AnotherWidget( dockLeft);
   dockLeft.setWidget( aw);
   dockLeft.manualDock( mainDock,              // dock target
                         KDockWidget.DockLeft, // dock site
                         20 );                  // relation target/this (in percent)
   ...
 </PRE>

 Docking is fully dynamical at runtime. That means you can always move dockwidgets via drag and drop.

 And last but not least you can use the popupmenu for showing or hiding any controlled dockwidget
 of this class and insert it to your main menu bar or anywhere else.

 See {@link KDockMainWindowSignals} for signals emitted by KDockMainWindow.

 See {@link KDockMainWindowEventHandling} for event handlers to override in subclasses of KDockMainWindow.

 @author Max Judin (documentation: Falk Brettschneider).
 
 @short 
 A special kind of @ref KMainWindow that is able to have dockwidget child widgets (and member of the dockwidget class set).
*/
public class KDockMainWindow extends KMainWindow  {
	protected KDockMainWindow(Class dummy){super((Class) null);}

	private native void newKDockMainWindow( QWidget parent, String name, int f);

/** 
 Constructs a dockmainwindow. It calls its base class constructor and does additional things concerning
 to the dock stuff:

*/
	public KDockMainWindow( QWidget parent, String name, int f) {
		super((Class) null);
		newKDockMainWindow( parent, name, f);
	}
	private native void newKDockMainWindow();
	public KDockMainWindow() {
		super((Class) null);
		newKDockMainWindow();
	}

/** 
 Destructs a dockmainwindow.
   
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Returns the dockmanager of this. (see {@link KDockManager})

*/
	public native KDockManager manager();

/** 
 Sets a new main dockwidget.
 Additionally, the toolbar is re-initialized.

*/
	public native void setMainDockWidget( KDockWidget arg1);

/** 
 Returns the main dockwidget.

*/
	public native KDockWidget getMainDockWidget();

/** 
 This is one of the most important methods!
 The KDockMainWindow creates a new dockwidget object here that usually should encapsulate the user's widget.
 The new dockwidget is automatically taken under control by the dockmanager of the dockmainwindow.

*/
	public native KDockWidget createDockWidget( String name, QPixmap pixmap, QWidget parent, String strCaption, String strTabPageLabel);
	public native KDockWidget createDockWidget( String name, QPixmap pixmap);

/** 
 Saves the current dock window layout into a DOM tree below the given element.
   
*/
	public native void writeDockConfig( QDomElement base);

/** 
 Reads the current dock window layout from a DOM tree below the given element.
   
*/
	public native void readDockConfig( QDomElement base);

/** 
 It writes the current dock state in the given section of KConfig.

*/
	public native void writeDockConfig( KConfig c, String group);
	public native void writeDockConfig();

/** 
 It reads the current dock state from the given section of KConfig.

*/
	public native void readDockConfig( KConfig c, String group);
	public native void readDockConfig();

/** 
 It runs through all dockwidgets which are under control of the dockmanager and calls show() for every
 encapsulated widget and show() for the dockwidget itself if it is not in tab mode.
 Additionally, if the main dockwidget is not a QDialog, it will be shown.
   
*/
	public native void activateDock();

/** 
 Returns a popup menu that contains entries for all controlled dockwidgets making hiding and showing
 them possible.

*/
	public native QPopupMenu dockHideShowMenu();

/** 
 This method shows the given dockwidget.
 The clue is that it also considers the dockwidget could be a tab page
 and must set to be the activate one.

*/
	public native void makeDockVisible( KDockWidget dock);

/** 
 This method hides the given dockwidget.

*/
	public native void makeDockInvisible( KDockWidget dock);

/** 
 This is an overloaded member function, provided for convenience.
 It differs from the above function only in what argument(s) it accepts.
   
*/
	public native void makeWidgetDockVisible( QWidget widget);

/** 
 This method calls the base class method.
 If the given widget inherits KDockWidget, applyToWidget(this) is called.

*/
	public native void setView( QWidget arg1);

/** 
 Called whenever one of the dockwidgets of this has been undocked.
  
*/
	protected native void slotDockWidgetUndocked();
}
